/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.debug;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.run.GwtDevModeServer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import icons.VaadinIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaadinDevModeServer
extends GwtDevModeServer {
    private static final Logger LOG = Logger.getInstance(VaadinDevModeServer.class);

    public VaadinDevModeServer() {
        super("vaadin-jetty-launcher", "Vaadin Jetty Launcher");
    }

    @Nullable
    public Icon getIcon() {
        return VaadinIcons.Vaadin_icon;
    }

    public void patchParameters(@NotNull JavaParameters parameters, String originalOutputDir, @NotNull GwtFacet gwtFacet) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/vaadin/debug/VaadinDevModeServer", "patchParameters"));
        }
        if (gwtFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtFacet", "com/intellij/vaadin/debug/VaadinDevModeServer", "patchParameters"));
        }
        ParametersList params = parameters.getProgramParametersList();
        params.add("-server");
        params.add("com.intellij.vaadin.rt.VaadinDevModeJettyLauncher:" + originalOutputDir);
        File vaadinClassesRoot = new File(PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()));
        File vaadinLibDir = vaadinClassesRoot.isDirectory() ? new File(PathManager.getHomePath(), "plugins/vaadin/rt/lib") : new File(vaadinClassesRoot.getParentFile(), "rt");
        File vaadinJettyLauncherJar = new File(vaadinLibDir, "vaadin-jetty-launcher.jar");
        LOG.assertTrue(vaadinJettyLauncherJar.exists(), (Object)(vaadinJettyLauncherJar + " doesn't exist"));
        parameters.getClassPath().add(vaadinJettyLauncherJar);
    }

    @NotNull
    public String patchWarDirectoryPath(@NotNull String warDirectoryPath) {
        if (warDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warDirectoryPath", "com/intellij/vaadin/debug/VaadinDevModeServer", "patchWarDirectoryPath"));
        }
        String string = new File(warDirectoryPath, "VAADIN/widgetsets").getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vaadin/debug/VaadinDevModeServer", "patchWarDirectoryPath"));
        }
        return string;
    }
}

