/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.hchart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.chart.hchart.HNode;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.common.AdtUiUtils;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTreeChart<T>
extends AnimatedComponent
implements MouseWheelListener {
    private Orientation mOrientation;
    @Nullable
    private HRenderer<T> mHRenderer;
    @NotNull
    private HNode<T> mRoot = new HNode();
    @Nullable
    private Range mXRange;
    @NotNull
    private Range mYRange;
    @NotNull
    private Rectangle2D.Float mRect = new Rectangle2D.Float();
    private static final String NO_HTREE = "No HTree selected.";
    private static final String NO_RANGE = "X range width is zero: Please use a wider range.";
    private static final int BORDER_PLUS_PADDING = 2;
    private static final int ZOOM_FACTOR = 20;

    public HTreeChart() {
        this.mYRange = new Range();
        this.addMouseWheelListener(this);
        this.mOrientation = Orientation.TOP_DOWN;
    }

    public HTreeChart(Orientation orientation) {
        this();
        this.mOrientation = orientation;
    }

    @Override
    protected void updateData() {
    }

    @Override
    protected void draw(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.mRoot.getChildren().size() == 0) {
            g.drawString(NO_HTREE, this.getWidth() / 2 - this.mDefaultFontMetrics.stringWidth(NO_HTREE), this.getHeight() / 2);
            return;
        }
        if (this.getXRange().getLength() == 0.0) {
            g.drawString(NO_RANGE, this.getWidth() / 2 - this.mDefaultFontMetrics.stringWidth(NO_RANGE), this.getHeight() / 2);
            return;
        }
        Stack stack = new Stack();
        stack.addAll(this.mRoot.getChildren());
        while (!stack.isEmpty()) {
            HNode n = (HNode)stack.pop();
            this.renderHNode(g, n);
            stack.addAll(n.getChildren());
        }
    }

    private void renderHNode(Graphics2D g, HNode<T> n) {
        double rightEdge;
        if ((double)n.getStart() > this.getXRange().getMax() || (double)n.getEnd() < this.getXRange().getMin()) {
            return;
        }
        double leftEdge = this.rangeToPosition(n.getStart());
        if (leftEdge < 0.0) {
            leftEdge = 0.0;
        }
        if ((rightEdge = this.rangeToPosition(n.getEnd())) > (double)this.getWidth()) {
            rightEdge = this.getWidth();
        }
        double width = rightEdge - leftEdge;
        this.mRect.x = (float)leftEdge;
        this.mRect.y = (float)((double)((this.mDefaultFontMetrics.getHeight() + 2) * n.getDepth()) - this.getYRange().getMin());
        this.mRect.width = (float)width - 2.0f;
        this.mRect.height = this.mDefaultFontMetrics.getHeight();
        if (this.mOrientation == Orientation.BOTTOM_UP) {
            this.mRect.y = (float)this.getHeight() - this.mRect.y;
        }
        this.mHRenderer.render(g, n.getData(), this.mRect);
    }

    private double rangeToPosition(double v) {
        double translate = -this.getXRange().getMin();
        double scale = (double)this.getWidth() / (this.getXRange().getMax() - this.getXRange().getMin());
        return (v + translate) * scale;
    }

    private double positionToRange(double x) {
        return x / (double)this.getWidth() * this.getXRange().getLength() + this.getXRange().getMin();
    }

    public void setHRenderer(HRenderer<T> r) {
        this.mHRenderer = r;
        this.mHRenderer.setFont((Font)AdtUiUtils.DEFAULT_FONT);
    }

    public void setHTree(HNode<T> root) {
        this.mRoot = root;
    }

    public Range getXRange() {
        return this.mXRange;
    }

    public void setXRange(Range XRange) {
        this.mXRange = XRange;
    }

    public Range getYRange() {
        return this.mYRange;
    }

    public int getMaximumHeight() {
        int maxDepth = -1;
        Stack stack = new Stack();
        stack.addAll(this.mRoot.getChildren());
        while (!stack.isEmpty()) {
            HNode n = (HNode)stack.pop();
            if (n.getDepth() > maxDepth) {
                maxDepth = n.getDepth();
            }
            stack.addAll(n.getChildren());
        }
        return (this.mDefaultFontMetrics.getHeight() + 2) * ++maxDepth;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double cursorRange = this.positionToRange(e.getX());
        double leftDelta = (cursorRange - this.getXRange().getMin()) / 20.0 * (double)e.getWheelRotation();
        double rightDelta = (this.getXRange().getMax() - cursorRange) / 20.0 * (double)e.getWheelRotation();
        this.getXRange().setMin(this.getXRange().getMin() - leftDelta);
        this.getXRange().setMax(this.getXRange().getMax() + rightDelta);
    }

    public static enum Orientation {
        TOP_DOWN,
        BOTTOM_UP;

    }
}

