/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestFinder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFinder
implements TestFinder {
    private static final String[] SUFFIXES = new String[]{"Spec", "-spec", "_spec", ".spec", "Test", "-test", "_test", ".test"};
    private static final String[] TEST_DIR_NAMES = new String[]{"spec", "test", "specs", "tests", "testSrc"};

    @Nullable
    public PsiElement findSourceElement(@NotNull PsiElement from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/javascript/testFramework/JsTestFinder", "findSourceElement"));
        }
        return JsTestFinder.getPhysicalFile(from);
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testFramework/JsTestFinder", "findTestsForClass"));
        }
        JSFile psiFile = JsTestFinder.getPhysicalFile(element);
        VirtualFile virtualFile = file = psiFile != null ? psiFile.getVirtualFile() : null;
        if (file == null || psiFile.isTestFile()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "findTestsForClass"));
            }
            return list;
        }
        List<VirtualFile> testFiles = JsTestFinder.findTestFiles(element.getProject(), file);
        List<PsiElement> list = JsTestFinder.toPsiFiles(element.getManager(), testFiles);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "findTestsForClass"));
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> findTestFiles(@NotNull Project project, @NotNull VirtualFile srcFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/JsTestFinder", "findTestFiles"));
        }
        if (srcFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcFile", "com/intellij/javascript/testFramework/JsTestFinder", "findTestFiles"));
        }
        String nameWithoutExtension = srcFile.getNameWithoutExtension();
        String extension = srcFile.getExtension();
        ArrayList result = ContainerUtil.newArrayList();
        for (String suffix : SUFFIXES) {
            String possibleTestName = nameWithoutExtension + suffix + "." + extension;
            result.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)possibleTestName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        }
        List<VirtualFile> testFiles = JsTestFinder.findSameNamedFiles(project, srcFile, true);
        result.addAll(testFiles);
        List<VirtualFile> list = JsTestFinder.sortAndUnique(project, result, srcFile);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "findTestFiles"));
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> findSameNamedFiles(@NotNull Project project, @NotNull VirtualFile file, boolean searchForTest) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/JsTestFinder", "findSameNamedFiles"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/JsTestFinder", "findSameNamedFiles"));
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile contentRoot = fileIndex.getContentRootForFile(file, false);
        if (contentRoot == null || !contentRoot.isValid()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "findSameNamedFiles"));
            }
            return list;
        }
        ArrayList path = ContainerUtil.newArrayList();
        for (VirtualFile dir = file.getParent(); dir != null; dir = dir.getParent()) {
            path.add(dir);
            if (contentRoot.equals(dir)) break;
        }
        Collections.reverse(path);
        List result = ContainerUtil.newSmartList();
        if (searchForTest) {
            for (int i = 0; i < path.size() - 1; ++i) {
                VirtualFile srcDir = (VirtualFile)path.get(i + 1);
                List<VirtualFile> testDirs = JsTestFinder.findTestDirs((VirtualFile)path.get(i));
                for (VirtualFile testDir : testDirs) {
                    VirtualFile testFile;
                    if (testDir.equals(srcDir) || (testFile = JsTestFinder.findFileWithSameRelativePath(file, srcDir, testDir)) == null) continue;
                    result.add(testFile);
                }
            }
        } else {
            for (int i = 0; i < path.size() - 1; ++i) {
                VirtualFile testDir = (VirtualFile)path.get(i + 1);
                if (!ArrayUtil.contains((String)testDir.getName(), (String[])TEST_DIR_NAMES)) continue;
                for (VirtualFile child : ((VirtualFile)path.get(i)).getChildren()) {
                    VirtualFile srcFile;
                    if (testDir.equals(child) || (srcFile = JsTestFinder.findFileWithSameRelativePath(file, testDir, child)) == null) continue;
                    result.add(srcFile);
                }
            }
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "findSameNamedFiles"));
        }
        return list;
    }

    @Nullable
    private static VirtualFile findFileWithSameRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile oldBaseDir, @NotNull VirtualFile newBaseDir) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/JsTestFinder", "findFileWithSameRelativePath"));
        }
        if (oldBaseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBaseDir", "com/intellij/javascript/testFramework/JsTestFinder", "findFileWithSameRelativePath"));
        }
        if (newBaseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBaseDir", "com/intellij/javascript/testFramework/JsTestFinder", "findFileWithSameRelativePath"));
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)oldBaseDir);
        return relativePath != null ? newBaseDir.findFileByRelativePath(relativePath) : null;
    }

    @NotNull
    private static List<VirtualFile> findTestDirs(@NotNull VirtualFile commonParent) {
        if (commonParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonParent", "com/intellij/javascript/testFramework/JsTestFinder", "findTestDirs"));
        }
        List result = ContainerUtil.newSmartList();
        for (String name : TEST_DIR_NAMES) {
            VirtualFile testDir = commonParent.findChild(name);
            if (testDir == null || !testDir.isDirectory() || !testDir.isValid()) continue;
            result.add(testDir);
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "findTestDirs"));
        }
        return list;
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testFramework/JsTestFinder", "findClassesForTest"));
        }
        JSFile psiFile = JsTestFinder.getPhysicalFile(element);
        VirtualFile virtualFile = file = psiFile != null ? psiFile.getVirtualFile() : null;
        if (file == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "findClassesForTest"));
            }
            return list;
        }
        List<VirtualFile> testFiles = JsTestFinder.findSourceFiles(element.getProject(), file);
        List<PsiElement> list = JsTestFinder.toPsiFiles(element.getManager(), testFiles);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "findClassesForTest"));
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> findSourceFiles(@NotNull Project project, @NotNull VirtualFile testFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/JsTestFinder", "findSourceFiles"));
        }
        if (testFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFile", "com/intellij/javascript/testFramework/JsTestFinder", "findSourceFiles"));
        }
        String nameWithoutExtension = testFile.getNameWithoutExtension();
        String extension = testFile.getExtension();
        ArrayList result = ContainerUtil.newArrayList();
        for (String suffix : SUFFIXES) {
            if (!nameWithoutExtension.endsWith(suffix)) continue;
            String srcName = nameWithoutExtension.substring(0, nameWithoutExtension.length() - suffix.length()) + "." + extension;
            result.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)srcName, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        }
        List<VirtualFile> srcFiles = JsTestFinder.findSameNamedFiles(project, testFile, false);
        result.addAll(srcFiles);
        List<VirtualFile> list = JsTestFinder.sortAndUnique(project, result, testFile);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "findSourceFiles"));
        }
        return list;
    }

    public boolean isTest(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testFramework/JsTestFinder", "isTest"));
        }
        JSFile file = JsTestFinder.getPhysicalFile(element);
        return file != null && file.isTestFile();
    }

    @Nullable
    private static JSFile getPhysicalFile(@NotNull PsiElement element) {
        JSFile jsFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testFramework/JsTestFinder", "getPhysicalFile"));
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null) {
            psiFile = psiFile.getOriginalFile();
        }
        return (jsFile = (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class)) != null && jsFile.getVirtualFile() != null ? jsFile : null;
    }

    @NotNull
    private static List<PsiElement> toPsiFiles(@NotNull PsiManager manager, @NotNull List<VirtualFile> testFiles) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javascript/testFramework/JsTestFinder", "toPsiFiles"));
        }
        if (testFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFiles", "com/intellij/javascript/testFramework/JsTestFinder", "toPsiFiles"));
        }
        List psiFiles = ContainerUtil.map(testFiles, arg_0 -> ((PsiManager)manager).findFile(arg_0));
        List list = ContainerUtil.filter((Collection)psiFiles, (Condition)Condition.NOT_NULL);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "toPsiFiles"));
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> sortAndUnique(@NotNull Project project, @NotNull Collection<VirtualFile> relatedFiles, @NotNull VirtualFile contextFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/JsTestFinder", "sortAndUnique"));
        }
        if (relatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relatedFiles", "com/intellij/javascript/testFramework/JsTestFinder", "sortAndUnique"));
        }
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/javascript/testFramework/JsTestFinder", "sortAndUnique"));
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile contentRoot = fileIndex.getContentRootForFile(contextFile, true);
        List list = ContainerUtil.map((Collection)ContainerUtil.newHashSet(relatedFiles), file -> {
            VirtualFile cr = fileIndex.getContentRootForFile(file, false);
            return new Data((VirtualFile)file, ComparatorUtil.equalsNullable((Object)cr, (Object)contentRoot));
        });
        Collections.sort(list, (d1, d2) -> {
            if (((Data)d1).myFromTheSameContentRoot != ((Data)d2).myFromTheSameContentRoot) {
                return ((Data)d1).myFromTheSameContentRoot ? -1 : 1;
            }
            return ((Data)d1).myFile.getPath().compareTo(((Data)d2).myFile.getPath());
        });
        List list2 = ContainerUtil.map((Collection)list, data -> ((Data)data).myFile);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFinder", "sortAndUnique"));
        }
        return list2;
    }

    private static class Data {
        private final VirtualFile myFile;
        private final boolean myFromTheSameContentRoot;

        public Data(@NotNull VirtualFile file, boolean fromTheSameContentRoot) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/JsTestFinder$Data", "<init>"));
            }
            this.myFile = file;
            this.myFromTheSameContentRoot = fromTheSameContentRoot;
        }
    }
}

