/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.jboss.jbpm.model.ChartDataModel;
import com.intellij.jboss.jbpm.model.ChartEdge;
import com.intellij.jboss.jbpm.model.ChartNode;
import com.intellij.jboss.jbpm.model.ChartSource;
import com.intellij.jboss.jbpm.settings.ChartProvider;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ChartDataModelImpl<T, Node extends ChartNode<T>, Edge extends ChartEdge<T>, Source extends ChartSource>
extends ChartDataModel<T> {
    private Map<String, Node> nodes;
    private HashMap<Pair<String, String>, Edge> edges;
    @NotNull
    private final Source source;

    public ChartDataModelImpl(Project project, ChartProvider<T> provider, @NotNull Source source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/jboss/jbpm/model/ChartDataModelImpl", "<init>"));
        }
        super(project, provider);
        this.nodes = new HashMap<String, Node>();
        this.edges = new HashMap();
        this.source = source;
    }

    @Override
    @NotNull
    public Collection<Node> getNodes() {
        Collection<Node> collection = this.nodes.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/ChartDataModelImpl", "getNodes"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<Edge> getEdges() {
        Collection<Edge> collection = this.edges.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/ChartDataModelImpl", "getEdges"));
        }
        return collection;
    }

    public void refreshDataModel() {
        this.nodes.clear();
        this.edges.clear();
        this.updateDataModel();
    }

    protected Node addNode(Node node) {
        String nodeId = ((ChartNode)((Object)node)).getId();
        if (!StringUtil.isNotEmpty((String)nodeId)) {
            return null;
        }
        assert (!this.nodes.containsKey(nodeId));
        this.nodes.put(nodeId, node);
        return node;
    }

    protected Edge addEdge(Edge edge) {
        ChartNode source = ((ChartEdge)((Object)edge)).getSource();
        ChartNode target = ((ChartEdge)((Object)edge)).getTarget();
        this.edges.put((Pair<String, String>)Pair.create((Object)source.getId(), (Object)target.getId()), edge);
        return edge;
    }

    public void removeNode(DiagramNode<T> node) {
        Runnable action = this.getRemoveNodeAction((ChartNode)node);
        if (action == null) {
            return;
        }
        action.run();
    }

    @NotNull
    public final Edge createEdge(final @NotNull DiagramNode<T> from, final @NotNull DiagramNode<T> to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/jboss/jbpm/model/ChartDataModelImpl", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/jboss/jbpm/model/ChartDataModelImpl", "createEdge"));
        }
        assert (from instanceof ChartNode);
        assert (to instanceof ChartNode);
        ChartEdge chartEdge = (ChartEdge)((Object)new WriteCommandAction<Edge>(this.getProject(), "Add " + this.getProvider().getChartName() + "  edge", new PsiFile[]{this.getSource().getPsiFile()}){

            protected void run(@NotNull Result<Edge> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jboss/jbpm/model/ChartDataModelImpl$1", "run"));
                }
                result.setResult(ChartDataModelImpl.this.createEdge((ChartNode)from, (ChartNode)to));
            }
        }.execute().getResultObject());
        if (chartEdge == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/ChartDataModelImpl", "createEdge"));
        }
        return (Edge)((Object)chartEdge);
    }

    public abstract Edge createEdge(Node var1, Node var2);

    @Override
    public void removeEdge(DiagramEdge<T> edge) {
        final Runnable action = this.getRemoveEdgeAction((ChartEdge)edge);
        if (action == null) {
            return;
        }
        new WriteCommandAction<Void>(this.getProject(), "Remove " + this.getProvider().getChartName() + " edge", new PsiFile[]{this.source.getPsiFile()}){

            protected void run(@NotNull Result<Void> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jboss/jbpm/model/ChartDataModelImpl$2", "run"));
                }
                action.run();
            }
        }.execute();
    }

    protected Runnable getRemoveNodeAction(Node node) {
        final String nodeId = ((ChartNode)((Object)node)).getId();
        if (!StringUtil.isNotEmpty((String)nodeId)) {
            return null;
        }
        this.nodes.remove(nodeId);
        List edgeKeys = JBIterable.from(this.edges.keySet()).filter((Condition)new Condition<Pair<String, String>>(){

            public boolean value(Pair<String, String> pair) {
                return nodeId.equals(pair.first) || nodeId.equals(pair.second);
            }
        }).toList();
        final List edges = JBIterable.from((Iterable)edgeKeys).transform(new Function<Pair<String, String>, Edge>(){

            public Edge fun(Pair<String, String> pair) {
                return (Object)((ChartEdge)((Object)ChartDataModelImpl.this.edges.get(pair)));
            }
        }).toList();
        for (Pair pair : edgeKeys) {
            this.edges.remove(pair);
        }
        return new Runnable((ChartNode)((Object)node)){
            final /* synthetic */ ChartNode val$node;
            {
                this.val$node = chartNode;
            }

            @Override
            public void run() {
                for (ChartEdge edge : edges) {
                    edge.removeSelf();
                }
                this.val$node.removeSelf();
            }
        };
    }

    protected Runnable getRemoveEdgeAction(Edge edge) {
        ChartNode source = ((ChartEdge)((Object)edge)).getSource();
        ChartNode target = ((ChartEdge)((Object)edge)).getTarget();
        this.edges.remove(Pair.create((Object)source.getId(), (Object)target.getId()));
        return new Runnable((ChartEdge)((Object)edge)){
            final /* synthetic */ ChartEdge val$edge;
            {
                this.val$edge = chartEdge;
            }

            @Override
            public void run() {
                this.val$edge.removeSelf();
            }
        };
    }

    protected abstract void updateDataModel();

    public Edge getEdge(Pair<String, String> pair) {
        return (Edge)((Object)((ChartEdge)((Object)this.edges.get(pair))));
    }

    public Node getNode(String fqn) {
        return (Node)((Object)((ChartNode)((Object)this.nodes.get(fqn))));
    }

    @NotNull
    protected Source getSource() {
        Source Source = this.source;
        if (Source == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/ChartDataModelImpl", "getSource"));
        }
        return Source;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ChartDataModelImpl chartDataModelImpl = this;
        if (chartDataModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/ChartDataModelImpl", "getModificationTracker"));
        }
        return chartDataModelImpl;
    }
}

