/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiClassType;
import com.intellij.spring.factories.resolvers.AbstractTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanReferenceFactoryBeanTypeResolver
extends AbstractTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.beans.factory.config.BeanReferenceFactoryBean";
    @NonNls
    private static final String TARGET_NAME_PROPERTY_NAME = "targetBeanName";

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        if (context instanceof SpringBean) {
            PsiClassType fromTargetName;
            SpringBean bean = (SpringBean)context;
            String targetBeanName = BeanReferenceFactoryBeanTypeResolver.getPropertyValue(context, TARGET_NAME_PROPERTY_NAME);
            if (targetBeanName != null && (fromTargetName = BeanReferenceFactoryBeanTypeResolver.getTypeFromBeanName(bean, targetBeanName)) != null) {
                Set<String> set = Collections.singleton(fromTargetName.getCanonicalText());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/BeanReferenceFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/BeanReferenceFactoryBeanTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/BeanReferenceFactoryBeanTypeResolver", "accept"));
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }
}

