/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringObjectFactoryEffectiveTypeProvider
extends SpringBeanEffectiveTypeProvider {
    public void processEffectiveTypes(@NotNull CommonSpringBean bean, Collection<PsiType> result) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/SpringObjectFactoryEffectiveTypeProvider", "processEffectiveTypes"));
        }
        PsiType beanType = bean.getBeanType();
        ContainerUtil.addIfNotNull(result, (Object)SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(beanType));
    }

    @Nullable
    public static PsiType getObjectFactoryEffectiveType(@Nullable PsiType beanType) {
        if (beanType instanceof PsiClassType) {
            PsiClassType type = (PsiClassType)beanType;
            if (SpringObjectFactoryEffectiveTypeProvider.isObjectFactory(type)) {
                return SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryType(type);
            }
            if (SpringObjectFactoryEffectiveTypeProvider.isInjectProvider(type)) {
                return SpringObjectFactoryEffectiveTypeProvider.getInjectProviderType(type);
            }
        }
        return null;
    }

    public static boolean isObjectFactory(@NotNull PsiClassType aType) {
        if (aType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aType", "com/intellij/spring/model/SpringObjectFactoryEffectiveTypeProvider", "isObjectFactory"));
        }
        return InheritanceUtil.isInheritor((PsiClass)aType.resolve(), (String)"org.springframework.beans.factory.ObjectFactory");
    }

    public static boolean isInjectProvider(@NotNull PsiClassType aType) {
        if (aType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aType", "com/intellij/spring/model/SpringObjectFactoryEffectiveTypeProvider", "isInjectProvider"));
        }
        return InheritanceUtil.isInheritor((PsiClass)aType.resolve(), (String)"javax.inject.Provider");
    }

    @Nullable
    public static PsiType getInjectProviderType(@NotNull PsiClassType classType) {
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/spring/model/SpringObjectFactoryEffectiveTypeProvider", "getInjectProviderType"));
        }
        return PsiUtil.substituteTypeParameter((PsiType)classType, (String)"javax.inject.Provider", (int)0, (boolean)false);
    }

    @Nullable
    public static PsiType getObjectFactoryType(@NotNull PsiClassType classType) {
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/spring/model/SpringObjectFactoryEffectiveTypeProvider", "getObjectFactoryType"));
        }
        return PsiUtil.substituteTypeParameter((PsiType)classType, (String)"org.springframework.beans.factory.ObjectFactory", (int)0, (boolean)false);
    }
}

