/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LanguageAnnotationSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationSupport;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import com.intellij.spring.model.actions.generate.SpringGenerateTemplatesHolder;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateAutowiredDependenciesUtil {
    public static List<SpringGenerateTemplatesHolder> generateAutowiredDependenciesFor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "generateAutowiredDependenciesFor"));
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
        Project project = psiClass.getProject();
        Condition condition = pointer -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "lambda$generateAutowiredDependenciesFor$0"));
            }
            return !pointer.getContainingFile().equals(psiClass.getContainingFile());
        };
        List<SpringBeanPointer> dependencies = GenerateSpringBeanDependenciesUtil.chooseDependentBeans(GenerateSpringBeanDependenciesUtil.getAutowiredBeanCandidates(model, (Condition<SpringBeanPointer>)condition), project, true);
        return GenerateAutowiredDependenciesUtil.generateAutowiredDependencies(psiClass, dependencies, model);
    }

    public static List<SpringGenerateTemplatesHolder> generateAutowiredDependencies(final @NotNull PsiClass psiClass, final List<SpringBeanPointer> dependencies, final CommonSpringModel model) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "generateAutowiredDependencies"));
        }
        return (List)new WriteCommandAction<List<SpringGenerateTemplatesHolder>>(psiClass.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<List<SpringGenerateTemplatesHolder>> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil$1", "run"));
                }
                ArrayList<SpringGenerateTemplatesHolder> springInjections = new ArrayList<SpringGenerateTemplatesHolder>();
                for (SpringBeanPointer bean : dependencies) {
                    SpringGenerateTemplatesHolder templatesHolder = GenerateAutowiredDependenciesUtil.createAutowiredDependency(psiClass, bean, model);
                    if (templatesHolder == null) continue;
                    springInjections.add(templatesHolder);
                }
                result.setResult(springInjections);
            }
        }.execute().getResultObject();
    }

    @Nullable
    private static SpringGenerateTemplatesHolder createAutowiredDependency(@NotNull PsiClass psiClass, @NotNull SpringBeanPointer bean, @NotNull CommonSpringModel model) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createAutowiredDependency"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createAutowiredDependency"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createAutowiredDependency"));
        }
        SpringGenerateTemplatesHolder templatesHolder = new SpringGenerateTemplatesHolder(psiClass.getProject());
        PsiField setter = GenerateAutowiredDependenciesUtil.createField(psiClass, bean, templatesHolder, model);
        if (setter != null) {
            return templatesHolder;
        }
        return null;
    }

    @Nullable
    private static PsiField createField(@NotNull PsiClass currentBeanClass, @NotNull SpringBeanPointer candidateBean, @NotNull SpringGenerateTemplatesHolder templatesHolder, @NotNull CommonSpringModel model) {
        if (currentBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBeanClass", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createField"));
        }
        if (candidateBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateBean", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createField"));
        }
        if (templatesHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templatesHolder", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createField"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createField"));
        }
        PsiClass[] candidateBeanClasses = (PsiClass[])ContainerUtil.map2Array((Object[])candidateBean.getEffectiveBeanTypes(), PsiClass.class, PsiTypesUtil::getPsiClass);
        if (candidateBeanClasses.length > 0) {
            if (!GenerateSpringBeanDependenciesUtil.ensureFileWritable(currentBeanClass)) {
                return null;
            }
            PsiField field = GenerateAutowiredDependenciesUtil.createAutowiredField(candidateBean, currentBeanClass, candidateBeanClasses, model);
            GenerateAutowiredDependenciesUtil.addCreateFieldTemplate(field, candidateBean, candidateBeanClasses, templatesHolder);
            return field;
        }
        return null;
    }

    @NotNull
    private static PsiField createAutowiredField(@NotNull SpringBeanPointer candidateBean, @NotNull PsiClass currentBeanClass, @NotNull PsiClass[] candidateBeanClasses, @NotNull CommonSpringModel model) {
        PsiField psiField;
        if (candidateBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateBean", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createAutowiredField"));
        }
        if (currentBeanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBeanClass", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createAutowiredField"));
        }
        if (candidateBeanClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateBeanClasses", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createAutowiredField"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createAutowiredField"));
        }
        try {
            String qualifierName = GenerateAutowiredDependenciesUtil.getQualifierName(candidateBean);
            PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)currentBeanClass.getProject());
            PsiClass candidateBeanClass = candidateBeanClasses[0];
            String beanName = candidateBean.getName();
            String name = beanName == null || !psiNameHelper.isIdentifier(beanName) ? candidateBeanClass.getName() : beanName;
            PsiManager psiManager = currentBeanClass.getManager();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiClassType type = candidateBeanClass != null ? elementFactory.createType(candidateBeanClass) : PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject()));
            psiField = elementFactory.createField(StringUtil.decapitalize((String)name), (PsiType)type);
            psiField = (PsiField)currentBeanClass.add((PsiElement)psiField);
            psiField.getModifierList().addAnnotation("org.springframework.beans.factory.annotation.Autowired");
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)candidateBeanClass).withInheritors().effectiveBeanTypes();
            if (SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters).size() > 1 && !StringUtil.isEmptyOrSpaces((String)qualifierName)) {
                PsiAnnotation annotation = psiField.getModifierList().addAnnotation("org.springframework.beans.factory.annotation.Qualifier");
                PsiAnnotationSupport support = (PsiAnnotationSupport)LanguageAnnotationSupport.INSTANCE.forLanguage(annotation.getLanguage());
                annotation.setDeclaredAttributeValue("value", (PsiAnnotationMemberValue)support.createLiteralValue(qualifierName, (PsiElement)annotation));
            }
            GenerateSpringBeanDependenciesUtil.reformat((PsiMember)psiField);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
        PsiField psiField2 = psiField;
        if (psiField2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "createAutowiredField"));
        }
        return psiField2;
    }

    @Nullable
    public static String getQualifierName(@NotNull SpringBeanPointer candidateBean) {
        String value;
        if (candidateBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateBean", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "getQualifierName"));
        }
        SpringQualifier springQualifier = candidateBean.getSpringBean().getSpringQualifier();
        if (springQualifier != null && !StringUtil.isEmptyOrSpaces((String)(value = springQualifier.getQualifierValue()))) {
            return value;
        }
        return candidateBean.getName();
    }

    private static void addCreateFieldTemplate(PsiField psiField, SpringBeanPointer candidateBean, PsiClass[] psiClasses, SpringGenerateTemplatesHolder templatesHolder) {
        Set<String> existedNames = GenerateAutowiredDependenciesUtil.getExistedNames(psiField);
        PsiType type = psiField.getType();
        Collection<String> suggestedNames = GenerateAutowiredDependenciesUtil.suggestPsiFieldNames(type, candidateBean, existedNames);
        templatesHolder.addTemplateFactory((PsiElement)psiField, (Factory<Template>)((Factory)() -> {
            Collection<PsiClass> variants = GenerateSpringBeanDependenciesUtil.getSuperTypeVariants(psiClasses);
            PsiTypeElement typeElement = psiField.getTypeElement();
            Expression interfaces = GenerateAutowiredDependenciesUtil.getSuperTypesExpression(typeElement.getType().getCanonicalText(), variants);
            Expression ids = GenerateAutowiredDependenciesUtil.getPsiFieldSuggestNamesExpression(psiField, suggestedNames, existedNames);
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)psiField);
            if (variants.size() > 1) {
                builder.replaceElement((PsiElement)typeElement, "type", interfaces, true);
            }
            builder.replaceElement((PsiElement)psiField.getNameIdentifier(), "names", ids, true);
            return builder.buildInlineTemplate();
        }));
    }

    @NotNull
    private static Set<String> getExistedNames(@NotNull PsiField psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "getExistedNames"));
        }
        HashSet existedNames = new HashSet();
        PsiClass containingClass = psiField.getContainingClass();
        if (containingClass != null) {
            for (PsiField field : containingClass.getAllFields()) {
                if (field == psiField) continue;
                existedNames.add(field.getName());
            }
        }
        HashSet hashSet = existedNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "getExistedNames"));
        }
        return hashSet;
    }

    private static Expression getPsiFieldSuggestNamesExpression(final @NotNull PsiField psiField, final @NotNull Collection<String> suggestions, @NotNull Set<String> existedNames) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "getPsiFieldSuggestNamesExpression"));
        }
        if (suggestions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestions", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "getPsiFieldSuggestNamesExpression"));
        }
        if (existedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existedNames", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "getPsiFieldSuggestNamesExpression"));
        }
        return new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                PsiIdentifier psiIdentifier = psiField.getNameIdentifier();
                return new TextResult(psiIdentifier.getText());
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
                for (String name : suggestions) {
                    items.add(LookupElementBuilder.create((String)name));
                }
                return items.toArray(new LookupElement[items.size()]);
            }
        };
    }

    private static Collection<String> suggestPsiFieldNames(@NotNull PsiType psiType, @NotNull SpringBeanPointer bean, @NotNull Set<String> existedNames) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "suggestPsiFieldNames"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "suggestPsiFieldNames"));
        }
        if (existedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existedNames", "com/intellij/spring/model/actions/generate/GenerateAutowiredDependenciesUtil", "suggestPsiFieldNames"));
        }
        assert (bean.isValid());
        Project project = bean.getContainingFile().getProject();
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)project);
        HashSet names = new HashSet();
        String beanName = bean.getName();
        if (beanName != null) {
            for (String name : bean.getAliases()) {
                if (!psiNameHelper.isIdentifier(name) || existedNames.contains(name)) continue;
                names.add(name);
            }
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        Set<String> suggestions = SpringBeanCoreUtils.getSanitizedBeanNameSuggestions(codeStyleManager, psiType);
        suggestions.removeAll(existedNames);
        names.addAll(suggestions);
        return names;
    }

    static Expression getSuperTypesExpression(final String psiType, final Collection<PsiClass> psiClasses) {
        return new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                return new TextResult(psiType);
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                LinkedHashSet<JavaPsiClassReferenceElement> items = new LinkedHashSet<JavaPsiClassReferenceElement>();
                for (PsiClass psiClass : psiClasses) {
                    items.add(JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)psiClass, (boolean)true));
                }
                return items.toArray(new LookupElement[items.size()]);
            }
        };
    }
}

