/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.jam;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.model.cacheable.jam.SpringCachingGroups;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheConfig;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheEvictForClass;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheEvictForMethod;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCachePutForClass;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCachePutForMethod;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheableForClass;
import com.intellij.spring.model.cacheable.jam.custom.SpringJamCustomCacheableForMethod;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheConfig;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheEvictForClass;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheEvictForMethod;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachePutForClass;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCachePutForMethod;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheableForClass;
import com.intellij.spring.model.cacheable.jam.standard.SpringJamCacheableForMethod;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;

public class SpringCacheableSemContributor
extends SemContributor {
    private final SemService mySemService;
    private final PsiClassPattern nonAnnoClass = PsiJavaPatterns.psiClass().nonAnnotationType();
    private final PsiMethodPattern psiMethod = PsiJavaPatterns.psiMethod().constructor(false);

    public SpringCacheableSemContributor(SemService semService, UltimateVerifier verifier) {
        this.mySemService = semService;
        PluginVerifier.verifyUltimatePlugin(verifier);
    }

    public void registerSemProviders(SemRegistrar registrar) {
        this.registerCacheable(registrar);
        this.registerCacheEvict(registrar);
        this.registerCachePut(registrar);
        this.registerCacheConfig(registrar);
        SpringCachingGroups.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.cache.annotation.Caching"));
    }

    private void registerCachePut(SemRegistrar registrar) {
        SpringJamCachePutForClass.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.cache.annotation.CachePut"));
        SpringJamCachePutForMethod.META.register(registrar, (ElementPattern)this.psiMethod.withAnnotation("org.springframework.cache.annotation.CachePut"));
        Function customMetaAnnotations = SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.cache.annotation.CachePut");
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)this.nonAnnoClass, SpringJamCustomCachePutForClass.META_KEY, SpringJamCustomCachePutForClass.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringJamCustomCachePutForClass.JAM_KEY, SpringJamCustomCachePutForClass.class, (Function)customMetaAnnotations, pair -> new SpringJamCustomCachePutForClass((String)pair.first, (PsiClass)pair.second), null));
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)this.psiMethod, SpringJamCustomCachePutForMethod.META_KEY, SpringJamCustomCachePutForMethod.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringJamCustomCachePutForMethod.JAM_KEY, SpringJamCustomCachePutForMethod.class, (Function)customMetaAnnotations, pair -> new SpringJamCustomCachePutForMethod((String)pair.first, (PsiMethod)pair.second), null));
    }

    private void registerCacheEvict(SemRegistrar registrar) {
        SpringJamCacheEvictForClass.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.cache.annotation.CacheEvict"));
        SpringJamCacheEvictForMethod.META.register(registrar, (ElementPattern)this.psiMethod.withAnnotation("org.springframework.cache.annotation.CacheEvict"));
        Function customMetaAnnotations = SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.cache.annotation.CacheEvict");
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)this.nonAnnoClass, SpringJamCustomCacheEvictForClass.META_KEY, SpringJamCustomCacheEvictForClass.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringJamCustomCacheEvictForClass.JAM_KEY, SpringJamCustomCacheEvictForClass.class, (Function)customMetaAnnotations, pair -> new SpringJamCustomCacheEvictForClass((String)pair.first, (PsiClass)pair.second), null));
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)this.psiMethod, SpringJamCustomCacheEvictForMethod.META_KEY, SpringJamCustomCacheEvictForMethod.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringJamCustomCacheEvictForMethod.JAM_KEY, SpringJamCustomCacheEvictForMethod.class, (Function)customMetaAnnotations, pair -> new SpringJamCustomCacheEvictForMethod((String)pair.first, (PsiMethod)pair.second), null));
    }

    private void registerCacheable(SemRegistrar registrar) {
        SpringJamCacheableForClass.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.cache.annotation.Cacheable"));
        SpringJamCacheableForMethod.META.register(registrar, (ElementPattern)this.psiMethod.withAnnotation("org.springframework.cache.annotation.Cacheable"));
        Function customMetaAnnotations = SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.cache.annotation.Cacheable");
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)this.nonAnnoClass, SpringJamCustomCacheableForClass.META_KEY, SpringJamCustomCacheableForClass.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringJamCustomCacheableForClass.JAM_KEY, SpringJamCustomCacheableForClass.class, (Function)customMetaAnnotations, pair -> new SpringJamCustomCacheableForClass((String)pair.first, (PsiClass)pair.second), null));
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)this.psiMethod, SpringJamCustomCacheableForMethod.META_KEY, SpringJamCustomCacheableForMethod.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringJamCustomCacheableForMethod.JAM_KEY, SpringJamCustomCacheableForMethod.class, (Function)customMetaAnnotations, pair -> new SpringJamCustomCacheableForMethod((String)pair.first, (PsiMethod)pair.second), null));
    }

    private void registerCacheConfig(SemRegistrar registrar) {
        SpringJamCacheConfig.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotation("org.springframework.cache.annotation.CacheConfig"));
        Function customMetaAnnotations = SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.cache.annotation.CacheConfig");
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)this.nonAnnoClass, SpringJamCustomCacheConfig.META_KEY, SpringJamCustomCacheConfig.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringJamCustomCacheConfig.JAM_KEY, SpringJamCustomCacheConfig.class, (Function)customMetaAnnotations, pair -> new SpringJamCustomCacheConfig((String)pair.first, (PsiClass)pair.second), null));
    }
}

