/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ShowBeansQuickFix
implements LocalQuickFix {
    private static final NullableFunction<SpringBeanPointer, NavigatablePsiElement> MAPPER = pointer -> {
        PsiElement element = pointer.isValid() ? pointer.getPsiElement() : null;
        return element instanceof NavigatablePsiElement ? (NavigatablePsiElement)element : null;
    };
    private final Collection<SpringBeanPointer> myBeans;

    public ShowBeansQuickFix(Collection<SpringBeanPointer> beans) {
        this.myBeans = beans;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringBundle.message("spring.bean.show.beans.candidates.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/ShowBeansQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/ShowBeansQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/ShowBeansQuickFix", "applyFix"));
        }
        Editor editor = PsiUtilBase.findEditor((PsiElement)descriptor.getPsiElement());
        if (editor != null) {
            ShowBeansQuickFix.showBeanTargets(editor, this.myBeans);
        }
    }

    public static void showBeanTargets(@NotNull Editor editor, Collection<SpringBeanPointer> beans) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spring/model/highlighting/ShowBeansQuickFix", "showBeanTargets"));
        }
        List targets = ContainerUtil.mapNotNull(beans, MAPPER);
        PsiElementListNavigator.openTargets((Editor)editor, (NavigatablePsiElement[])((NavigatablePsiElement[])ArrayUtil.toObjectArray((Collection)targets, NavigatablePsiElement.class)), (String)SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0]), (String)SpringBundle.message("spring.bean.show.beans.candidates.title", new Object[0]), (ListCellRenderer)SpringBeansPsiElementCellRenderer.INSTANCE);
    }
}

