/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringRequiredAnnotationInspection
extends BaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/highlighting/SpringRequiredAnnotationInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/highlighting/SpringRequiredAnnotationInspection", "checkMethod"));
        }
        if (!PropertyUtil.isSimplePropertySetter((PsiMethod)method)) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)method.getContainingFile())) {
            return null;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.beans.factory.annotation.Required", (boolean)false)) {
            return null;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return null;
        }
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
        if (!info.isMapped()) {
            return null;
        }
        final String property = PropertyUtil.getPropertyNameBySetter((PsiMethod)method);
        if (!info.getMappedProperties(property).isEmpty() || info.isAutowired() || SpringRequiredAnnotationInspection.isAutowiredByDefault(method)) {
            return null;
        }
        List list = info.getMappedDomBeans();
        final ArrayList<SpringBean> beans = new ArrayList<SpringBean>(list.size());
        for (DomSpringBeanPointer pointer : list) {
            DomSpringBean springBean = (DomSpringBean)pointer.getSpringBean();
            if (!(springBean instanceof SpringBean) || ((SpringBean)springBean).isAbstract()) continue;
            beans.add((SpringBean)springBean);
        }
        if (beans.isEmpty()) {
            return null;
        }
        LocalQuickFix fix = new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = SpringBundle.message("create.missing.mappings", property);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringRequiredAnnotationInspection$1", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("create.missing.mappings.family.name", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringRequiredAnnotationInspection$1", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/SpringRequiredAnnotationInspection$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/SpringRequiredAnnotationInspection$1", "applyFix"));
                }
                HashSet files = new HashSet();
                for (SpringBean bean : beans) {
                    files.add(bean.getContainingFile().getVirtualFile());
                }
                if (!ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable((Collection)files).hasReadonlyFiles()) {
                    for (SpringBean bean : beans) {
                        bean.addProperty().getName().setStringValue(property);
                    }
                }
            }
        };
        PsiIdentifier psiIdentifier = method.getNameIdentifier();
        assert (psiIdentifier != null);
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)psiIdentifier, SpringBundle.message("required.property.not.mapped", property), fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
        return new ProblemDescriptor[]{descriptor};
    }

    private static boolean isAutowiredByDefault(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/highlighting/SpringRequiredAnnotationInspection", "isAutowiredByDefault"));
        }
        PsiType psiType = PropertyUtil.getPropertyType((PsiMember)method);
        return psiType != null && SpringAutowireUtil.isAutowiredByDefault(psiType);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringRequiredAnnotationInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringRequiredAnnotationInspection", "getShortName"));
        }
        return "SpringRequiredAnnotationInspection";
    }
}

