/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.actions.generate.SpringPropertiesGenerateProvider;
import com.intellij.spring.model.actions.generate.SpringTemplateBuilder;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringRequiredPropertyInspection
extends SpringBeanInspectionBase {
    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringRequiredPropertyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringRequiredPropertyInspection", "getShortName"));
        }
        return "SpringRequiredPropertyInspection";
    }

    protected void checkBean(final SpringBean springBean, Beans beans, DomElementAnnotationHolder holder, XmlSpringModel springModel) {
        if (springBean.isAbstract()) {
            return;
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (psiClass == null) {
            return;
        }
        Map properties = PropertyUtil.getAllProperties((PsiClass)psiClass, (boolean)true, (boolean)false);
        List definedProperties = springBean.getAllProperties();
        SmartList missing = new SmartList();
        SmartList missingMethods = new SmartList();
        for (Map.Entry entry : properties.entrySet()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)entry.getValue()), (String)"org.springframework.beans.factory.annotation.Required", (boolean)false, (boolean)true) || SpringRequiredPropertyInspection.isDefined(definedProperties, (String)entry.getKey()) || SpringAutowireUtil.isAutowired(springBean, (SpringModel)springModel, (PsiMethod)entry.getValue())) continue;
            missing.add(entry.getKey());
            missingMethods.add(entry.getValue());
        }
        if (missing.isEmpty()) {
            return;
        }
        SpringBean element = DomUtil.hasXml((DomElement)springBean.getClazz()) ? springBean.getClazz() : springBean;
        holder.createProblem((DomElement)element, HighlightSeverity.ERROR, SpringBundle.message("required.properties.missed", StringUtil.join((Collection)missing, (String)",")), new LocalQuickFix[]{new LocalQuickFix((List)missingMethods){
            final /* synthetic */ List val$missingMethods;
            {
                this.val$missingMethods = list;
            }

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("create.missing.properties", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringRequiredPropertyInspection$1", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/SpringRequiredPropertyInspection$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/SpringRequiredPropertyInspection$1", "applyFix"));
                }
                Editor editor = SpringTemplateBuilder.getEditor(descriptor);
                SpringPropertiesGenerateProvider.doGenerate(editor, springBean, project, this.val$missingMethods.toArray(new PsiMethod[this.val$missingMethods.size()]));
            }
        }});
    }

    private static boolean isDefined(List<SpringPropertyDefinition> list, String property) {
        for (SpringPropertyDefinition definition : list) {
            String name = definition.getPropertyName();
            if (name == null || !name.equals(property)) continue;
            return true;
        }
        return false;
    }
}

