/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.providers;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringInnerClassConfigurationsProvider
extends SpringTestingImplicitContextsProvider {
    @NotNull
    public Collection<CommonSpringModel> getModels(@Nullable Module module, @NotNull ContextConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/model/jam/testContexts/providers/SpringInnerClassConfigurationsProvider", "getModels"));
        }
        if (module == null) {
            List<CommonSpringModel> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/providers/SpringInnerClassConfigurationsProvider", "getModels"));
            }
            return list;
        }
        List models = ContainerUtil.newSmartList();
        for (PsiClass psiClass : configuration.getPsiElement().getAllInnerClasses()) {
            if (!psiClass.hasModifierProperty("static") || JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) == null) continue;
            ContainerUtil.addIfNotNull((Collection)models, (Object)SpringManager.getInstance((Project)module.getProject()).getLocalSpringModel(psiClass, module));
        }
        List list = models;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/providers/SpringInnerClassConfigurationsProvider", "getModels"));
        }
        return list;
    }
}

