/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.PlaceholderTextRanges;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.PlaceholderInfo;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.context.PropertyPlaceholder;
import com.intellij.spring.model.xml.util.UtilProperties;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderUtilsImpl
extends PlaceholderUtils {
    private static final Pair<String, String> DEFAULT_PLACEHOLDER_PAIR = Pair.create((Object)"${", (Object)"}");
    @NonNls
    private static final String LOCATION_PROPERTY_NAME = "location";
    @NonNls
    private static final String LOCATIONS_PROPERTY_NAME = "locations";
    @NonNls
    private static final String PROPERTIES_PROPERTY_NAME = "properties";
    @NonNls
    private static final String PROPERTIES_ARRAY_PROPERTY_NAME = "propertiesArray";
    private static final Key<CachedValue<Set<Pair<String, String>>>> PLACEHOLDER_PREFIXES_KEY = Key.create((String)"PLACEHOLDER_PREFIX_SUFFIX");
    private static final Key<CachedValue<Pair<String, String>>> PLACEHOLDER_PREFIX_SUFFIX = Key.create((String)"PLACEHOLDER_PREFIX_SUFFIX");

    public Set<PropertiesFile> getResources(Collection<? extends SpringBeanPointer> configurerBeans) {
        java.util.HashSet<PropertiesFile> resources = new java.util.HashSet<PropertiesFile>();
        boolean hasNotResolvedLocations = false;
        for (SpringBeanPointer springBeanPointer : configurerBeans) {
            hasNotResolvedLocations |= this.getResources(springBeanPointer, resources);
        }
        return resources;
    }

    private boolean getResources(SpringBeanPointer configurerBean, Set<PropertiesFile> resources) {
        List<Pair<String, PsiElement>> locations = this.getLocations(configurerBean.getSpringBean());
        boolean hasNotResolvedLocations = false;
        for (Pair<String, PsiElement> location : locations) {
            Set<PropertiesFile> propertiesFiles = this.getPropertiesFile(location);
            if (propertiesFiles != null && !propertiesFiles.isEmpty()) {
                resources.addAll(propertiesFiles);
                continue;
            }
            hasNotResolvedLocations = true;
        }
        return hasNotResolvedLocations && !locations.isEmpty();
    }

    @Nullable
    public Set<PropertiesFile> getPropertiesFile(Pair<String, PsiElement> location) {
        PsiElement psiElement = (PsiElement)location.second;
        String value = (String)location.first;
        if (psiElement == null || value == null) {
            return Collections.emptySet();
        }
        return new java.util.HashSet<PropertiesFile>(PlaceholderUtilsImpl.getResourceFiles(psiElement, value, ",", (Condition<PsiFileSystemItem>)new FilteringIterator.InstanceOf(PsiFile.class)));
    }

    public List<Pair<String, PsiElement>> getLocations(CommonSpringBean configurerBean) {
        SpringPropertyDefinition propertiesArrayProperty;
        SpringBeanPointer propertiesRefBean;
        SmartList locations = new SmartList();
        if (configurerBean instanceof PropertyPlaceholder) {
            SpringBeanPointer propertiesBeanPointer;
            PropertyPlaceholder placeholder = (PropertyPlaceholder)configurerBean;
            GenericAttributeValue<String> location = placeholder.getLocation();
            if (location.getRawText() != null && location.getXmlElement() != null) {
                PlaceholderUtilsImpl.addIfNotNull((List<Pair<String, PsiElement>>)locations, location.getRawText(), location.getXmlElement());
            }
            if ((propertiesBeanPointer = (SpringBeanPointer)placeholder.getPropertiesRef().getValue()) != null) {
                PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, propertiesBeanPointer);
            }
        } else {
            SpringPropertyDefinition locationProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)configurerBean, (String)LOCATION_PROPERTY_NAME);
            if (locationProperty != null) {
                PlaceholderUtilsImpl.addIfNotNull((List<Pair<String, PsiElement>>)locations, PlaceholderUtilsImpl.getPropertyValue(locationProperty));
            }
            PlaceholderUtilsImpl.processLocationsProperty((List<Pair<String, PsiElement>>)locations, configurerBean);
        }
        SpringPropertyDefinition propertiesProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)configurerBean, (String)PROPERTIES_PROPERTY_NAME);
        if (propertiesProperty != null && (propertiesRefBean = propertiesProperty.getRefValue()) != null) {
            PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, propertiesRefBean);
            PlaceholderUtilsImpl.processLocationsProperty((List<Pair<String, PsiElement>>)locations, propertiesRefBean.getSpringBean());
        }
        if ((propertiesArrayProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)configurerBean, (String)PROPERTIES_ARRAY_PROPERTY_NAME)) != null) {
            GenericDomValue element = propertiesArrayProperty.getRefElement();
            if (element != null) {
                PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, (SpringBeanPointer)element.getValue());
            }
            if (propertiesArrayProperty instanceof SpringProperty) {
                PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, ((SpringProperty)propertiesArrayProperty).getList());
                PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, ((SpringProperty)propertiesArrayProperty).getSet());
                PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, ((SpringProperty)propertiesArrayProperty).getArray());
            }
        }
        return locations;
    }

    @Nullable
    private static Pair<String, PsiElement> getPropertyValue(@NotNull SpringPropertyDefinition property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getPropertyValue"));
        }
        GenericDomValue<?> value = PlaceholderUtilsImpl.getPropertyDomValue(property);
        return value == null ? null : Pair.create((Object)value.getRawText(), (Object)DomUtil.getValueElement(value));
    }

    @Nullable
    private static GenericDomValue<?> getPropertyDomValue(@NotNull SpringPropertyDefinition property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getPropertyDomValue"));
        }
        GenericDomValue valueElement = property.getValueElement();
        return valueElement != null && valueElement.getRawText() == null ? null : valueElement;
    }

    private static void addIfNotNull(List<Pair<String, PsiElement>> locations, Pair<String, PsiElement> pair) {
        if (pair != null && pair.first != null && pair.second != null) {
            locations.add(pair);
        }
    }

    private static void processLocationsProperty(List<Pair<String, PsiElement>> locations, CommonSpringBean bean) {
        SpringPropertyDefinition locationsProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)LOCATIONS_PROPERTY_NAME);
        if (locationsProperty instanceof SpringProperty) {
            Pair<String, PsiElement> propertyValue = PlaceholderUtilsImpl.getPropertyValue(locationsProperty);
            if (propertyValue != null) {
                PlaceholderUtilsImpl.addIfNotNull(locations, propertyValue);
            } else {
                SpringProperty springProperty = (SpringProperty)locationsProperty;
                PlaceholderUtilsImpl.addLocationsFromCollection(locations, springProperty.getList());
                PlaceholderUtilsImpl.addLocationsFromCollection(locations, springProperty.getSet());
                PlaceholderUtilsImpl.addLocationsFromCollection(locations, springProperty.getArray());
            }
        }
    }

    private static void addLocationsFromCollection(List<Pair<String, PsiElement>> locations, ListOrSet list) {
        for (SpringValue value : list.getValues()) {
            for (String s : PlaceholderUtilsImpl.splitLocationString(value.getRawText())) {
                PlaceholderUtilsImpl.addIfNotNull(locations, s, value.getXmlElement());
            }
        }
    }

    private static void addLocations(List<Pair<String, PsiElement>> locations, ListOrSet listOrSet) {
        for (SpringRef value : listOrSet.getRefs()) {
            PlaceholderUtilsImpl.addLocations(locations, (SpringBeanPointer)value.getBean().getValue());
            PlaceholderUtilsImpl.addLocations(locations, (SpringBeanPointer)value.getLocal().getValue());
        }
    }

    private static void addLocations(List<Pair<String, PsiElement>> locations, @Nullable SpringBeanPointer beanPointer) {
        CommonSpringBean springBean;
        GenericDomValue<String> location;
        if (beanPointer != null && (location = PlaceholderUtilsImpl.getLocationDomElementValue(springBean = beanPointer.getSpringBean())) != null) {
            String locationString = location.getRawText();
            for (String s : PlaceholderUtilsImpl.splitLocationString(locationString)) {
                PlaceholderUtilsImpl.addIfNotNull(locations, s.trim(), DomUtil.getValueElement(location));
            }
        }
    }

    private static void addIfNotNull(@NotNull List<Pair<String, PsiElement>> locations, @Nullable String str, @Nullable XmlElement valueElement) {
        if (locations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LOCATIONS_PROPERTY_NAME, "com/intellij/spring/model/values/PlaceholderUtilsImpl", "addIfNotNull"));
        }
        if (str != null && valueElement != null) {
            locations.add((Pair<String, PsiElement>)Pair.create((Object)str, (Object)valueElement));
        }
    }

    @NotNull
    private static Set<String> splitLocationString(@Nullable String location) {
        HashSet locations = new HashSet();
        if (!StringUtil.isEmptyOrSpaces((String)location)) {
            for (String s : StringUtil.split((String)location, (String)",")) {
                if (StringUtil.isEmptyOrSpaces((String)s)) continue;
                locations.add(s.trim());
            }
        }
        HashSet hashSet = locations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "splitLocationString"));
        }
        return hashSet;
    }

    @Nullable
    private static GenericDomValue<String> getLocationDomElementValue(CommonSpringBean springBean) {
        SpringPropertyDefinition location;
        PsiClass psiClass;
        if (springBean instanceof UtilProperties) {
            UtilProperties utilProperties = (UtilProperties)springBean;
            return utilProperties.getLocation();
        }
        if (springBean instanceof SpringBean && (psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType())) != null && "org.springframework.beans.factory.config.PropertiesFactoryBean".equals(psiClass.getQualifiedName()) && (location = SpringPropertyUtils.findPropertyByName((CommonSpringBean)springBean, (String)LOCATION_PROPERTY_NAME)) != null) {
            return location.getValueElement();
        }
        return null;
    }

    public boolean containsDefaultPlaceholderDefinitions(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "containsDefaultPlaceholderDefinitions"));
        }
        String stringValue = genericDomValue.getRawText();
        if (stringValue != null && !StringUtil.isEmptyOrSpaces((String)stringValue)) {
            return PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, DEFAULT_PLACEHOLDER_PAIR);
        }
        return false;
    }

    public boolean isRawTextPlaceholder(GenericDomValue genericDomValue) {
        return this.isPlaceholder(genericDomValue, genericDomValue.getRawText());
    }

    public boolean isPlaceholder(GenericDomValue genericDomValue) {
        return this.isPlaceholder(genericDomValue, genericDomValue.getStringValue());
    }

    public boolean isPlaceholder(GenericDomValue genericDomValue, String stringValue) {
        if (stringValue != null && !StringUtil.isEmptyOrSpaces((String)stringValue)) {
            if (PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, DEFAULT_PLACEHOLDER_PAIR)) {
                return true;
            }
            if (DomUtil.hasXml((DomElement)genericDomValue)) {
                XmlElement element = genericDomValue.getXmlElement();
                Set<Pair<String, String>> prefixes = this.getPlaceholderPrefixes((PsiElement)element);
                if (prefixes == null) {
                    return false;
                }
                for (Pair<String, String> pair : prefixes) {
                    if (!PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, pair)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPlaceholder(String stringValue, List<SpringBeanPointer> configurers) {
        for (SpringBeanPointer configurer : configurers) {
            CommonSpringBean bean = configurer.getSpringBean();
            if (!(bean instanceof DomSpringBean) || !PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, this.getPlaceholderPrefixAndSuffix((DomSpringBean)bean))) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultPlaceholder(@Nullable String stringValue) {
        return stringValue != null && PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, DEFAULT_PLACEHOLDER_PAIR);
    }

    private static boolean isPrefixAndSuffixDefinedCorrectly(@NotNull String stringValue, @NotNull Pair<String, String> prefixAndSuffix) {
        if (stringValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringValue", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "isPrefixAndSuffixDefinedCorrectly"));
        }
        if (prefixAndSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixAndSuffix", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "isPrefixAndSuffixDefinedCorrectly"));
        }
        int prefixPos = stringValue.indexOf((String)prefixAndSuffix.first);
        return prefixPos >= 0 && prefixPos < stringValue.indexOf((String)prefixAndSuffix.second);
    }

    public Pair<String, String> getPlaceholderPrefixAndSuffix(DomSpringBean placeholderBean) {
        return (Pair)CachedValuesManager.getManager((Project)placeholderBean.getPsiManager().getProject()).getCachedValue((UserDataHolder)placeholderBean, PLACEHOLDER_PREFIX_SUFFIX, () -> new CachedValueProvider.Result(this.getPlaceholderPrefixAndSuffixInner(placeholderBean), new Object[]{placeholderBean.getXmlElement()}), false);
    }

    @NotNull
    public Pair<String, String> getPlaceholderPrefixAndSuffixInner(@Nullable SpringBeanPointer pointer) {
        CommonSpringBean springBean;
        if (pointer != null && (springBean = pointer.getSpringBean()) instanceof DomSpringBean) {
            Pair<String, String> pair = this.getPlaceholderPrefixAndSuffixInner((DomSpringBean)springBean);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getPlaceholderPrefixAndSuffixInner"));
            }
            return pair;
        }
        Pair<String, String> pair = DEFAULT_PLACEHOLDER_PAIR;
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getPlaceholderPrefixAndSuffixInner"));
        }
        return pair;
    }

    @NotNull
    public Pair<String, String> getPlaceholderPrefixAndSuffixInner(DomSpringBean placeholderBean) {
        String prefix = PlaceholderUtilsImpl.getPlaceholderConfigProperty(placeholderBean, "placeholderPrefix", "${");
        String suffix = PlaceholderUtilsImpl.getPlaceholderConfigProperty(placeholderBean, "placeholderSuffix", "}");
        Pair pair = Pair.create((Object)prefix, (Object)suffix);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getPlaceholderPrefixAndSuffixInner"));
        }
        return pair;
    }

    private static String getPlaceholderConfigProperty(DomSpringBean placeholderBean, String propertyName, String defaultValue) {
        String value;
        SpringPropertyDefinition userDefinedPrefixProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)placeholderBean, (String)propertyName);
        if (userDefinedPrefixProperty != null && userDefinedPrefixProperty.getValueElement() != null && !StringUtil.isEmptyOrSpaces((String)(value = userDefinedPrefixProperty.getValueElement().getRawText()))) {
            return value;
        }
        return defaultValue;
    }

    @NotNull
    public PsiReference[] createPlaceholderPropertiesReferences(GenericDomValue genericDomValue) {
        Map<TextRange, PlaceholderInfo> textRanges = this.getTextRanges(genericDomValue);
        if (textRanges == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "createPlaceholderPropertiesReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)genericDomValue);
        PsiReference[] psiReferenceArray = PlaceholderUtilsImpl.createPlaceholderPropertiesReferences(textRanges, (PsiElement)valueElement);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "createPlaceholderPropertiesReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createPlaceholderPropertiesReferences(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "createPlaceholderPropertiesReferences"));
        }
        PsiReference[] psiReferenceArray = PlaceholderUtilsImpl.createPlaceholderPropertiesReferences(this.getTextRangesWithNested(psiElement), psiElement);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "createPlaceholderPropertiesReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private static PsiReference[] createPlaceholderPropertiesReferences(@NotNull Map<TextRange, PlaceholderInfo> textRanges, @Nullable PsiElement valueElement) {
        TextRange[] ranges;
        if (textRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRanges", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "createPlaceholderPropertiesReferences"));
        }
        if (valueElement == null || textRanges.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "createPlaceholderPropertiesReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList references = new SmartList();
        for (TextRange textRange : ranges = textRanges.keySet().toArray(new TextRange[textRanges.keySet().size()])) {
            if (PlaceholderUtilsImpl.hasNestedPlaceholders(textRange, ranges)) continue;
            PlaceholderInfo info = textRanges.get(textRange);
            references.add(PlaceholderPropertyReference.create(valueElement, textRange, info));
        }
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "createPlaceholderPropertiesReferences"));
        }
        return psiReferenceArray;
    }

    private static boolean hasNestedPlaceholders(@NotNull TextRange textRange, TextRange ... ranges) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "hasNestedPlaceholders"));
        }
        for (TextRange range : ranges) {
            if (range.equals((Object)textRange) || !textRange.contains(range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Map<TextRange, PlaceholderInfo> getTextRanges(GenericDomValue domValue) {
        THashMap textRanges = new THashMap();
        Set<Pair<String, String>> prefixes = this.getPlaceholderPrefixes((PsiElement)domValue.getXmlElement());
        if (prefixes == null) {
            return null;
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)domValue);
        if (valueElement == null) {
            return null;
        }
        String text = valueElement.getText();
        for (Pair<String, String> prefixAndSuffix : prefixes) {
            String prefix = (String)prefixAndSuffix.first;
            String suffix = (String)prefixAndSuffix.second;
            for (TextRange fullTextRange : PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)prefix, (String)suffix, (boolean)true)) {
                TextRange placeholderTextRange = new TextRange(fullTextRange.getStartOffset() + prefix.length(), fullTextRange.getEndOffset() - suffix.length());
                String placeholderText = placeholderTextRange.substring(text);
                textRanges.put(placeholderTextRange, new PlaceholderInfo(placeholderText, prefixAndSuffix, text, fullTextRange));
            }
        }
        return textRanges;
    }

    private Map<TextRange, PlaceholderInfo> getTextRangesWithNested(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getTextRangesWithNested"));
        }
        THashMap textRanges = new THashMap();
        Set<Pair<String, String>> prefixes = this.getPlaceholderPrefixes(element);
        if (prefixes == null) {
            return Collections.emptyMap();
        }
        for (Pair<String, String> prefixAndSuffix : prefixes) {
            String text = element.getText();
            String prefix = (String)prefixAndSuffix.first;
            String suffix = (String)prefixAndSuffix.second;
            for (TextRange textRange : PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)prefix, (String)suffix)) {
                String placeholderText = textRange.substring(text);
                textRanges.put(textRange, new PlaceholderInfo(placeholderText, prefixAndSuffix, text, textRange));
            }
        }
        return textRanges;
    }

    private Collection<String> getExpandedVariants(GenericDomValue value) {
        boolean quit;
        String stringValue = value.getRawText();
        Map<TextRange, PlaceholderInfo> textRanges = this.getTextRanges(value);
        if (textRanges == null || textRanges.isEmpty()) {
            return ContainerUtil.createMaybeSingletonList((Object)stringValue);
        }
        TextRange[] ranges = PlaceholderUtilsImpl.sortTextRanges(textRanges);
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)value);
        assert (valueElement != null);
        THashSet result = new THashSet();
        ResolveResult[][] variants = new ResolveResult[ranges.length][];
        for (int i = 0; i < ranges.length; ++i) {
            TextRange range = ranges[i];
            PlaceholderInfo info = textRanges.get(range);
            PlaceholderPropertyReference reference = PlaceholderPropertyReference.create((PsiElement)valueElement, range, info);
            ResolveResult[] results = reference.multiResolve(false);
            variants[i] = results;
        }
        int[] indices = new int[ranges.length];
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)valueElement);
        assert (manipulator != null);
        int offsetBase = -manipulator.getRangeInElement((PsiElement)valueElement).getStartOffset();
        block1: do {
            int offset = offsetBase;
            StringBuilder sb = new StringBuilder(stringValue);
            for (int i = 0; i < indices.length; ++i) {
                IProperty property;
                String replacement;
                ResolveResult resolveResult;
                PsiElement element;
                PlaceholderInfo info = textRanges.get(ranges[i]);
                if (variants[i].length == 0 || !((element = (resolveResult = variants[i][indices[i]]).getElement()) instanceof IProperty) || (replacement = (property = (IProperty)element).getValue()) == null) continue;
                sb.replace(offset + info.fullTextRange.getStartOffset(), offset + info.fullTextRange.getEndOffset(), replacement);
                offset += replacement.length() - info.fullTextRange.getLength();
            }
            result.add((Object)sb.toString());
            quit = true;
            for (int idx = 0; idx < indices.length; ++idx) {
                if (indices[idx] >= variants[idx].length - 1) continue;
                quit = false;
                int n = idx;
                indices[n] = indices[n] + 1;
                for (int i = 0; i < idx; ++i) {
                    indices[i] = 0;
                }
                continue block1;
            }
        } while (!quit);
        return result;
    }

    @Nullable
    public String resolvePlaceholders(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "resolvePlaceholders"));
        }
        String result = genericDomValue.getRawText();
        if (StringUtil.isEmptyOrSpaces((String)result)) {
            return result;
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)genericDomValue);
        assert (valueElement != null);
        Map<TextRange, PlaceholderInfo> textRanges = this.getTextRanges(genericDomValue);
        if (textRanges == null) {
            return result;
        }
        TextRange[] ranges = PlaceholderUtilsImpl.sortTextRanges(textRanges);
        HashMap changes = new HashMap();
        for (TextRange range : ranges) {
            String strToReplace;
            PlaceholderInfo placeholderInfo = textRanges.get(range);
            String propertyValue = PlaceholderUtilsImpl.getPropertyValue(valueElement, range, placeholderInfo);
            if (propertyValue == null || StringUtil.isEmptyOrSpaces((String)(strToReplace = placeholderInfo.fullTextRange.substring(placeholderInfo.myElementText)))) continue;
            changes.put(strToReplace, propertyValue);
        }
        if (textRanges.size() == changes.size()) {
            for (Map.Entry entry : changes.entrySet()) {
                result = result.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return result;
    }

    @Nullable
    private static String getPropertyValue(XmlElement valueElement, TextRange range, PlaceholderInfo info) {
        return (String)RecursionManager.doPreventingRecursion((Object)valueElement, (boolean)true, (Computable)((NullableComputable)() -> {
            PsiElement element;
            PlaceholderPropertyReference reference = PlaceholderPropertyReference.create((PsiElement)valueElement, range, info);
            ResolveResult[] results = reference.multiResolve(false);
            if (results.length > 0 && (element = results[0].getElement()) instanceof IProperty) {
                return ((IProperty)element).getValue();
            }
            return reference.getDefaultValue();
        }));
    }

    private static TextRange[] sortTextRanges(@NotNull Map<TextRange, PlaceholderInfo> textRanges) {
        if (textRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRanges", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "sortTextRanges"));
        }
        TextRange[] ranges = textRanges.keySet().toArray(new TextRange[textRanges.size()]);
        Arrays.sort(ranges, (o1, o2) -> o1.getStartOffset() - o2.getStartOffset());
        return ranges;
    }

    @Nullable
    private Set<Pair<String, String>> getPlaceholderPrefixes(PsiElement context) {
        if (context == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return Collections.singleton(DEFAULT_PLACEHOLDER_PAIR);
        }
        if (!PlaceholderUtilsImpl.hasCustomPlaceholderPrefixCandidates(module)) {
            return Collections.singleton(DEFAULT_PLACEHOLDER_PAIR);
        }
        PsiFile contextContainingFile = context.getContainingFile();
        return (Set)CachedValuesManager.getCachedValue((PsiElement)contextContainingFile, () -> {
            THashSet prefixes = new THashSet();
            THashSet processed = new THashSet();
            if (contextContainingFile instanceof XmlFile) {
                processed.add(contextContainingFile);
                this.processFile((XmlFile)contextContainingFile, (Set<Pair<String, String>>)prefixes);
            }
            ModuleUtilCore.visitMeAndDependentModules((Module)module, arg_0 -> this.lambda$null$3((Set)processed, (Set)prefixes, arg_0));
            return CachedValueProvider.Result.create((Object)prefixes, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    private static boolean hasCustomPlaceholderPrefixCandidates(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "hasCustomPlaceholderPrefixCandidates"));
        }
        Project project = module.getProject();
        if (DumbService.isDumb((Project)project)) {
            return false;
        }
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        Collection springXmlFiles = DomService.getInstance().getDomFileCandidates(Beans.class, project, moduleScope);
        return !CacheManager.SERVICE.getInstance((Project)project).processFilesWithWord((Processor)new CommonProcessors.FindFirstProcessor(), "placeholderPrefix", (short)255, GlobalSearchScope.filesScope((Project)project, (Collection)springXmlFiles), true);
    }

    private void processFile(XmlFile psiFile, Set<Pair<String, String>> prefixes) {
        Set values = (Set)CachedValuesManager.getManager((Project)psiFile.getProject()).getCachedValue((UserDataHolder)psiFile, PLACEHOLDER_PREFIXES_KEY, () -> new CachedValueProvider.Result(this.getPlaceholderPrefixes(psiFile), new Object[]{psiFile}), false);
        if (values != null) {
            prefixes.addAll(values);
        }
    }

    @NotNull
    private Set<Pair<String, String>> getPlaceholderPrefixes(@NotNull XmlFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getPlaceholderPrefixes"));
        }
        LocalXmlModel springModel = SpringManager.getInstance((Project)configFile.getProject()).getLocalSpringModel(configFile);
        if (springModel == null) {
            Set<Pair<String, String>> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getPlaceholderPrefixes"));
            }
            return set;
        }
        List configurers = springModel.getPlaceholderConfigurers();
        if (configurers.isEmpty()) {
            Set<Pair<String, String>> set = Collections.singleton(DEFAULT_PLACEHOLDER_PAIR);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getPlaceholderPrefixes"));
            }
            return set;
        }
        com.intellij.util.containers.HashSet set = new com.intellij.util.containers.HashSet();
        for (SpringBeanPointer configurer : configurers) {
            CommonSpringBean springBean;
            if (!configFile.equals(configurer.getContainingFile()) || !((springBean = configurer.getSpringBean()) instanceof DomSpringBean)) continue;
            set.add(this.getPlaceholderPrefixAndSuffixInner((DomSpringBean)springBean));
        }
        com.intellij.util.containers.HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getPlaceholderPrefixes"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getValueVariants(@NotNull SpringValueHolderDefinition property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getValueVariants"));
        }
        GenericDomValue value = SpringPropertyUtils.getPropertyDomValue((SpringValueHolderDefinition)property);
        if (value == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getValueVariants"));
            }
            return list;
        }
        Collection<String> collection = this.getValueVariants(value);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getValueVariants"));
        }
        return collection;
    }

    @NotNull
    public Collection<String> getValueVariants(GenericDomValue value) {
        String stringValue = value.getStringValue();
        if (StringUtil.isEmpty((String)stringValue)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getValueVariants"));
            }
            return list;
        }
        Collection<String> collection = this.getExpandedVariants(value);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getValueVariants"));
        }
        return collection;
    }

    private static Collection<PropertiesFile> getResourceFiles(@NotNull PsiElement element, @NotNull String s, String delimiter, Condition<PsiFileSystemItem> filter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getResourceFiles"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "getResourceFiles"));
        }
        ArrayList references = new ArrayList();
        int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        SpringResourcesUtil resourcesUtil = SpringResourcesUtil.getInstance();
        SpringReferenceUtils.processSeparatedString((String)s, (String)delimiter, (s1, offset) -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/values/PlaceholderUtilsImpl", "lambda$getResourceFiles$6"));
            }
            SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)s1).offset(offset + startInElement);
            ContainerUtil.addAll((Collection)references, (Object[])resourcesUtil.getReferences(builder));
            return true;
        });
        PsiReference[] psiReferences = references.toArray(new PsiReference[references.size()]);
        Collection files = resourcesUtil.getResourceItems(psiReferences, filter);
        return ContainerUtil.mapNotNull((Collection)files, (Function)((NullableFunction)PropertiesImplUtil::getPropertiesFile));
    }

    private /* synthetic */ boolean lambda$null$3(Set processed, Set prefixes, Module module1) {
        SpringFacet facet = SpringFacet.getInstance((Module)module1);
        if (facet != null) {
            Set sets = facet.getFileSets();
            for (SpringFileSet set : sets.toArray(new SpringFileSet[sets.size()])) {
                Set files = set.getXmlFiles();
                for (VirtualFilePointer pointer : files) {
                    PsiFile psiFile;
                    VirtualFile file = pointer.getFile();
                    if (file == null || !((psiFile = PsiManager.getInstance((Project)module1.getProject()).findFile(file)) instanceof XmlFile) || !processed.add(psiFile)) continue;
                    this.processFile((XmlFile)psiFile, prefixes);
                }
            }
        }
        return true;
    }
}

