/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters;

import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.values.converters.SpringValueConditionFactory;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleNameConverter
extends Converter<PropertiesFile>
implements CustomReferenceConverter {
    @NonNls
    public static final String RESOURCE_BUNDLE_MESSAGE_SOURCE = "org.springframework.context.support.ResourceBundleMessageSource";
    @NonNls
    public static final String RELOADABLE_RESOURCE_BUNDLE_MESSAGE_SOURCE = "org.springframework.context.support.ReloadableResourceBundleMessageSource";

    @Nullable
    public PropertiesFile fromString(@Nullable @NonNls String s, ConvertContext context) {
        return null;
    }

    @Nullable
    public String toString(@Nullable PropertiesFile file, ConvertContext context) {
        return null;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue value, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new ResourceBundleReference(element, true)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/BundleNameConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    public static class BundleNameConverterCondition
    implements Condition<Pair<PsiType, GenericDomValue>> {
        private static final Condition<GenericDomValue> CONDITION = SpringValueConditionFactory.createBeanPropertyCondition((String)"org.springframework.context.support.ResourceBundleMessageSource", (String[])new String[]{"basename", "basenames"});
        private static final Condition<GenericDomValue> RELOADABLE_MESSAGE_SOURCE_CONDITION = SpringValueConditionFactory.createBeanPropertyCondition((String)"org.springframework.context.support.ReloadableResourceBundleMessageSource", (String[])new String[]{"basename", "basenames"});

        public boolean value(Pair<PsiType, GenericDomValue> pair) {
            PsiType psiType = (PsiType)pair.getFirst();
            if (psiType instanceof PsiArrayType) {
                psiType = ((PsiArrayType)psiType).getComponentType();
            }
            if (!(psiType instanceof PsiClassType)) {
                return false;
            }
            String psiTypeText = psiType.getCanonicalText();
            return "java.lang.String".equals(psiTypeText) && (CONDITION.value(pair.second) || RELOADABLE_MESSAGE_SOURCE_CONDITION.value(pair.second));
        }
    }
}

