/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams.edges;

import com.intellij.diagram.DiagramNode;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.perspectives.diagrams.SpringDependencyType;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.edges.SpringNavigatableEdge;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectionEdge
extends SpringNavigatableEdge {
    public InjectionEdge(DiagramNode<SpringElementWrapper> source, DiagramNode<SpringElementWrapper> target, @NotNull DomElement identifyingElement) {
        if (identifyingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifyingElement", "com/intellij/spring/perspectives/diagrams/edges/InjectionEdge", "<init>"));
        }
        this(source, target, identifyingElement, null);
    }

    public InjectionEdge(DiagramNode<SpringElementWrapper> source, DiagramNode<SpringElementWrapper> target, @NotNull DomElement identifyingElement, @Nullable String label) {
        if (identifyingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifyingElement", "com/intellij/spring/perspectives/diagrams/edges/InjectionEdge", "<init>"));
        }
        super(source, target, InjectionEdge.getDependencyType(identifyingElement), (PsiElement)identifyingElement.getXmlElement(), label);
    }

    private static SpringDependencyType getDependencyType(DomElement identifyingElement) {
        if (identifyingElement instanceof DomSpringBean) {
            return SpringDependencyType.INNER;
        }
        if (DomUtil.getParentOfType((DomElement)identifyingElement, ConstructorArg.class, (boolean)false) != null) {
            return SpringDependencyType.CONSTRUCTOR_INJECTION;
        }
        return SpringDependencyType.PROPERTY_INJECTION;
    }
}

