/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.spi.SpringSpiFileProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NotNull;

public class SpringSpiReferenceContributor
extends PsiReferenceContributor {
    private static final JavaClassReferenceProvider CLASS_REFERENCE_PROVIDER = new JavaClassReferenceProvider(){

        public boolean isSoft() {
            return true;
        }
    };

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/spi/SpringSpiReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.psiElement(PropertyKeyImpl.class).inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().ofType((FileType)SpringSpiFileProvider.FILE_TYPE)), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/spi/SpringSpiReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/spi/SpringSpiReferenceContributor$2", "getReferencesByElement"));
                }
                String text = element.getText();
                String[] words = text.split("\\s");
                if (words.length != 1) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                Object[] classReferences = CLASS_REFERENCE_PROVIDER.getReferencesByString(words[0], element, 0);
                PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])classReferences, (Object)((Object)new DefaultKeyReference(element)), PsiReference.class);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiReferenceContributor$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, 100.0);
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.psiElement(PropertyValueImpl.class).inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().ofType((FileType)SpringSpiFileProvider.FILE_TYPE)), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/spi/SpringSpiReferenceContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/spi/SpringSpiReferenceContributor$3", "getReferencesByElement"));
                }
                final String text = element.getText();
                final Ref allReferences = Ref.create((Object)PsiReference.EMPTY_ARRAY);
                new DelimitedListProcessor(","){

                    protected void processToken(int start, int end, boolean delimitersOnly) {
                        Object[] references = CLASS_REFERENCE_PROVIDER.getReferencesByString(text.substring(start, end), element, start);
                        allReferences.set((Object)ArrayUtil.mergeArrays((Object[])((Object[])allReferences.get()), (Object[])references));
                    }
                }.processText(text);
                PsiReference[] psiReferenceArray = (PsiReference[])allReferences.get();
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiReferenceContributor$3", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, 100.0);
    }

    private static class DefaultKeyReference
    extends PsiReferenceBase.Immediate<PsiElement> {
        private static final String[] DEFAULT_KEYS = new String[]{"org.springframework.context.ApplicationListener", "org.springframework.context.ApplicationContextInitializer", "org.springframework.test.context.TestExecutionListener", "org.springframework.integration.config.IntegrationConfigurationInitializer", "org.springframework.boot.autoconfigure.EnableAutoConfiguration", "org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider", "org.springframework.boot.actuate.autoconfigure.EndpointWebMvcConfiguration"};

        private DefaultKeyReference(PsiElement element) {
            super(element, true, element);
        }

        @NotNull
        public Object[] getVariants() {
            PsiFile containingFile = this.getElement().getContainingFile();
            if (!(containingFile instanceof PropertiesFile)) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiReferenceContributor$DefaultKeyReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiReferenceContributor$DefaultKeyReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            SmartList variants = new SmartList();
            PropertiesFile propertiesFile = (PropertiesFile)containingFile;
            for (String key : DEFAULT_KEYS) {
                PsiClass psiClass;
                if (propertiesFile.findPropertyByKey(key) != null || (psiClass = JavaPsiFacade.getInstance((Project)containingFile.getProject()).findClass(key, scope)) == null) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((Object)psiClass, (String)key).withIcon(SpringApiIcons.Spring);
                variants.add(builder);
            }
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiReferenceContributor$DefaultKeyReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

