/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow;

import com.intellij.ide.SelectInContext;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBeansViewSelectInTargetPathBuilder {
    private Object[] myPath = ArrayUtil.EMPTY_OBJECT_ARRAY;
    private Module myModule;
    private SpringBeansViewSettings myViewSettings;

    SpringBeansViewSelectInTargetPathBuilder(SelectInContext context) {
        PsiElement element = this.getElement(context);
        if (element != null) {
            this.calculatePath(element);
        }
    }

    boolean canSelect() {
        return this.myPath.length != 0;
    }

    Object[] getPath() {
        return this.myPath;
    }

    private PsiElement getElement(SelectInContext context) {
        Object selector = context.getSelectorInFile();
        if (!(selector instanceof PsiElement)) {
            return null;
        }
        PsiElement element = (PsiElement)selector;
        this.myModule = ModuleUtilCore.findModuleForFile((VirtualFile)context.getVirtualFile(), (Project)context.getProject());
        if (this.myModule == null) {
            return null;
        }
        this.myViewSettings = SpringBeansViewSettings.getInstance(this.myModule.getProject());
        return element;
    }

    private void calculatePath(PsiElement element) {
        SpringBeanPointer springBeanPointer = null;
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiClassOwner) {
            springBeanPointer = SpringBeansViewSelectInTargetPathBuilder.findSpringBeanInCode(element);
        } else if (file instanceof XmlFile) {
            springBeanPointer = SpringBeansViewSelectInTargetPathBuilder.findSpringBeanInXml(element, (XmlFile)file);
        }
        if (springBeanPointer == null) {
            return;
        }
        FileSetAndConfigFileResult result = this.determineFileSetAndConfigFile(springBeanPointer);
        if (result.springFileSet == null) {
            return;
        }
        SmartList pathValues = new SmartList();
        if (this.myViewSettings.isShowModules()) {
            pathValues.add(result.springFileSet.getFacet().getModule());
            if (this.myViewSettings.isShowFileSets()) {
                pathValues.add(result.springFileSet);
                if (this.myViewSettings.isShowFiles()) {
                    pathValues.add(result.configFile);
                }
            }
        }
        pathValues.add(springBeanPointer);
        this.myPath = ArrayUtil.toObjectArray((Collection)pathValues);
    }

    @Nullable
    private static SpringBeanPointer findSpringBeanInCode(PsiElement element) {
        JamPsiMemberSpringBean memberSpringBean;
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass)) {
            return null;
        }
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
        if (!info.isMapped()) {
            return null;
        }
        if (info.isMappedDomBean()) {
            return (SpringBeanPointer)info.getMappedDomBeans().get(0);
        }
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (psiMethod != null && (memberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)element.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiMethod)) != null) {
            return BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)memberSpringBean);
        }
        return (SpringBeanPointer)info.getStereotypeMappedBeans().get(0);
    }

    @Nullable
    private static SpringBeanPointer findSpringBeanInXml(PsiElement element, XmlFile file) {
        if (!SpringDomUtils.isSpringXml((XmlFile)file)) {
            return null;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null) {
            return null;
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)tag);
        if (domElement == null) {
            return null;
        }
        DomSpringBean domSpringBean = (DomSpringBean)domElement.getParentOfType(DomSpringBean.class, false);
        if (domSpringBean != null) {
            return BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)domSpringBean);
        }
        return null;
    }

    private FileSetAndConfigFileResult determineFileSetAndConfigFile(SpringBeanPointer springBeanPointer) {
        FileSetAndConfigFileResult result = new FileSetAndConfigFileResult();
        if (!springBeanPointer.isValid()) {
            return result;
        }
        result.configFile = springBeanPointer.getContainingFile();
        SpringContextDescriptor context = SpringMultipleContextsManager.getInstance().getContextDescriptor(result.configFile);
        if (!context.isPredefinedContext()) {
            String contextName = context.getName();
            Module module2 = context.getModule();
            assert (module2 != null) : contextName;
            SpringFacet springFacet = SpringFacet.getInstance((Module)module2);
            assert (springFacet != null);
            for (SpringFileSet springFileSet : SpringFileSetService.getInstance().getAllSets(springFacet)) {
                if (!springFileSet.getName().equals(contextName)) continue;
                result.springFileSet = springFileSet;
                break;
            }
            return result;
        }
        boolean found = ModuleUtilCore.visitMeAndDependentModules((Module)this.myModule, module -> {
            SpringFileSet fileSet = SpringFileSetService.getInstance().findFileSet(module, result.configFile);
            if (fileSet != null) {
                result.springFileSet = fileSet;
                return false;
            }
            return true;
        });
        if (!found) {
            return result;
        }
        if (springBeanPointer instanceof JamSpringBeanPointer) {
            PsiClass beanClass = springBeanPointer.getBeanClass();
            assert (beanClass != null);
            JamPsiMemberSpringBean stereotypeBean = (JamPsiMemberSpringBean)((JamSpringBeanPointer)springBeanPointer).getSpringBean();
            ModuleUtilCore.visitMeAndDependentModules((Module)this.myModule, module -> {
                Set models = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
                for (SpringModel model : models) {
                    boolean exists;
                    if (model.getFileSet() == null || !(exists = SpringModelSearchers.doesBeanExist((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)beanClass)))) continue;
                    for (CommonSpringModel process : model.getModelsToProcess()) {
                        for (SpringBeansPackagesScan scan : process.getComponentScans()) {
                            if (!scan.getScannedElements(module).contains(stereotypeBean)) continue;
                            result.springFileSet = model.getFileSet();
                            result.configFile = (PsiFile)ObjectUtils.assertNotNull((Object)scan.getContainingFile());
                            return false;
                        }
                    }
                }
                return true;
            });
        }
        return result;
    }

    private static class FileSetAndConfigFileResult {
        @Nullable
        private SpringFileSet springFileSet;
        @NotNull
        private PsiFile configFile;

        private FileSetAndConfigFileResult() {
        }
    }
}

