/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view.tool;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.view.tool.ArtifactSyncTrackerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompilationStatusAdapter;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ArtifactSyncTracker
implements Disposable {
    private final Project myProject;
    private ArtifactSyncTrackerListener myListener;
    private Map<CommonModel, ServerSync> myServer2Sync;

    public ArtifactSyncTracker(Project project) {
        this.myProject = project;
        this.myServer2Sync = new HashMap<CommonModel, ServerSync>();
        this.updateServersList();
        CompilerManager.getInstance((Project)this.myProject).addCompilationStatusListener((CompilationStatusListener)new CompilationStatusAdapter(){

            public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (!aborted && errors == 0) {
                    ArtifactSyncTracker.this.onCompilationSuccess(compileContext);
                }
            }
        }, (Disposable)this);
    }

    public void dispose() {
    }

    public void setListener(ArtifactSyncTrackerListener listener) {
        this.myListener = listener;
    }

    private void onCompilationSuccess(CompileContext compileContext) {
        Artifact[] compiledArtifacts = ArtifactCompileScope.getArtifacts((CompileScope)compileContext.getCompileScope());
        if (compiledArtifacts == null) {
            return;
        }
        final List<Artifact> compiledArtifactsList = Arrays.asList(compiledArtifacts);
        new ServersIterator(){

            @Override
            protected void processServer(CommonModel server) {
                ArtifactSyncTracker.this.findOrCreateServerSync(server).markArtifactsUnsynced(compiledArtifactsList);
            }
        }.iterateServers();
        if (this.myListener != null) {
            this.myListener.artifactsUnsynced();
        }
    }

    public void updateServersList() {
        final HashMap<CommonModel, ServerSync> newServer2sync = new HashMap<CommonModel, ServerSync>();
        new ServersIterator(){

            @Override
            protected void processServer(CommonModel server) {
                newServer2sync.put(server, ArtifactSyncTracker.this.myServer2Sync.containsKey(server) ? (ServerSync)ArtifactSyncTracker.this.myServer2Sync.get(server) : new ServerSync());
            }
        }.iterateServers();
        this.myServer2Sync = newServer2sync;
    }

    public boolean isArtifactSynced(CommonStrategy server, Artifact artifact) {
        return this.findOrCreateServerSync((CommonModel)server).isArtifactSynced(artifact);
    }

    public void updateDeploymentSync(CommonStrategy server, DeploymentModel model, DeploymentStatus newStatus) {
        Artifact artifact = model.getArtifact();
        if (artifact != null) {
            this.updateArtifactSync(server, artifact, newStatus);
        }
    }

    private void updateArtifactSync(CommonStrategy server, Artifact artifact, DeploymentStatus newStatus) {
        if (newStatus == DeploymentStatus.DEPLOYED) {
            this.findOrCreateServerSync((CommonModel)server).markArtifactSynced(artifact);
        }
    }

    @NotNull
    private ServerSync findOrCreateServerSync(@NotNull CommonModel server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/javaee/view/tool/ArtifactSyncTracker", "findOrCreateServerSync"));
        }
        if (this.myServer2Sync.containsKey(server)) {
            ServerSync serverSync = this.myServer2Sync.get(server);
            if (serverSync == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/view/tool/ArtifactSyncTracker", "findOrCreateServerSync"));
            }
            return serverSync;
        }
        this.updateServersList();
        if (this.myServer2Sync.containsKey(server)) {
            ServerSync serverSync = this.myServer2Sync.get(server);
            if (serverSync == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/view/tool/ArtifactSyncTracker", "findOrCreateServerSync"));
            }
            return serverSync;
        }
        ServerSync result = new ServerSync();
        this.myServer2Sync.put(server, result);
        ServerSync serverSync = result;
        if (serverSync == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/view/tool/ArtifactSyncTracker", "findOrCreateServerSync"));
        }
        return serverSync;
    }

    private abstract class ServersIterator {
        private ServersIterator() {
        }

        public void iterateServers() {
            for (RunnerAndConfigurationSettings configuration : RunManagerEx.getInstanceEx((Project)ArtifactSyncTracker.this.myProject).getSortedConfigurations()) {
                if (!(configuration.getConfiguration() instanceof CommonModel)) continue;
                CommonModel server = (CommonModel)configuration.getConfiguration();
                this.processServer(server);
            }
        }

        protected abstract void processServer(CommonModel var1);
    }

    private static class ServerSync {
        private final Set<Artifact> mySyncedArtifacts = new HashSet<Artifact>();

        public void markArtifactsUnsynced(Collection<Artifact> unsyncedArtifacts) {
            this.mySyncedArtifacts.removeAll(unsyncedArtifacts);
        }

        public void markArtifactSynced(Artifact syncedArtifact) {
            this.mySyncedArtifacts.add(syncedArtifact);
        }

        public boolean isArtifactSynced(Artifact artifact) {
            return this.mySyncedArtifacts.contains(artifact);
        }
    }
}

