/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.files.VtlFileViewProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlErrorFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        if (highlightInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/velocity/inspections/VtlErrorFilter", "accept"));
        }
        return VtlErrorFilter.shouldHighlightInFile(file);
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/VtlErrorFilter", "shouldHighlightErrorElement"));
        }
        return VtlErrorFilter.shouldHighlightInFile(element.getContainingFile());
    }

    private static boolean shouldHighlightInFile(PsiFile file) {
        if (file == null) {
            return true;
        }
        return !((file = InjectedLanguageUtil.getTopLevelFile((PsiElement)file)).getViewProvider() instanceof VtlFileViewProvider) || file instanceof VtlFile;
    }
}

