/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;

public class MavenProjectIndicesManager
extends MavenSimpleProjectComponent {
    private volatile List<MavenIndex> myProjectIndices = new ArrayList<MavenIndex>();
    private final MergingUpdateQueue myUpdateQueue;

    public static MavenProjectIndicesManager getInstance(Project p) {
        return (MavenProjectIndicesManager)((Object)p.getComponent(MavenProjectIndicesManager.class));
    }

    public MavenProjectIndicesManager(Project project) {
        super(project);
        this.myUpdateQueue = new MavenMergingUpdateQueue(((Object)((Object)this)).getClass().getSimpleName(), 1000, true, (Disposable)project);
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        this.doInit();
    }

    public void doInit() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleUpdateIndicesList();
        }
        this.getMavenProjectManager().addManagerListener(new MavenProjectsManager.Listener(){

            @Override
            public void activated() {
                MavenProjectIndicesManager.this.scheduleUpdateIndicesList();
            }

            @Override
            public void projectsScheduled() {
            }

            @Override
            public void importAndResolveScheduled() {
            }
        });
        this.getMavenProjectManager().addProjectsTreeListener(new MavenProjectsTree.ListenerAdapter(){

            @Override
            public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
                MavenProjectIndicesManager.this.scheduleUpdateIndicesList();
            }

            @Override
            public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
                MavenProjectIndicesManager.this.scheduleUpdateIndicesList();
            }
        });
    }

    private void scheduleUpdateIndicesList() {
        this.scheduleUpdateIndicesList(null);
    }

    public void scheduleUpdateIndicesList(final @Nullable Consumer<List<MavenIndex>> consumer) {
        this.myUpdateQueue.queue(new Update((Object)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                File localRepository;
                Set remoteRepositoriesIdsAndUrls;
                AccessToken accessToken = ReadAction.start();
                try {
                    if (MavenProjectIndicesManager.this.myProject.isDisposed()) {
                        return;
                    }
                    remoteRepositoriesIdsAndUrls = MavenProjectIndicesManager.this.collectRemoteRepositoriesIdsAndUrls();
                    localRepository = MavenProjectIndicesManager.this.getLocalRepository();
                }
                finally {
                    accessToken.finish();
                }
                MavenProjectIndicesManager.this.myProjectIndices = MavenIndicesManager.getInstance().ensureIndicesExist(MavenProjectIndicesManager.this.myProject, localRepository, remoteRepositoriesIdsAndUrls);
                if (consumer != null) {
                    consumer.consume((Object)MavenProjectIndicesManager.this.myProjectIndices);
                }
            }
        });
    }

    private File getLocalRepository() {
        return MavenProjectsManager.getInstance(this.myProject).getLocalRepository();
    }

    private Set<Pair<String, String>> collectRemoteRepositoriesIdsAndUrls() {
        THashSet result = new THashSet();
        HashSet remoteRepositories = ContainerUtil.newHashSet(this.getMavenProjectManager().getRemoteRepositories());
        for (MavenRepositoryProvider repositoryProvider : (MavenRepositoryProvider[])MavenRepositoryProvider.EP_NAME.getExtensions()) {
            ContainerUtil.addAll((Collection)remoteRepositories, repositoryProvider.getRemoteRepositories(this.myProject));
        }
        for (MavenRemoteRepository each : remoteRepositories) {
            String id = each.getId();
            String url = each.getUrl();
            result.add(Pair.create((Object)id, (Object)url));
        }
        return result;
    }

    public List<MavenIndex> getIndices() {
        return new ArrayList<MavenIndex>(this.myProjectIndices);
    }

    public void scheduleUpdateAll() {
        MavenIndicesManager.getInstance().scheduleUpdate(this.myProject, this.myProjectIndices);
    }

    public void scheduleUpdate(List<MavenIndex> indices) {
        MavenIndicesManager.getInstance().scheduleUpdate(this.myProject, indices);
    }

    public MavenIndicesManager.IndexUpdatingState getUpdatingState(MavenIndex index) {
        return MavenIndicesManager.getInstance().getUpdatingState(index);
    }

    private MavenProjectsManager getMavenProjectManager() {
        return MavenProjectsManager.getInstance(this.myProject);
    }

    public Set<String> getGroupIds() {
        ProgressIndicatorProvider.checkCanceled();
        Set<String> result = this.getProjectGroupIds();
        for (MavenIndex each : this.myProjectIndices) {
            result.addAll(each.getGroupIds());
        }
        return result;
    }

    public Set<String> getArtifactIds(String groupId) {
        ProgressIndicatorProvider.checkCanceled();
        Set<String> result = this.getProjectArtifactIds(groupId);
        for (MavenIndex each : this.myProjectIndices) {
            result.addAll(each.getArtifactIds(groupId));
        }
        return result;
    }

    public Set<String> getVersions(String groupId, String artifactId) {
        ProgressIndicatorProvider.checkCanceled();
        Set<String> result = this.getProjectVersions(groupId, artifactId);
        for (MavenIndex each : this.myProjectIndices) {
            result.addAll(each.getVersions(groupId, artifactId));
        }
        return result;
    }

    public boolean hasGroupId(String groupId) {
        if (this.hasProjectGroupId(groupId)) {
            return true;
        }
        for (MavenIndex each : this.myProjectIndices) {
            if (!each.hasGroupId(groupId)) continue;
            return true;
        }
        return this.checkLocalRepository(groupId, null, null);
    }

    private boolean checkLocalRepository(String groupId, String artifactId, String version) {
        if (StringUtil.isEmpty((String)groupId)) {
            return false;
        }
        String relPath = groupId.replace('.', '/');
        if (artifactId != null) {
            relPath = relPath + "/" + artifactId;
            if (version != null) {
                relPath = relPath + "/" + version + "/" + artifactId + "-" + version + ".pom";
            }
        }
        File file = new File(this.getLocalRepository(), relPath);
        return file.exists();
    }

    public boolean hasArtifactId(String groupId, String artifactId) {
        if (this.hasProjectArtifactId(groupId, artifactId)) {
            return true;
        }
        for (MavenIndex each : this.myProjectIndices) {
            if (!each.hasArtifactId(groupId, artifactId)) continue;
            return true;
        }
        return this.checkLocalRepository(groupId, artifactId, null);
    }

    public boolean hasVersion(String groupId, String artifactId, String version) {
        if (this.hasProjectVersion(groupId, artifactId, version)) {
            return true;
        }
        for (MavenIndex each : this.myProjectIndices) {
            if (!each.hasVersion(groupId, artifactId, version)) continue;
            return true;
        }
        return this.checkLocalRepository(groupId, artifactId, version);
    }

    public Set<MavenArtifactInfo> search(Query query, int maxResult) {
        THashSet result = new THashSet();
        for (MavenIndex each : this.myProjectIndices) {
            int remained = maxResult - result.size();
            if (remained <= 0) break;
            result.addAll(each.search(query, remained));
        }
        return result;
    }

    private Set<String> getProjectGroupIds() {
        THashSet result = new THashSet();
        for (MavenId each : this.getProjectsIds()) {
            result.add(each.getGroupId());
        }
        return result;
    }

    private Set<String> getProjectArtifactIds(String groupId) {
        THashSet result = new THashSet();
        for (MavenId each : this.getProjectsIds()) {
            if (!groupId.equals(each.getGroupId())) continue;
            result.add(each.getArtifactId());
        }
        return result;
    }

    private Set<String> getProjectVersions(String groupId, String artifactId) {
        THashSet result = new THashSet();
        for (MavenId each : this.getProjectsIds()) {
            if (!groupId.equals(each.getGroupId()) || !artifactId.equals(each.getArtifactId())) continue;
            result.add(each.getVersion());
        }
        return result;
    }

    private boolean hasProjectGroupId(String groupId) {
        return this.getProjectGroupIds().contains(groupId);
    }

    private boolean hasProjectArtifactId(String groupId, String artifactId) {
        return this.getProjectArtifactIds(groupId).contains(artifactId);
    }

    private boolean hasProjectVersion(String groupId, String artifactId, String version) {
        return this.getProjectVersions(groupId, artifactId).contains(version);
    }

    private Set<MavenId> getProjectsIds() {
        THashSet result = new THashSet();
        for (MavenProject each : MavenProjectsManager.getInstance(this.myProject).getProjects()) {
            result.add(each.getMavenId());
        }
        return result;
    }
}

