/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.SoutMavenConsole;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.services.MavenRepositoryServicesManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.RepositoryAttachDialog;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;
import org.jetbrains.idea.maven.utils.library.remote.MavenDependenciesRemoteManager;

public class RepositoryAttachHandler {
    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project, @Nullable String initialFilter, JComponent parentComponent) {
        List<MavenRepositoryInfo> repositories;
        boolean attachSources;
        boolean attachJavaDoc;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "chooseLibraryAndDownload"));
        }
        RepositoryAttachDialog dialog = new RepositoryAttachDialog(project, initialFilter);
        dialog.setTitle("Download Library From Maven Repository");
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        String copyTo = dialog.getDirectoryPath();
        String coord = dialog.getCoordinateText();
        NewLibraryConfiguration configuration = RepositoryAttachHandler.resolveAndDownload(project, coord, attachJavaDoc = dialog.getAttachJavaDoc(), attachSources = dialog.getAttachSources(), copyTo, repositories = dialog.getRepositories());
        if (configuration == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)ProjectBundle.message("maven.downloading.failed", coord), (String)CommonBundle.getErrorTitle());
        }
        return configuration;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(Project project, String coord, boolean attachJavaDoc, boolean attachSources, @Nullable String copyTo, List<MavenRepositoryInfo> repositories) {
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(coord);
        final List<OrderRoot> roots = MavenDependenciesRemoteManager.getInstance(project).downloadDependenciesModal(libraryProperties, attachSources, attachJavaDoc, copyTo);
        if (roots == null || roots.size() == 0) {
            return null;
        }
        RepositoryAttachHandler.notifyArtifactsDownloaded(project, roots);
        RepositoryLibraryDescription libraryDescription = RepositoryLibraryDescription.findDescription(libraryProperties);
        return new NewLibraryConfiguration(libraryDescription.getDisplayName(libraryProperties.getVersion()), RepositoryLibraryType.getInstance(), new RepositoryLibraryProperties(coord)){

            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler$1", "addRoots"));
                }
                editor.addRoots((Collection)roots);
            }
        };
    }

    @NotNull
    public static List<OrderRoot> resolveAndDownloadImpl(Project project, String coord, boolean attachJavaDoc, boolean attachSources, @Nullable String copyTo, List<MavenRepositoryInfo> repositories, ProgressIndicator indicator) {
        SmartList extraTypes = new SmartList();
        if (attachSources) {
            extraTypes.add((Object)MavenExtraArtifactType.SOURCES);
        }
        if (attachJavaDoc) {
            extraTypes.add((Object)MavenExtraArtifactType.DOCS);
        }
        Ref result = Ref.create(null);
        RepositoryAttachHandler.doResolveInner(project, RepositoryAttachHandler.getMavenId(coord), (List<MavenExtraArtifactType>)extraTypes, repositories, (Processor<List<MavenArtifact>>)((Processor)artifacts -> {
            if (!artifacts.isEmpty()) {
                WriteAction.run(() -> {
                    List<OrderRoot> roots = RepositoryAttachHandler.createRoots(artifacts, copyTo);
                    result.set(roots);
                });
            }
            return true;
        }), indicator);
        List roots = (List)result.get();
        List list = roots == null ? Collections.emptyList() : roots;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "resolveAndDownloadImpl"));
        }
        return list;
    }

    public static void notifyArtifactsDownloaded(Project project, List<OrderRoot> roots) {
        StringBuilder sb = new StringBuilder();
        String title = "The following files were downloaded:";
        sb.append("<ol>");
        for (OrderRoot root : roots) {
            sb.append("<li>");
            sb.append(root.getFile().getName());
            sb.append("</li>");
        }
        sb.append("</ol>");
        Notifications.Bus.notify((Notification)new Notification("Repository", "The following files were downloaded:", sb.toString(), NotificationType.INFORMATION), (Project)project);
    }

    public static List<OrderRoot> createRoots(@NotNull Collection<MavenArtifact> artifacts, @Nullable String copyTo) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "createRoots"));
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (MavenArtifact each : artifacts) {
            try {
                File repoFile;
                File toFile = repoFile = each.getFile();
                if (copyTo != null) {
                    toFile = new File(copyTo, repoFile.getName());
                    if (repoFile.exists()) {
                        FileUtil.copy((File)repoFile, (File)toFile);
                    }
                }
                manager.refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)toFile.getPath())));
                String url = VfsUtil.getUrlForLibraryRoot((File)toFile);
                VirtualFile file = manager.refreshAndFindFileByUrl(url);
                if (file == null) continue;
                OrderRootType rootType = MavenExtraArtifactType.DOCS.getDefaultClassifier().equals(each.getClassifier()) ? JavadocOrderRootType.getInstance() : (MavenExtraArtifactType.SOURCES.getDefaultClassifier().equals(each.getClassifier()) ? OrderRootType.SOURCES : OrderRootType.CLASSES);
                result.add(new OrderRoot(file, rootType));
            }
            catch (MalformedURLException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
            catch (IOException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return result;
    }

    public static void searchArtifacts(Project project, String coord, final PairProcessor<Collection<Pair<MavenArtifactInfo, MavenRepositoryInfo>>, Boolean> resultProcessor) {
        if (coord == null || coord.length() == 0) {
            return;
        }
        final MavenArtifactInfo template = coord.indexOf(58) == -1 && Character.isUpperCase(coord.charAt(0)) ? new MavenArtifactInfo(null, null, null, "jar", null, coord, null) : new MavenArtifactInfo(RepositoryAttachHandler.getMavenId(coord), "jar", null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler$2", "run"));
                }
                String[] urls = MavenRepositoryServicesManager.getServiceUrls();
                boolean tooManyResults = false;
                AtomicBoolean proceedFlag = new AtomicBoolean(true);
                int length = urls.length;
                for (int i = 0; i < length && proceedFlag.get(); ++i) {
                    Boolean aBoolean;
                    ArrayList<Pair> resultList;
                    block10: {
                        List<MavenArtifactInfo> artifacts;
                        String serviceUrl;
                        block11: {
                            resultList = new ArrayList<Pair>();
                            serviceUrl = urls[i];
                            artifacts = MavenRepositoryServicesManager.findArtifacts(template, serviceUrl);
                            if (artifacts.isEmpty()) break block10;
                            if (proceedFlag.get()) break block11;
                            if (!proceedFlag.get()) break;
                            Boolean aBoolean2 = i == length - 1 ? Boolean.valueOf(tooManyResults) : null;
                            ApplicationManager.getApplication().invokeLater(() -> proceedFlag.set(resultProcessor.process((Object)resultList, (Object)aBoolean2)), o -> !proceedFlag.get());
                            break;
                        }
                        try {
                            List<MavenRepositoryInfo> repositories = MavenRepositoryServicesManager.getRepositories(serviceUrl);
                            THashMap map = new THashMap();
                            for (MavenRepositoryInfo repository : repositories) {
                                map.put(repository.getId(), repository);
                            }
                            for (MavenArtifactInfo artifact : artifacts) {
                                if (artifact == null) {
                                    tooManyResults = true;
                                    continue;
                                }
                                MavenRepositoryInfo repository = (MavenRepositoryInfo)map.get(artifact.getRepositoryId());
                                if (repository == null) continue;
                                resultList.add(Pair.create((Object)artifact, (Object)repository));
                            }
                        }
                        catch (Exception e) {
                            try {
                                MavenLog.LOG.error((Throwable)e);
                                if (!proceedFlag.get()) break;
                                aBoolean = i == length - 1 ? Boolean.valueOf(tooManyResults) : null;
                            }
                            catch (Throwable throwable) {
                                if (!proceedFlag.get()) break;
                                Boolean aBoolean3 = i == length - 1 ? Boolean.valueOf(tooManyResults) : null;
                                ApplicationManager.getApplication().invokeLater(() -> proceedFlag.set(resultProcessor.process((Object)resultList, (Object)aBoolean2)), o -> !proceedFlag.get());
                                throw throwable;
                            }
                            ApplicationManager.getApplication().invokeLater(() -> proceedFlag.set(resultProcessor.process((Object)resultList, (Object)aBoolean2)), o -> !proceedFlag.get());
                            continue;
                        }
                    }
                    if (!proceedFlag.get()) break;
                    aBoolean = i == length - 1 ? Boolean.valueOf(tooManyResults) : null;
                    ApplicationManager.getApplication().invokeLater(() -> proceedFlag.set(resultProcessor.process((Object)resultList, (Object)aBoolean2)), o -> !proceedFlag.get());
                    continue;
                }
            }
        });
    }

    public static void searchRepositories(Project project, final Collection<String> nexusUrls, final Processor<Collection<MavenRepositoryInfo>> resultProcessor) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler$3", "run"));
                }
                Ref result = Ref.create(Collections.emptyList());
                try {
                    ArrayList<MavenRepositoryInfo> repoList = new ArrayList<MavenRepositoryInfo>();
                    for (String nexusUrl : nexusUrls) {
                        List<MavenRepositoryInfo> repositories;
                        try {
                            repositories = MavenRepositoryServicesManager.getRepositories(nexusUrl);
                        }
                        catch (Exception ex) {
                            MavenLog.LOG.warn("Accessing Service at: " + nexusUrl, (Throwable)ex);
                            continue;
                        }
                        repoList.addAll(repositories);
                    }
                    result.set(repoList);
                }
                catch (Exception e) {
                    MavenLog.LOG.error((Throwable)e);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.process(result.get()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doResolveInner(Project project, MavenId mavenId, List<MavenExtraArtifactType> extraTypes, Collection<MavenRepositoryInfo> repositories, @Nullable Processor<List<MavenArtifact>> resultProcessor, ProgressIndicator indicator) {
        boolean cancelled = false;
        LinkedHashSet<MavenArtifact> result = new LinkedHashSet<MavenArtifact>();
        MavenEmbeddersManager manager = MavenProjectsManager.getInstance(project).getEmbeddersManager();
        MavenEmbedderWrapper embedder = manager.getEmbedder(MavenEmbeddersManager.FOR_DOWNLOAD, null, null);
        try {
            MavenGeneralSettings mavenGeneralSettings = MavenProjectsManager.getInstance(project).getGeneralSettings();
            embedder.customizeForResolve(new SoutMavenConsole(mavenGeneralSettings.getOutputLevel(), mavenGeneralSettings.isPrintErrorStackTraces()), new MavenProgressIndicator(indicator));
            List<MavenRemoteRepository> remoteRepositories = RepositoryAttachHandler.convertRepositories(repositories);
            List<MavenArtifactInfo> artifacts = Collections.singletonList(new MavenArtifactInfo(mavenId, "jar", null));
            List<MavenArtifact> firstResult = embedder.resolveTransitively(artifacts, remoteRepositories);
            for (MavenArtifact artifact : firstResult) {
                if (!artifact.isResolved() || "test".equals(artifact.getScope())) continue;
                result.add(artifact);
            }
            if (!extraTypes.isEmpty()) {
                Set allowedClassifiers = JBIterable.from(extraTypes).transform(extraType -> extraType.getDefaultClassifier()).toSet();
                List resolve = JBIterable.from(extraTypes).transform(extraType -> new MavenArtifactInfo(mavenId, extraType.getDefaultExtension(), extraType.getDefaultClassifier())).toList();
                for (MavenArtifact artifact : embedder.resolveTransitively(new ArrayList<MavenArtifactInfo>(resolve), remoteRepositories)) {
                    if (!artifact.isResolved() || "test".equals(artifact.getScope()) || !allowedClassifiers.contains(artifact.getClassifier())) continue;
                    result.add(artifact);
                }
            }
        }
        catch (MavenProcessCanceledException e) {
            cancelled = true;
        }
        finally {
            manager.release(embedder);
            if (!cancelled && resultProcessor != null) {
                ApplicationManager.getApplication().invokeAndWait(() -> resultProcessor.process(new ArrayList(result)));
            }
        }
    }

    private static List<MavenRemoteRepository> convertRepositories(Collection<MavenRepositoryInfo> infos) {
        ArrayList<MavenRemoteRepository> result = new ArrayList<MavenRemoteRepository>(infos.size());
        for (MavenRepositoryInfo each : infos) {
            if (each.getUrl() == null) continue;
            result.add(new MavenRemoteRepository(each.getId(), each.getName(), each.getUrl(), null, null, null));
        }
        return result;
    }

    public static MavenId getMavenId(@NotNull String coord) {
        if (coord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coord", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "getMavenId"));
        }
        String[] parts = coord.split(":");
        return new MavenId(parts.length > 0 ? parts[0] : null, parts.length > 1 ? parts[1] : null, parts.length > 2 ? parts[2] : null);
    }
}

