/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.agent;

import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.SimpleAgentBase;
import com.intellij.javaee.oss.agent.SimpleAgentException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.management.JMException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.RemoteInitialContextFactory;

public class TomEEAgent
extends SimpleAgentBase {
    private Deployer myDeployer;

    protected boolean doConnect() throws IOException, JMException, SimpleAgentException {
        if (this.myDeployer == null) {
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
            props.setProperty("java.naming.provider.url", new URL("http", this.getHost(), this.getPort(), "/tomee/ejb").toExternalForm());
            try {
                InitialContext context = new InitialContext(props);
                this.myDeployer = (Deployer)context.lookup("openejb/DeployerBusinessRemote");
            }
            catch (NamingException e) {
                throw new SimpleAgentException((Exception)e);
            }
            catch (ClientRuntimeException e) {
                throw new SimpleAgentException((Exception)((Object)e));
            }
        }
        return true;
    }

    protected void doDeploy(String deploymentName, File source, ParametersMap deployParameters) throws IOException, JMException, SimpleAgentException {
        try {
            String path = source.getAbsolutePath();
            if (Boolean.parseBoolean((String)deployParameters.get((Object)"use.context.root"))) {
                Properties properties = new Properties();
                properties.setProperty("webapp." + path + ".context-root", (String)deployParameters.get((Object)"context.root"));
                this.myDeployer.deploy(path, properties);
            } else {
                this.myDeployer.deploy(path);
            }
        }
        catch (OpenEJBException e) {
            throw new SimpleAgentException((Exception)((Object)e));
        }
        catch (ClientRuntimeException e) {
            throw new SimpleAgentException((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw new SimpleAgentException((Exception)e);
        }
    }

    private AppInfo findDeployment(String deploymentName) throws SimpleAgentException {
        try {
            for (AppInfo appInfo : this.myDeployer.getDeployedApps()) {
                if (!deploymentName.equals(appInfo.path)) continue;
                return appInfo;
            }
        }
        catch (ClientRuntimeException e) {
            throw new SimpleAgentException((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw new SimpleAgentException((Exception)e);
        }
        return null;
    }

    protected void doUndeploy(String deploymentName) throws IOException, JMException, SimpleAgentException {
        AppInfo appInfo = this.findDeployment(deploymentName);
        if (appInfo == null) {
            return;
        }
        try {
            this.myDeployer.undeploy(appInfo.path);
        }
        catch (OpenEJBException e) {
            throw new SimpleAgentException((Exception)((Object)e));
        }
        catch (ClientRuntimeException e) {
            throw new SimpleAgentException((Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw new SimpleAgentException((Exception)e);
        }
    }

    protected boolean doIsDeployed(String deploymentName) throws IOException, JMException, SimpleAgentException {
        return this.findDeployment(deploymentName) != null;
    }

    public void destroy() {
    }
}

