/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageFileSystemItem
extends PsiElementBase
implements PsiFileSystemItem {
    private final PsiPackage myPackage;
    private final GlobalSearchScope myScope;

    public PackageFileSystemItem(PsiPackage aPackage, GlobalSearchScope scope) {
        this.myPackage = aPackage;
        this.myScope = scope;
    }

    public PsiFile getContainingFile() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = StringUtil.notNullize((String)this.myPackage.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/PackageFileSystemItem", "getName"));
        }
        return string;
    }

    public boolean isValid() {
        return this.myPackage.isValid();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPackage.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/PackageFileSystemItem", "getProject"));
        }
        return project;
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/PackageFileSystemItem", "getLanguage"));
        }
        return javaLanguage;
    }

    @NotNull
    public PsiFileSystemItem[] getChildren() {
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiDirectory psiDirectory : this.myPackage.getDirectories(this.myScope)) {
            PsiElement[] children;
            for (PsiElement child : children = psiDirectory.getChildren()) {
                if (!(child instanceof PsiFile)) continue;
                result.add((PsiFile)child);
            }
        }
        for (PsiDirectory psiDirectory : this.myPackage.getSubPackages(this.myScope)) {
            result.add(new PackageFileSystemItem((PsiPackage)psiDirectory, this.myScope));
        }
        PsiFileSystemItem[] psiFileSystemItemArray = result.toArray(new PsiFileSystemItem[result.size()]);
        if (psiFileSystemItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/PackageFileSystemItem", "getChildren"));
        }
        return psiFileSystemItemArray;
    }

    @Nullable
    public PsiFileSystemItem getParent() {
        PsiPackage parentPackage = this.myPackage.getParentPackage();
        return parentPackage == null ? null : new PackageFileSystemItem(parentPackage, this.myScope);
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return 0;
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return 0;
    }

    public String getText() {
        return null;
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = new char[]{};
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/PackageFileSystemItem", "textToCharArray"));
        }
        return cArray;
    }

    public ASTNode getNode() {
        return null;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        return this.myPackage.getIcon(flags);
    }

    public VirtualFile getVirtualFile() {
        PsiDirectory[] directories = this.myPackage.getDirectories(this.myScope);
        return directories.length > 0 ? directories[0].getVirtualFile() : null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        for (PsiFileSystemItem element : this.getChildren()) {
            if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(element.getName(), element.isDirectory()) || processor.execute((PsiElement)element)) continue;
            return false;
        }
        return true;
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        this.myPackage.checkSetName(name);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/directives/PackageFileSystemItem", "setName"));
        }
        return new PackageFileSystemItem((PsiPackage)this.myPackage.setName(name), this.myScope);
    }
}

