/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlLightVariable
extends FakePsiElement
implements FtlVariable {
    private final String myName;
    private final PsiElement myParent;
    private final FtlType myType;

    public FtlLightVariable(@NotNull @NonNls String name, @NotNull PsiElement parent, @NotNull @NonNls String psiType) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/variables/FtlLightVariable", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/freemarker/psi/variables/FtlLightVariable", "<init>"));
        }
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/freemarker/psi/variables/FtlLightVariable", "<init>"));
        }
        this(name, parent, FtlLightVariable.createFtlType(parent, psiType));
    }

    public FtlLightVariable(@NotNull @NonNls String name, @NotNull PsiElement parent, @Nullable FtlType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/variables/FtlLightVariable", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/freemarker/psi/variables/FtlLightVariable", "<init>"));
        }
        this.myName = name;
        this.myParent = parent;
        this.myType = type;
    }

    @Nullable
    private static FtlPsiType createFtlType(@NotNull PsiElement context, @NonNls String text) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/psi/variables/FtlLightVariable", "createFtlType"));
        }
        try {
            return FtlPsiType.wrap(JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createTypeFromText(text, context));
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlLightVariable", "getUseScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlLightVariable", "getName"));
        }
        return string;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myParent;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlLightVariable", "getNavigationElement"));
        }
        return psiElement;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public Icon getIcon(boolean open) {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    public FtlType getType() {
        return this.myType;
    }
}

