/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexStylesIndexableSetContributor;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FlexCssUtil {
    private static final String STYLE_NAME_SUFFIX = "style-name";

    private FlexCssUtil() {
    }

    public static boolean isStyleNameProperty(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/javascript/flex/css/FlexCssUtil", "isStyleNameProperty"));
        }
        return FlexCssUtil.toClassicForm(propertyName).endsWith(STYLE_NAME_SUFFIX);
    }

    public static boolean isStyleNameMethod(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/javascript/flex/css/FlexCssUtil", "isStyleNameMethod"));
        }
        return "getStyleDeclaration".equals(methodName);
    }

    public static String toClassicForm(String propertyName) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            char c1 = Character.toLowerCase(c);
            if (c1 != c && result.length() > 0) {
                result.append('-');
            }
            result.append(c1);
        }
        return result.toString();
    }

    public static boolean inQuotes(String text) {
        return text != null && text.length() >= 2 && text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"';
    }

    public static void collectAllIncludes(PsiElement element, Set<String> result) {
        String text;
        if (element instanceof JSClass) {
            for (PsiElement elt : JSResolveUtil.getStubbedChildren((PsiElement)element.getParent())) {
                if (elt == element) break;
                if (!(elt instanceof JSIncludeDirective) || (text = ((JSIncludeDirective)elt).getIncludeText()) == null) continue;
                result.add(text);
            }
        }
        for (PsiElement elt : JSResolveUtil.getStubbedChildren((PsiElement)element)) {
            if (elt instanceof JSIncludeDirective) {
                text = ((JSIncludeDirective)elt).getIncludeText();
                if (text == null) continue;
                result.add(text);
                continue;
            }
            if (!(elt instanceof JSAttributeList) && !(elt instanceof JSAttributeListOwner)) continue;
            FlexCssUtil.collectAllIncludes(elt, result);
        }
    }

    public static GlobalSearchScope getResolveScope(PsiElement context) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(false) : context.getResolveScope();
        return FlexStylesIndexableSetContributor.enlarge(scope);
    }
}

