/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.changesignature;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSChangeInfo
implements ChangeInfo {
    private final JSFunction myMethod;
    private final String myNewName;
    private final JSAttributeList.AccessType myNewVisibility;
    private final String myNewReturnType;
    private final List<JSParameterInfo> myNewParameters;

    public JSChangeInfo(JSFunction method) {
        this.myMethod = method;
        this.myNewName = method.getName();
        this.myNewVisibility = method.getAttributeList().getAccessType();
        JSType returnType = method.getReturnType();
        this.myNewReturnType = returnType == null ? null : returnType.getResolvedTypeText();
        this.myNewParameters = JSMethodDescriptor.getParameters((JSFunction)method);
    }

    @NotNull
    public JSParameterInfo[] getNewParameters() {
        JSParameterInfo[] jSParameterInfoArray = this.myNewParameters.toArray(new JSParameterInfo[this.myNewParameters.size()]);
        if (jSParameterInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/changesignature/JSChangeInfo", "getNewParameters"));
        }
        return jSParameterInfoArray;
    }

    public boolean isParameterSetOrOrderChanged() {
        return false;
    }

    public JSFunction getMethod() {
        return this.myMethod;
    }

    public boolean isReturnTypeChanged() {
        return false;
    }

    public String getNewName() {
        return this.myNewName;
    }

    public Language getLanguage() {
        return JavascriptLanguage.INSTANCE;
    }

    public boolean isParameterTypesChanged() {
        return false;
    }

    public boolean isParameterNamesChanged() {
        return false;
    }

    public boolean isGenerateDelegate() {
        return false;
    }

    public boolean isNameChanged() {
        return false;
    }

    public JSAttributeList.AccessType getNewVisibility() {
        return this.myNewVisibility;
    }
}

