/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.flex.FlexApplicationComponent;
import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptResolveScopeProvider
extends JSElementResolveScopeProvider {
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getResolveScope"));
        }
        return this.getResolveScope(file, project, true);
    }

    @Nullable
    private GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project, boolean checkApplicable) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getResolveScope"));
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if (checkApplicable && !this.isApplicable(file)) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = projectFileIndex.getModuleForFile(file);
        if (module != null) {
            boolean includeTests = projectFileIndex.isInTestSourceContent(file) || !projectFileIndex.isInSourceContent(file);
            GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests);
            GlobalSearchScope fileTypesScope = moduleScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)moduleScope, (FileType[])new FileType[]{TypeScriptFileType.INSTANCE, JavaScriptFileType.INSTANCE})));
            return fileTypesScope.union((SearchScope)GlobalSearchScope.filesScope((Project)project, (Collection)JSCorePredefinedLibrariesProvider.getActionScriptPredefinedLibraryFiles()));
        }
        return null;
    }

    @NotNull
    public GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        GlobalSearchScope scope;
        GlobalSearchScope forced;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getElementResolveScope"));
        }
        GlobalSearchScope tempScope = JSInheritanceUtil.getEnforcedScope();
        if (tempScope != null) {
            GlobalSearchScope globalSearchScope = tempScope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getElementResolveScope"));
            }
            return globalSearchScope;
        }
        PsiElement explicitContext = JSResolveUtil.getContext((PsiElement)element);
        if (explicitContext != null) {
            element = explicitContext;
        }
        if (element instanceof PsiCodeFragment && (forced = ((PsiCodeFragment)element).getForcedResolveScope()) != null) {
            GlobalSearchScope globalSearchScope = forced;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getElementResolveScope"));
            }
            return globalSearchScope;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            GlobalSearchScope globalSearchScope = this.getProjectScopeIncludingPredefines(element.getProject());
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getElementResolveScope"));
            }
            return globalSearchScope;
        }
        PsiFile psiFile = containingFile.getOriginalFile();
        VirtualFile file = psiFile.getVirtualFile();
        Project project = psiFile.getProject();
        if (file == null) {
            GlobalSearchScope globalSearchScope = this.getProjectScopeIncludingPredefines(project);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getElementResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = scope = this.isApplicable(file) ? ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(file) : null;
        if (scope != null) {
            if (ProjectFileIndex.SERVICE.getInstance((Project)project).isInLibraryClasses(file) && !scope.contains(file)) {
                GlobalSearchScope globalSearchScope2 = scope.union((SearchScope)GlobalSearchScope.fileScope((Project)project, (VirtualFile)file));
                if (globalSearchScope2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getElementResolveScope"));
                }
                return globalSearchScope2;
            }
            GlobalSearchScope globalSearchScope3 = scope;
            if (globalSearchScope3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getElementResolveScope"));
            }
            return globalSearchScope3;
        }
        GlobalSearchScope fileResolveScope = this.getResolveScope(file, project, false);
        GlobalSearchScope globalSearchScope4 = fileResolveScope != null ? fileResolveScope : this.getProjectScopeIncludingPredefines(project);
        if (globalSearchScope4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "getElementResolveScope"));
        }
        return globalSearchScope4;
    }

    protected boolean isApplicable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/ActionScriptResolveScopeProvider", "isApplicable"));
        }
        return file.getFileType() == ActionScriptFileType.INSTANCE || file.getFileType() == FlexApplicationComponent.MXML || file.getFileType() == FlexApplicationComponent.SWF_FILE_TYPE;
    }
}

