/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlComment;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class MxmlEnterHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiLanguageInjectionHost context;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/MxmlEnterHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/flex/MxmlEnterHandler", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/intellij/lang/javascript/flex/MxmlEnterHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/lang/javascript/flex/MxmlEnterHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/javascript/flex/MxmlEnterHandler", "preprocessEnter"));
        }
        int offset = (Integer)caretOffset.get();
        if (file instanceof JSFile && (context = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file)) instanceof XmlComment) {
            file = context.getContainingFile();
            editor = ((EditorWindow)editor).getDelegate();
            offset = editor.getCaretModel().getOffset();
        }
        if (!JavaScriptSupportLoader.isFlexMxmFile((PsiFile)file)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (CodeInsightSettings.getInstance().INSERT_BRACE_ON_ENTER && MxmlEnterHandler.isAfterUnmatchedMxmlComment(editor, file, offset)) {
            int lineStart;
            int current;
            String indent = "";
            CharSequence buffer = editor.getDocument().getCharsSequence();
            for (current = lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)buffer, (int)(offset - 1), (String)"\n") + 1; current < offset && Character.isWhitespace(buffer.charAt(current)); ++current) {
            }
            if (current > lineStart) {
                indent = buffer.subSequence(lineStart, current).toString();
            }
            editor.getDocument().insertString(offset, (CharSequence)("\n" + indent + "-->"));
            originalHandler.execute(editor, dataContext);
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isAfterUnmatchedMxmlComment(Editor editor, PsiFile file, int offset) {
        String parentText;
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (offset < 5 || chars.charAt(offset - 1) != '-' || chars.charAt(offset - 2) != '-' || chars.charAt(offset - 3) != '-' || chars.charAt(offset - 4) != '!' || chars.charAt(offset - 5) != '<') {
            return false;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement at = file.findElementAt(offset);
        String marker = "<!---";
        if (at != null && (parentText = at.getParent().getText()).endsWith("-->")) {
            return parentText.indexOf(marker, marker.length()) != -1;
        }
        return true;
    }
}

