/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.airpackage;

import com.intellij.lang.javascript.flex.actions.airpackage.AdtTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PathUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.util.List;

public abstract class AdtPackageTask
extends AdtTask {
    private long myStartTime;
    private final String myPackageFilePath;

    public AdtPackageTask(Project project, Sdk flexSdk, String packageFilePath) {
        super(project, flexSdk);
        this.myPackageFilePath = packageFilePath;
    }

    @Override
    protected List<String> createCommandLine() {
        List<String> command = super.createCommandLine();
        List proxySettings = HttpConfigurable.getInstance().getJvmProperties(false, null);
        int i = 1;
        for (Pair proxySetting : proxySettings) {
            command.add(i++, "-D" + (String)proxySetting.first + "=" + (String)proxySetting.second);
        }
        return command;
    }

    @Override
    protected File getProcessDir() {
        return new File(PathUtil.getParentPath((String)this.myPackageFilePath));
    }

    @Override
    public void start() {
        this.myStartTime = System.currentTimeMillis();
        super.start();
    }

    @Override
    protected boolean checkMessages() {
        return new File(this.myPackageFilePath).lastModified() > this.myStartTime;
    }
}

