/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlashProjectStructureProblem;
import com.intellij.lang.javascript.flex.build.FlexBuildTargetScopeProvider;
import com.intellij.lang.javascript.flex.build.FlexCompilerConfigFileUtil;
import com.intellij.lang.javascript.flex.build.FlexCompilerHandler;
import com.intellij.lang.javascript.flex.build.InfoFromConfigFile;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AirSigningOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirPackagingConfigurableBase;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompilerOptionsConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.DependenciesConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidateFlashConfigurationsPrecompileTask
implements CompileTask {
    private static final String FLASH_COMPILER_GROUP_ID = "Flash Compiler";
    private boolean myParallelCompilationSuggested = false;

    static Collection<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>> getProblems(CompileScope scope, Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCsToCompile) {
        ArrayList<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>> problems = new ArrayList<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>>();
        for (Pair<Module, FlexBuildConfiguration> moduleAndBC : modulesAndBCsToCompile) {
            Module module = (Module)moduleAndBC.first;
            FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
            Consumer errorConsumer = problem -> problems.add(Trinity.create((Object)module, (Object)bc, (Object)problem));
            ValidateFlashConfigurationsPrecompileTask.checkConfiguration(module, bc, false, (Consumer<FlashProjectStructureProblem>)errorConsumer);
            RunConfiguration runConfig = CompileStepBeforeRun.getRunConfiguration((CompileScope)scope);
            if (!bc.getNature().isApp() || !(runConfig instanceof FlashRunConfiguration)) continue;
            FlashRunnerParameters params = ((FlashRunConfiguration)runConfig).getRunnerParameters();
            if (!module.getName().equals(params.getModuleName()) || !bc.getName().equals(params.getBCName())) continue;
            if (bc.getNature().isDesktopPlatform()) {
                FlashRunnerParameters.checkAirVersionIfCustomDescriptor(module, bc.getSdk(), bc.getAirDesktopPackagingOptions(), (Consumer<FlashProjectStructureProblem>)errorConsumer, false, "does not matter");
                continue;
            }
            if (!bc.getNature().isMobilePlatform()) continue;
            block0 : switch (params.getMobileRunTarget()) {
                case Emulator: {
                    switch (params.getAppDescriptorForEmulator()) {
                        case Android: {
                            FlashRunnerParameters.checkAirVersionIfCustomDescriptor(module, bc.getSdk(), bc.getAndroidPackagingOptions(), (Consumer<FlashProjectStructureProblem>)errorConsumer, false, "does not matter");
                            break block0;
                        }
                        case IOS: {
                            FlashRunnerParameters.checkAirVersionIfCustomDescriptor(module, bc.getSdk(), bc.getIosPackagingOptions(), (Consumer<FlashProjectStructureProblem>)errorConsumer, false, "does not matter");
                        }
                    }
                    break;
                }
                case AndroidDevice: {
                    ValidateFlashConfigurationsPrecompileTask.checkPackagingOptions(module, bc.getSdk(), bc.getAndroidPackagingOptions(), false, PathUtil.getParentPath((String)bc.getActualOutputFilePath()), (Consumer<FlashProjectStructureProblem>)errorConsumer);
                    break;
                }
                case iOSSimulator: {
                    ValidateFlashConfigurationsPrecompileTask.checkPackagingOptions(module, bc.getSdk(), bc.getIosPackagingOptions(), true, PathUtil.getParentPath((String)bc.getActualOutputFilePath()), (Consumer<FlashProjectStructureProblem>)errorConsumer);
                    break;
                }
                case iOSDevice: {
                    ValidateFlashConfigurationsPrecompileTask.checkPackagingOptions(module, bc.getSdk(), bc.getIosPackagingOptions(), false, PathUtil.getParentPath((String)bc.getActualOutputFilePath()), (Consumer<FlashProjectStructureProblem>)errorConsumer);
                }
            }
        }
        ValidateFlashConfigurationsPrecompileTask.checkSimilarOutputFiles(modulesAndBCsToCompile, (Consumer<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>>)((Consumer)trinity -> problems.add((Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>)trinity)));
        return problems;
    }

    private static boolean checkSimilarOutputFiles(Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCsToCompile, Consumer<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>> errorConsumer) {
        THashMap outputPathToModuleAndBC = new THashMap();
        for (Pair<Module, FlexBuildConfiguration> moduleAndBC : modulesAndBCsToCompile) {
            FlexBuildConfiguration bc = (FlexBuildConfiguration)moduleAndBC.second;
            String outputFilePath = bc.getActualOutputFilePath();
            ValidateFlashConfigurationsPrecompileTask.checkOutputPathUnique(outputFilePath, moduleAndBC, (Map<String, Pair<Module, FlexBuildConfiguration>>)outputPathToModuleAndBC, errorConsumer);
        }
        return true;
    }

    private static void checkOutputPathUnique(String outputPath, Pair<Module, FlexBuildConfiguration> moduleAndBC, Map<String, Pair<Module, FlexBuildConfiguration>> outputPathToModuleAndBC, Consumer<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>> errorConsumer) {
        String caseAwarePath = SystemInfo.isFileSystemCaseSensitive ? outputPath : outputPath.toLowerCase();
        Pair<Module, FlexBuildConfiguration> existing = outputPathToModuleAndBC.put(caseAwarePath, moduleAndBC);
        if (existing != null) {
            String message = FlexBundle.message("same.output.files", ((FlexBuildConfiguration)existing.second).getName(), ((Module)existing.first).getName(), FileUtil.toSystemDependentName((String)outputPath));
            errorConsumer.consume((Object)Trinity.create((Object)moduleAndBC.first, (Object)moduleAndBC.second, (Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, ((FlexBuildConfiguration)moduleAndBC.second).getName(), message, FlexBCConfigurable.Location.OutputFileName)));
        }
    }

    public static void checkConfiguration(Module module, FlexBuildConfiguration bc, boolean checkPackaging, Consumer<FlashProjectStructureProblem> errorConsumer) {
        BuildConfigurationNature nature;
        Sdk sdk = bc.getSdk();
        if (sdk == null) {
            errorConsumer.consume((Object)FlashProjectStructureProblem.createDependenciesProblem(ProjectStructureProblemType.Severity.ERROR, FlexBundle.message("sdk.not.set", new Object[0]), DependenciesConfigurable.Location.SDK));
        }
        if (sdk != null) {
            String version = sdk.getVersionString();
            if (FlexSdkUtils.isAirSdkWithoutFlex(sdk)) {
                version = version.substring("AIR SDK ".length());
            }
            if (StringUtil.compareVersionNumbers((String)version, (String)"0") < 0 || StringUtil.compareVersionNumbers((String)version, (String)"100") > 0) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createDependenciesProblem(ProjectStructureProblemType.Severity.ERROR, FlexBundle.message("sdk.version.unknown", sdk.getName()), DependenciesConfigurable.Location.SDK));
            }
            if (FlexSdkUtils.isAirSdkWithoutFlex(sdk) && !bc.isPureAs()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("air.sdk.requires.pure.as", sdk.getName()), FlexBCConfigurable.Location.Nature));
            }
        }
        InfoFromConfigFile info = InfoFromConfigFile.DEFAULT;
        String additionalConfigFilePath = bc.getCompilerOptions().getAdditionalConfigFilePath();
        if (!additionalConfigFilePath.isEmpty()) {
            VirtualFile additionalConfigFile = LocalFileSystem.getInstance().findFileByPath(additionalConfigFilePath);
            if (additionalConfigFile == null || additionalConfigFile.isDirectory()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createCompilerOptionsProblem(ProjectStructureProblemType.Severity.ERROR, FlexBundle.message("additional.config.file.not.found", FileUtil.toSystemDependentName((String)additionalConfigFilePath)), CompilerOptionsConfigurable.Location.AdditionalConfigFile));
            }
            if (!bc.isTempBCForCompilation()) {
                info = FlexCompilerConfigFileUtil.getInfoFromConfigFile(additionalConfigFilePath);
            }
        }
        if (!(nature = bc.getNature()).isLib() && info.getMainClass(module) == null && !bc.isTempBCForCompilation()) {
            if (bc.getMainClass().isEmpty()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("main.class.not.set", new Object[0]), FlexBCConfigurable.Location.MainClass));
            } else if (FlexUtils.getPathToMainClassFile(bc.getMainClass(), module).isEmpty()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("main.class.not.found", bc.getMainClass()), FlexBCConfigurable.Location.MainClass));
            }
        }
        if (info.getOutputFileName() == null && info.getOutputFolderPath() == null) {
            if (FileUtil.getNameWithoutExtension((String)bc.getOutputFileName()).isEmpty()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("output.file.name.not.set", new Object[0]), FlexBCConfigurable.Location.OutputFileName));
            } else {
                if (!nature.isLib() && !bc.getOutputFileName().toLowerCase().endsWith(".swf")) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("output.file.wrong.extension", "swf"), FlexBCConfigurable.Location.OutputFileName));
                }
                if (nature.isLib() && !bc.getOutputFileName().toLowerCase().endsWith(".swc")) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("output.file.wrong.extension", "swc"), FlexBCConfigurable.Location.OutputFileName));
                }
            }
            if (bc.getOutputFolder().isEmpty()) {
                if (BCUtils.isFlexUnitBC(bc)) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.FlexUnitOutputFolderProblem.INSTANCE);
                } else {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("output.folder.not.set", new Object[0]), FlexBCConfigurable.Location.OutputFolder));
                }
            } else if (!FileUtil.isAbsolute((String)bc.getOutputFolder())) {
                if (BCUtils.isFlexUnitBC(bc)) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.FlexUnitOutputFolderProblem.INSTANCE);
                } else {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("output.folder.not.absolute", FileUtil.toSystemDependentName((String)bc.getOutputFolder())), FlexBCConfigurable.Location.OutputFolder));
                }
            }
        }
        if (nature.isWebPlatform() && nature.isApp() && bc.isUseHtmlWrapper()) {
            if (bc.getWrapperTemplatePath().isEmpty()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("html.template.folder.not.set", new Object[0]), FlexBCConfigurable.Location.HtmlTemplatePath));
            } else {
                VirtualFile templateDir = LocalFileSystem.getInstance().findFileByPath(bc.getWrapperTemplatePath());
                if (templateDir == null || !templateDir.isDirectory()) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("html.template.folder.not.found", FileUtil.toSystemDependentName((String)bc.getWrapperTemplatePath())), FlexBCConfigurable.Location.HtmlTemplatePath));
                } else {
                    VirtualFile templateFile = templateDir.findChild("index.template.html");
                    if (templateFile == null) {
                        errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexCommonBundle.message((String)"no.index.template.html.file", (Object[])new Object[]{templateDir.getPresentableUrl()}), FlexBCConfigurable.Location.HtmlTemplatePath));
                    } else {
                        String templateFolderPath = templateDir.getPath();
                        boolean ok = true;
                        for (String url : ModuleRootManager.getInstance((Module)module).getContentRootUrls()) {
                            if (!ok) continue;
                            ok = ValidateFlashConfigurationsPrecompileTask.checkWrapperFolderClash(bc, templateFolderPath, VfsUtilCore.urlToPath((String)url), "module content root", errorConsumer);
                        }
                        for (String url : ModuleRootManager.getInstance((Module)module).getSourceRootUrls()) {
                            if (!ok) continue;
                            ok = ValidateFlashConfigurationsPrecompileTask.checkWrapperFolderClash(bc, templateFolderPath, VfsUtilCore.urlToPath((String)url), "source folder", errorConsumer);
                        }
                        String outputFolderPath = StringUtil.notNullize((String)info.getOutputFolderPath(), (String)bc.getOutputFolder());
                        if (ok && !outputFolderPath.isEmpty()) {
                            ok = ValidateFlashConfigurationsPrecompileTask.checkWrapperFolderClash(bc, templateFolderPath, outputFolderPath, "output folder", errorConsumer);
                        }
                    }
                }
            }
        }
        if (BCUtils.canHaveRLMsAndRuntimeStylesheets(bc)) {
            for (FlexBuildConfiguration.RLMInfo rlm : bc.getRLMs()) {
                if (rlm.MAIN_CLASS.isEmpty()) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("rlm.main.class.not.set", new Object[0]), FlexBCConfigurable.Location.RLMs));
                } else if (FlexUtils.getPathToMainClassFile(rlm.MAIN_CLASS, module).isEmpty()) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("rlm.main.class.not.found", rlm.MAIN_CLASS), FlexBCConfigurable.Location.RLMs));
                }
                if (bc.getMainClass().equals(rlm.MAIN_CLASS)) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("rlm.main.class.equal.to.bc.main.class", rlm.MAIN_CLASS), FlexBCConfigurable.Location.RLMs));
                }
                if (bc.getOutputFileName().equals(rlm.OUTPUT_FILE)) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("rlm.output.equal.to.bc.output", rlm.OUTPUT_FILE), FlexBCConfigurable.Location.RLMs));
                }
                if (rlm.OUTPUT_FILE.isEmpty()) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("rlm.output.file.name.not.specified", new Object[0]), FlexBCConfigurable.Location.RLMs));
                    continue;
                }
                if (rlm.OUTPUT_FILE.toLowerCase().endsWith(".swf")) continue;
                errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("rlm.output.file.must.have.swf.extension", new Object[0]), FlexBCConfigurable.Location.RLMs));
            }
            for (String cssPath : bc.getCssFilesToCompile()) {
                if (!cssPath.toLowerCase().endsWith(".css")) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("not.a.css.runtime.stylesheet", FileUtil.toSystemDependentName((String)cssPath)), FlexBCConfigurable.Location.RuntimeStyleSheets));
                    continue;
                }
                if (LocalFileSystem.getInstance().findFileByPath(cssPath) != null) continue;
                errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("css.not.found", FileUtil.toSystemDependentName((String)cssPath)), FlexBCConfigurable.Location.RuntimeStyleSheets));
            }
        }
        if (nature.isLib()) {
            for (String path : bc.getCompilerOptions().getFilesToIncludeInSWC()) {
                if (LocalFileSystem.getInstance().findFileByPath(path) != null) continue;
                errorConsumer.consume((Object)FlashProjectStructureProblem.createCompilerOptionsProblem(ProjectStructureProblemType.Severity.ERROR, FlexBundle.message("file.to.include.in.swc.not.found", FileUtil.toSystemDependentName((String)path)), CompilerOptionsConfigurable.Location.FilesToIncludeInSwc));
            }
        }
        if (checkPackaging) {
            ValidateFlashConfigurationsPrecompileTask.checkPackagingOptions(module, bc, errorConsumer);
        }
    }

    private static boolean checkWrapperFolderClash(FlexBuildConfiguration bc, String templateFolderPath, String otherFolderPath, String otherFolderDescription, Consumer<FlashProjectStructureProblem> errorConsumer) {
        if (FileUtil.isAncestor((String)templateFolderPath, (String)otherFolderPath, (boolean)false)) {
            errorConsumer.consume((Object)FlashProjectStructureProblem.createGeneralOptionProblem(ProjectStructureProblemType.Severity.ERROR, bc.getName(), FlexBundle.message("html.wrapper.folder.clash", otherFolderDescription, FileUtil.toSystemDependentName((String)templateFolderPath)), FlexBCConfigurable.Location.HtmlTemplatePath));
            return false;
        }
        return true;
    }

    public static void checkPackagingOptions(Module module, FlexBuildConfiguration bc, Consumer<FlashProjectStructureProblem> errorConsumer) {
        if (bc.getOutputType() != OutputType.Application) {
            return;
        }
        if (bc.getTargetPlatform() == TargetPlatform.Desktop) {
            ValidateFlashConfigurationsPrecompileTask.checkPackagingOptions(module, bc.getSdk(), bc.getAirDesktopPackagingOptions(), false, PathUtil.getParentPath((String)bc.getActualOutputFilePath()), errorConsumer);
        } else if (bc.getTargetPlatform() == TargetPlatform.Mobile) {
            if (bc.getAndroidPackagingOptions().isEnabled()) {
                ValidateFlashConfigurationsPrecompileTask.checkPackagingOptions(module, bc.getSdk(), bc.getAndroidPackagingOptions(), false, PathUtil.getParentPath((String)bc.getActualOutputFilePath()), errorConsumer);
            }
            if (bc.getIosPackagingOptions().isEnabled()) {
                ValidateFlashConfigurationsPrecompileTask.checkPackagingOptions(module, bc.getSdk(), bc.getIosPackagingOptions(), false, PathUtil.getParentPath((String)bc.getActualOutputFilePath()), errorConsumer);
            }
        }
    }

    private static void checkPackagingOptions(Module module, @Nullable Sdk sdk, AirPackagingOptions packagingOptions, boolean isForIosSimulator, String outputFolderPath, Consumer<FlashProjectStructureProblem> errorConsumer) {
        boolean tempCertificate;
        String path;
        String device;
        String string = packagingOptions instanceof AndroidPackagingOptions ? "Android" : (device = packagingOptions instanceof IosPackagingOptions ? "iOS" : "");
        if (!packagingOptions.isUseGeneratedDescriptor()) {
            if (packagingOptions.getCustomDescriptorPath().isEmpty()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("custom.descriptor.not.set", device), AirPackagingConfigurableBase.Location.CustomDescriptor));
            } else {
                VirtualFile descriptorFile = LocalFileSystem.getInstance().findFileByPath(packagingOptions.getCustomDescriptorPath());
                if (descriptorFile == null || descriptorFile.isDirectory()) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("custom.descriptor.not.found", device, FileUtil.toSystemDependentName((String)packagingOptions.getCustomDescriptorPath())), AirPackagingConfigurableBase.Location.CustomDescriptor));
                } else if (sdk != null && sdk.getSdkType() != FlexmojosSdkType.getInstance()) {
                    FlashRunnerParameters.checkAirVersionIfCustomDescriptor(module, sdk, packagingOptions, errorConsumer, false, "does not matter");
                }
            }
        }
        if (packagingOptions.getPackageFileName().isEmpty()) {
            errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("package.file.name.not.set", device), AirPackagingConfigurableBase.Location.PackageFileName));
        }
        for (AirPackagingOptions.FilePathAndPathInPackage entry : packagingOptions.getFilesToPackage()) {
            String fullPath = entry.FILE_PATH;
            String relPathInPackage = entry.PATH_IN_PACKAGE;
            relPathInPackage = StringUtil.trimStart((String)relPathInPackage, (String)"/");
            if (fullPath.isEmpty()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("packaging.options.empty.file.name", device), AirPackagingConfigurableBase.Location.FilesToPackage));
                continue;
            }
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fullPath);
            if (file == null) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("packaging.options.file.not.found", device, FileUtil.toSystemDependentName((String)fullPath)), AirPackagingConfigurableBase.Location.FilesToPackage));
            }
            if (relPathInPackage.isEmpty()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("packaging.options.empty.relative.path", device), AirPackagingConfigurableBase.Location.FilesToPackage));
            }
            if (file == null || !file.isDirectory()) continue;
            if (FileUtil.isAncestor((String)file.getPath(), (String)outputFolderPath, (boolean)false)) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("folder.to.package.includes.output", device, file.getPresentableUrl()), AirPackagingConfigurableBase.Location.FilesToPackage));
                continue;
            }
            if (relPathInPackage.isEmpty() || ".".equals(relPathInPackage) || fullPath.endsWith("/" + relPathInPackage)) continue;
            errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("packaging.options.relative.path.not.matches", device, FileUtil.toSystemDependentName((String)relPathInPackage)), AirPackagingConfigurableBase.Location.FilesToPackage));
        }
        if (packagingOptions instanceof IosPackagingOptions && !(path = packagingOptions.getSigningOptions().getIOSSdkPath()).isEmpty() && !new File(path).isDirectory()) {
            errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("packaging.options.bad.ios.sdk.path", device, FileUtil.toSystemDependentName((String)path)), AirPackagingConfigurableBase.Location.IosSdkPath));
        }
        AirSigningOptions signingOptions = packagingOptions.getSigningOptions();
        if (packagingOptions instanceof IosPackagingOptions && !isForIosSimulator) {
            String provisioningProfilePath = signingOptions.getProvisioningProfilePath();
            if (provisioningProfilePath.isEmpty()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("ios.provisioning.profile.not.set", new Object[0]), AirPackagingConfigurableBase.Location.ProvisioningProfile));
            } else {
                VirtualFile provisioningProfile = LocalFileSystem.getInstance().findFileByPath(provisioningProfilePath);
                if (provisioningProfile == null || provisioningProfile.isDirectory()) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("ios.provisioning.profile.not.found", FileUtil.toSystemDependentName((String)provisioningProfilePath)), AirPackagingConfigurableBase.Location.ProvisioningProfile));
                }
            }
        }
        boolean bl = tempCertificate = packagingOptions instanceof IosPackagingOptions ? isForIosSimulator : signingOptions.isUseTempCertificate();
        if (!tempCertificate) {
            String keystorePath = signingOptions.getKeystorePath();
            if (keystorePath.isEmpty()) {
                errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("keystore.not.set", device), AirPackagingConfigurableBase.Location.Keystore));
            } else {
                VirtualFile keystore = LocalFileSystem.getInstance().findFileByPath(keystorePath);
                if (keystore == null || keystore.isDirectory()) {
                    errorConsumer.consume((Object)FlashProjectStructureProblem.createPackagingOptionsProblem(ProjectStructureProblemType.Severity.ERROR, packagingOptions, FlexBundle.message("keystore.not.found", device, FileUtil.toSystemDependentName((String)keystorePath)), AirPackagingConfigurableBase.Location.Keystore));
                }
            }
        }
    }

    public boolean execute(CompileContext context) {
        FlexCompilerHandler.getInstance(context.getProject()).getBuiltInFlexCompilerHandler().stopCompilerProcess();
        return this.validateConfiguration(context);
    }

    private boolean validateConfiguration(final CompileContext context) {
        try {
            final Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCsToCompile = FlexBuildTargetScopeProvider.getModulesAndBCsToCompile(context.getCompileScope());
            this.suggestParallelCompilationIfNeeded(context.getProject(), modulesAndBCsToCompile);
            Collection problems = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>>>(){

                public Collection<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>> compute() {
                    return ValidateFlashConfigurationsPrecompileTask.getProblems(context.getCompileScope(), modulesAndBCsToCompile);
                }
            });
            if (!problems.isEmpty()) {
                boolean hasErrors = false;
                for (Trinity problem : problems) {
                    if (((FlashProjectStructureProblem)problem.getThird()).severity != ProjectStructureProblemType.Severity.ERROR) continue;
                    hasErrors = true;
                    break;
                }
                if (hasErrors) {
                    context.addMessage(CompilerMessageCategory.ERROR, "Flash build configurations contain errors. Double-click error message below to navigate to the corresponding field in the Project Structure dialog", null, -1, -1);
                }
                ValidateFlashConfigurationsPrecompileTask.reportProblems(context, problems);
                return !hasErrors;
            }
        }
        catch (ConfigurationException e) {
            context.addMessage(CompilerMessageCategory.ERROR, FlexBundle.message("project.setup.problem", e.getMessage()), null, -1, -1);
            return false;
        }
        return true;
    }

    private void suggestParallelCompilationIfNeeded(final Project project, Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCsToCompile) {
        if (this.myParallelCompilationSuggested) {
            return;
        }
        if (CompilerWorkspaceConfiguration.getInstance((Project)project).PARALLEL_COMPILATION) {
            return;
        }
        if (modulesAndBCsToCompile.size() < 2) {
            return;
        }
        if (!ValidateFlashConfigurationsPrecompileTask.independentBCsExist(modulesAndBCsToCompile)) {
            return;
        }
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/lang/javascript/flex/build/ValidateFlashConfigurationsPrecompileTask$2", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/build/ValidateFlashConfigurationsPrecompileTask$2", "hyperlinkUpdate"));
                }
                notification.expire();
                if ("enable".equals(event.getDescription())) {
                    CompilerWorkspaceConfiguration.getInstance((Project)project).PARALLEL_COMPILATION = true;
                    NotificationListener listener1 = new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/lang/javascript/flex/build/ValidateFlashConfigurationsPrecompileTask$2$1", "hyperlinkUpdate"));
                            }
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/flex/build/ValidateFlashConfigurationsPrecompileTask$2$1", "hyperlinkUpdate"));
                            }
                            notification.expire();
                            ShowSettingsUtil.getInstance().showSettingsDialog(project, CompilerBundle.message((String)"compiler.configurable.display.name", (Object[])new Object[0]));
                        }
                    };
                    new Notification(ValidateFlashConfigurationsPrecompileTask.FLASH_COMPILER_GROUP_ID, FlexBundle.message("parallel.compilation.enabled", new Object[0]), FlexBundle.message("see.settings.compiler", new Object[0]), NotificationType.INFORMATION, listener1).notify(project);
                } else if ("open".equals(event.getDescription())) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, CompilerBundle.message((String)"compiler.configurable.display.name", (Object[])new Object[0]));
                }
            }
        };
        new Notification(FLASH_COMPILER_GROUP_ID, FlexBundle.message("parallel.compilation.hint.title", new Object[0]), FlexBundle.message("parallel.compilation.hint", new Object[0]), NotificationType.INFORMATION, listener).notify(project);
        this.myParallelCompilationSuggested = true;
    }

    private static boolean independentBCsExist(Collection<Pair<Module, FlexBuildConfiguration>> modulesAndBCsToCompile) {
        THashSet bcs = new THashSet();
        for (Pair<Module, FlexBuildConfiguration> moduleAndBC : modulesAndBCsToCompile) {
            bcs.add(moduleAndBC.second);
        }
        int independentBCsCount = 0;
        block1: for (FlexBuildConfiguration bc : bcs) {
            for (DependencyEntry entry : bc.getDependencies().getEntries()) {
                FlexBuildConfiguration dependencyBC;
                if (entry instanceof BuildConfigurationEntry && (dependencyBC = ((BuildConfigurationEntry)entry).findBuildConfiguration()) != null && bcs.contains(dependencyBC)) continue block1;
            }
            if (++independentBCsCount <= 1) continue;
            return true;
        }
        return false;
    }

    private static void reportProblems(CompileContext context, Collection<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>> problems) {
        for (Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem> trinity : problems) {
            Module module = (Module)trinity.getFirst();
            FlexBuildConfiguration bc = (FlexBuildConfiguration)trinity.getSecond();
            FlashProjectStructureProblem problem = (FlashProjectStructureProblem)trinity.getThird();
            String message = problem instanceof FlashProjectStructureProblem.FlexUnitOutputFolderProblem ? problem.errorMessage : FlexBundle.message("bc.0.module.1.problem.2", bc.getName(), module.getName(), problem.errorMessage);
            CompilerMessageCategory severity = problem.severity == ProjectStructureProblemType.Severity.ERROR ? CompilerMessageCategory.ERROR : CompilerMessageCategory.WARNING;
            context.addMessage(severity, message, null, -1, -1, (Navigatable)new BCProblemNavigatable(module, bc.getName(), problem));
        }
    }

    private static class BCProblemNavigatable
    implements Navigatable {
        @NotNull
        private final Module myModule;
        @NotNull
        private final String myBCNme;
        @NotNull
        private final FlashProjectStructureProblem myProblem;

        private BCProblemNavigatable(@NotNull Module module, @NotNull String bcName, @NotNull FlashProjectStructureProblem problem) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/build/ValidateFlashConfigurationsPrecompileTask$BCProblemNavigatable", "<init>"));
            }
            if (bcName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bcName", "com/intellij/lang/javascript/flex/build/ValidateFlashConfigurationsPrecompileTask$BCProblemNavigatable", "<init>"));
            }
            if (problem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problem", "com/intellij/lang/javascript/flex/build/ValidateFlashConfigurationsPrecompileTask$BCProblemNavigatable", "<init>"));
            }
            this.myModule = module;
            this.myBCNme = bcName;
            this.myProblem = problem;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public boolean canNavigate() {
            return !this.myModule.isDisposed() && FlexBuildConfigurationManager.getInstance(this.myModule).findConfigurationByName(this.myBCNme) != null;
        }

        public void navigate(boolean requestFocus) {
            ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance((Project)this.myModule.getProject());
            ShowSettingsUtil.getInstance().editConfigurable(this.myModule.getProject(), (Configurable)configurable, () -> {
                Place place = this.myProblem instanceof FlashProjectStructureProblem.FlexUnitOutputFolderProblem ? new Place().putPath("category", (Object)configurable.getProjectConfig()) : FlexBuildConfigurationsExtension.getInstance().getConfigurator().getPlaceFor(this.myModule, this.myBCNme).putPath("tabName", (Object)this.myProblem.tabName).putPath("FlashBuildConfiguration.locationOnTab", this.myProblem.locationOnTab);
                configurable.navigateTo(place, true);
            });
        }
    }
}

