/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CompositeDebuggerCommand;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.FlexStackFrame;
import com.intellij.lang.javascript.flex.debug.NodeClassInfo;
import com.intellij.lang.javascript.flex.debug.XmlObjectEvaluator;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebuggerSupportUtils;

class FlexValue
extends XValue {
    private FlexStackFrame myFlexStackFrame;
    private final FlexDebugProcess myDebugProcess;
    @Nullable
    private final XSourcePosition mySourcePosition;
    private final String myName;
    private final String myExpression;
    private final String myResult;
    @Nullable
    private final String myParentResult;
    private final ValueType myValueType;
    private Icon myPreferredIcon;
    private static final String OBJECT_MARKER = "Object ";
    private static final String XML_TYPE = "XML";
    private static final String XMLLIST_TYPE = "XMLList";
    static final String TEXT_MARKER = " text ";
    static final String ELEMENT_MARKER = " element ";
    private static final String ESCAPE_START = "IDEA-ESCAPE-START";
    private static final String ESCAPE_END = "IDEA-ESCAPE-END";
    private static final String VECTOR_PREFIX = "__AS3__.vec::";
    private static final String VECTOR = "Vector";
    private static final String GENERIC_VECTOR_PREFIX = "Vector.<";
    private static final String[] COLLECTIONS_WITH_DIRECT_CONTENT = new String[]{"Array", "Vector", "mx.collections.ListCollectionView", "mx.collections.ArrayCollection", "mx.collections.XMLListCollection"};
    private static final String[] COLLECTION_CLASSES = ArrayUtil.mergeArrays((String[])COLLECTIONS_WITH_DIRECT_CONTENT, (String[])new String[]{"mx.collections.ArrayList", "mx.collections.AsyncListView"});
    private static final Comparator<XValue> ourArrayElementsComparator = (o1, o2) -> {
        if (o1 instanceof FlexValue && o2 instanceof FlexValue) {
            String name = ((FlexValue)o1).myName;
            String name2 = ((FlexValue)o2).myName;
            if (!StringUtil.isEmpty((String)name) && !StringUtil.isEmpty((String)name2) && Character.isDigit(name.charAt(0)) && Character.isDigit(name2.charAt(0))) {
                try {
                    return Integer.parseInt(name) - Integer.parseInt(name2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (name == null) {
                return name2 == null ? 0 : -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name.compareToIgnoreCase(name2);
        }
        return 1;
    };

    FlexValue(FlexStackFrame flexStackFrame, FlexDebugProcess flexDebugProcess, @Nullable XSourcePosition sourcePosition, String name, String expression, String result, @Nullable String parentResult, @NotNull ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "com/intellij/lang/javascript/flex/debug/FlexValue", "<init>"));
        }
        this.myFlexStackFrame = flexStackFrame;
        this.myDebugProcess = flexDebugProcess;
        this.mySourcePosition = sourcePosition;
        this.myName = name;
        this.myExpression = expression;
        this.myResult = FlexValue.unescape(result, flexDebugProcess.isFlexSdk_4_12plus_IdeMode());
        this.myParentResult = parentResult;
        this.myValueType = valueType;
    }

    String getResult() {
        return this.myResult;
    }

    public String getEvaluationExpression() {
        return this.myExpression;
    }

    public void setPreferredIcon(Icon preferredIcon) {
        this.myPreferredIcon = preferredIcon;
    }

    private Icon getIcon() {
        return this.myPreferredIcon == null ? this.myValueType.myIcon : this.myPreferredIcon;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        String type;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/flex/debug/FlexValue", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/flex/debug/FlexValue", "computePresentation"));
        }
        boolean isObject = this.myResult.contains(OBJECT_MARKER);
        String val = this.myResult;
        String typeFromFlexValueResult = null;
        String additionalInfo = null;
        if (isObject) {
            Pair<String, String> typeAndAdditionalInfo = FlexValue.getTypeAndAdditionalInfo(this.myResult);
            typeFromFlexValueResult = (String)typeAndAdditionalInfo.first;
            additionalInfo = (String)typeAndAdditionalInfo.second;
            if (typeFromFlexValueResult != null) {
                try {
                    val = "[".concat(FlexValue.getObjectId(this.myResult, this.myResult.indexOf(OBJECT_MARKER), OBJECT_MARKER)).concat("]");
                }
                catch (StringIndexOutOfBoundsException e) {
                    FlexDebugProcess.log(new Exception(this.myResult, e));
                }
            }
        }
        if ((XML_TYPE.equals(typeFromFlexValueResult) || XMLLIST_TYPE.equals(typeFromFlexValueResult)) && this.myExpression.indexOf(61) == -1) {
            if (this.myDebugProcess.isDebuggerFromSdk3()) {
                if (XMLLIST_TYPE.equals(typeFromFlexValueResult)) {
                    FlexValue.setXmlListPresentation(node, val, this);
                    return;
                }
                if (additionalInfo != null) {
                    FlexValue.setXmlPresentation(node, additionalInfo, this);
                    return;
                }
            } else {
                this.scheduleToXmlStringCalculation(node, typeFromFlexValueResult);
            }
        }
        if ((type = FlexValue.getType(typeFromFlexValueResult)) != null && FlexValue.isCollection(type)) {
            if (type.equals(VECTOR) || type.startsWith(GENERIC_VECTOR_PREFIX)) {
                this.scheduleVectorPresentation(node, typeFromFlexValueResult);
            } else {
                this.scheduleCollectionSizePresentation(node, typeFromFlexValueResult, "");
            }
        }
        val = FlexValue.setFullValueEvaluatorIfNeeded(node, val, false);
        node.setPresentation(this.getIcon(), typeFromFlexValueResult, val, isObject);
    }

    private static boolean isCollectionWithDirectContent(String fqn) {
        return fqn != null && ArrayUtil.contains((String)fqn, (String[])COLLECTIONS_WITH_DIRECT_CONTENT);
    }

    private static boolean isCollection(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/flex/debug/FlexValue", "isCollection"));
        }
        return FlexValue.isGenericVector(type) || ArrayUtil.contains((String)type, (String[])COLLECTION_CLASSES);
    }

    private void scheduleVectorPresentation(final XValueNode node, final String type) {
        FlexStackFrame flexStackFrame = this.myFlexStackFrame;
        ((Object)((Object)flexStackFrame)).getClass();
        FlexStackFrame.EvaluateCommand command = flexStackFrame.new FlexStackFrame.EvaluateCommand(this.myExpression + ".fixed", new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/flex/debug/FlexValue$1", "evaluated"));
                }
                if (!node.isObsolete()) {
                    String resultText = ((FlexValue)result).myResult;
                    String prefix = "true".equals(resultText) || "false".equals(resultText) ? "fixed = " + resultText : "";
                    node.setPresentation(FlexValue.this.getIcon(), type, prefix, true);
                    FlexValue.this.scheduleCollectionSizePresentation(node, type, prefix);
                }
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/lang/javascript/flex/debug/FlexValue$1", "errorOccurred"));
                }
            }
        });
        this.myDebugProcess.addPendingCommand(new CompositeDebuggerCommand((Obsolescent)node, command), 100);
    }

    private void scheduleCollectionSizePresentation(final XValueNode node, final String type, final String prefix) {
        FlexStackFrame flexStackFrame = this.myFlexStackFrame;
        ((Object)((Object)flexStackFrame)).getClass();
        FlexStackFrame.EvaluateCommand command = flexStackFrame.new FlexStackFrame.EvaluateCommand(this.myExpression + ".length", new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                String resultText;
                int index;
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/flex/debug/FlexValue$2", "evaluated"));
                }
                if (!node.isObsolete() && (index = (resultText = ((FlexValue)result).myResult).indexOf(" (0x")) != -1) {
                    String value = (prefix.isEmpty() ? "" : prefix + ", ") + "size = " + resultText.substring(0, index);
                    node.setPresentation(FlexValue.this.getIcon(), type, value, true);
                }
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/lang/javascript/flex/debug/FlexValue$2", "errorOccurred"));
                }
            }
        });
        this.myDebugProcess.addPendingCommand(new CompositeDebuggerCommand((Obsolescent)node, command), 100);
    }

    private static void setXmlListPresentation(XValueNode node, String value, final FlexValue flexValue) {
        node.setFullValueEvaluator(new XFullValueEvaluator(){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/flex/debug/FlexValue$3", "startEvaluation"));
                }
                new XmlObjectEvaluator(flexValue, callback).startEvaluation();
            }
        });
        node.setPresentation(flexValue.getIcon(), XMLLIST_TYPE, value, true);
    }

    private static void setXmlPresentation(XValueNode node, String additionalInfo, final FlexValue flexValue) {
        boolean isText;
        boolean isElement = additionalInfo.startsWith(" element <") && additionalInfo.endsWith(">");
        boolean isEmptyElement = isElement && additionalInfo.endsWith("/>");
        boolean bl = isText = !isElement && additionalInfo.startsWith(TEXT_MARKER);
        if (isText || isElement) {
            String textToShow;
            if (isText) {
                textToShow = additionalInfo.substring(TEXT_MARKER.length());
            } else if (isEmptyElement) {
                textToShow = additionalInfo.substring(ELEMENT_MARKER.length());
            } else {
                String startTag;
                int spaceIndex = (startTag = additionalInfo.substring(ELEMENT_MARKER.length())).indexOf(" ");
                String tagName = startTag.substring(1, spaceIndex > 0 ? spaceIndex : startTag.length() - 1);
                String textToShow2 = startTag + "...</" + tagName + "> ";
                if (textToShow2.length() > 1000) {
                    textToShow2 = textToShow2.substring(0, 1000);
                }
                node.setFullValueEvaluator(new XFullValueEvaluator(){

                    public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                        if (callback == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/flex/debug/FlexValue$4", "startEvaluation"));
                        }
                        new XmlObjectEvaluator(flexValue, callback).startEvaluation();
                    }
                });
                node.setPresentation(flexValue.getIcon(), XML_TYPE, textToShow2, true);
                return;
            }
            textToShow = FlexValue.setFullValueEvaluatorIfNeeded(node, textToShow, true);
            node.setPresentation(flexValue.getIcon(), XML_TYPE, textToShow, true);
            return;
        }
        node.setPresentation(flexValue.getIcon(), XML_TYPE, FlexValue.setFullValueEvaluatorIfNeeded(node, additionalInfo, true), true);
    }

    private void scheduleToXmlStringCalculation(final XValueNode node, final String type) {
        FlexStackFrame flexStackFrame = this.myFlexStackFrame;
        ((Object)((Object)flexStackFrame)).getClass();
        FlexStackFrame.EvaluateCommand command = flexStackFrame.new FlexStackFrame.EvaluateCommand(this.myExpression + ".toXMLString()", new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/flex/debug/FlexValue$5", "evaluated"));
                }
                this.setResult(((FlexValue)result).myResult, node, type, true);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/lang/javascript/flex/debug/FlexValue$5", "errorOccurred"));
                }
                this.setResult(errorMessage, node, type, true);
            }

            private void setResult(String value, XValueNode node2, String type2, boolean hasChildren) {
                if (!node2.isObsolete()) {
                    value = FlexValue.setFullValueEvaluatorIfNeeded(node2, value, true);
                    node2.setPresentation(FlexValue.this.getIcon(), type2, value, hasChildren);
                }
            }
        });
        this.myDebugProcess.addPendingCommand(new CompositeDebuggerCommand((Obsolescent)node, command), 700);
    }

    private static String setFullValueEvaluatorIfNeeded(XValueNode node, String value, final boolean isXml) {
        String fullValue = value;
        int lfIndex = fullValue.indexOf(10);
        int crIndex = fullValue.indexOf(13);
        if (fullValue.length() > 1000 || lfIndex > -1 && lfIndex < fullValue.length() - 1 || crIndex > -1 && crIndex < fullValue.length() - 1) {
            boolean doubleQuoted;
            boolean quoted = fullValue.charAt(0) == '\'' && fullValue.charAt(fullValue.length() - 1) == '\'';
            boolean bl = doubleQuoted = fullValue.charAt(0) == '\"' && fullValue.charAt(fullValue.length() - 1) == '\"';
            if (value.length() > 1000) {
                String ending = doubleQuoted ? "\" " : (quoted ? "' " : " ");
                value = value.substring(0, 1000).concat(ending);
            }
            value = value.trim();
            final String unquoted = quoted || doubleQuoted ? fullValue.substring(1, fullValue.length() - 1) : fullValue;
            node.setFullValueEvaluator(new XFullValueEvaluator(){

                public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                    if (callback == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/flex/debug/FlexValue$6", "startEvaluation"));
                    }
                    callback.evaluated(StringUtil.convertLineSeparators((String)unquoted), isXml ? XmlObjectEvaluator.MONOSPACED_FONT : null);
                }
            });
        }
        return value;
    }

    public XValueModifier getModifier() {
        return new XValueModifier(){

            public void setValue(@NotNull String _expression, final @NotNull XValueModifier.XModificationCallback callback) {
                if (_expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_expression", "com/intellij/lang/javascript/flex/debug/FlexValue$7", "setValue"));
                }
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/flex/debug/FlexValue$7", "setValue"));
                }
                FlexStackFrame flexStackFrame = FlexValue.this.myFlexStackFrame;
                ((Object)((Object)flexStackFrame)).getClass();
                FlexStackFrame.EvaluateCommand command = new FlexStackFrame.EvaluateCommand(flexStackFrame, FlexValue.this.myExpression + "=" + _expression, null){
                    {
                        FlexStackFrame flexStackFrame = x0;
                        ((Object)((Object)flexStackFrame)).getClass();
                        super(_expression, _callback);
                    }

                    @Override
                    protected void dispatchResult(String s) {
                        super.dispatchResult(s);
                        callback.valueModified();
                    }
                };
                FlexValue.this.myDebugProcess.sendCommand(command);
            }
        };
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        String expression;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/flex/debug/FlexValue", "computeChildren"));
        }
        int i = this.myResult.indexOf(OBJECT_MARKER);
        if (i == -1) {
            super.computeChildren(node);
        }
        final String typeFromFlexValueResult = (String)FlexValue.getTypeAndAdditionalInfo((String)this.myResult).first;
        try {
            expression = this.referenceObjectBase(i, OBJECT_MARKER);
        }
        catch (StringIndexOutOfBoundsException e) {
            FlexDebugProcess.log(new Exception(this.myResult, e));
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        FlexStackFrame flexStackFrame = this.myFlexStackFrame;
        ((Object)((Object)flexStackFrame)).getClass();
        FlexStackFrame.EvaluateCommand command = new FlexStackFrame.EvaluateCommand(flexStackFrame, expression, null){
            {
                FlexStackFrame flexStackFrame = x0;
                ((Object)((Object)flexStackFrame)).getClass();
                super(_expression, _callback);
            }

            @Override
            CommandOutputProcessingMode doOnTextAvailable(@NonNls String resultS) {
                StringTokenizer tokenizer = new StringTokenizer(resultS, "\r\n");
                tokenizer.nextToken();
                LinkedHashMap fieldNameToFlexValueMap = new LinkedHashMap(tokenizer.countTokens());
                NodeClassInfo nodeClassInfo = (NodeClassInfo)DumbService.getInstance((Project)FlexValue.this.myDebugProcess.getSession().getProject()).runReadActionInSmartMode(() -> {
                    Project project = FlexValue.this.myDebugProcess.getSession().getProject();
                    JSClass jsClass = FlexValue.this.mySourcePosition == null ? null : FlexValue.findJSClass(project, ModuleUtilCore.findModuleForFile((VirtualFile)FlexValue.this.mySourcePosition.getFile(), (Project)project), typeFromFlexValueResult);
                    return jsClass == null ? null : NodeClassInfo.getNodeClassInfo(jsClass);
                });
                while (tokenizer.hasMoreElements()) {
                    String s = tokenizer.nextToken().trim();
                    if (s.length() == 0) continue;
                    int delimIndex = s.indexOf(" = ");
                    if (delimIndex == -1) {
                        FlexDebugProcess.log("Unrecognized string:" + s);
                        continue;
                    }
                    String fieldName = s.substring(0, delimIndex);
                    String result = s.substring(delimIndex + " = ".length());
                    if (result.startsWith("[Setter ")) continue;
                    String evaluatedPath = FlexValue.this.myExpression;
                    evaluatedPath = fieldName.length() > 0 && Character.isDigit(fieldName.charAt(0)) ? evaluatedPath + "[\"" + fieldName + "\"]" : evaluatedPath + "." + fieldName;
                    ValueType valueType = typeFromFlexValueResult != null && typeFromFlexValueResult.indexOf(47) > -1 ? ValueType.Parameter : ValueType.Field;
                    FlexValue flexValue = new FlexValue(FlexValue.this.myFlexStackFrame, FlexValue.this.myDebugProcess, FlexValue.this.mySourcePosition, fieldName, evaluatedPath, result, FlexValue.this.myResult, valueType);
                    FlexValue.addValueCheckingDuplicates(flexValue, fieldNameToFlexValueMap);
                }
                FlexValue.addChildren(node, fieldNameToFlexValueMap, nodeClassInfo);
                return CommandOutputProcessingMode.DONE;
            }
        };
        this.myDebugProcess.sendCommand(command);
    }

    public boolean canNavigateToTypeSource() {
        boolean isObject = this.myResult.contains(OBJECT_MARKER);
        if (isObject && this.mySourcePosition != null) {
            Pair<String, String> typeAndAdditionalInfo = FlexValue.getTypeAndAdditionalInfo(this.myResult);
            String typeFromFlexValueResult = (String)typeAndAdditionalInfo.first;
            return typeFromFlexValueResult != null;
        }
        return false;
    }

    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/lang/javascript/flex/debug/FlexValue", "computeTypeSourcePosition"));
        }
        if (this.mySourcePosition == null) {
            navigatable.setSourcePosition(null);
            return;
        }
        boolean isObject = this.myResult.contains(OBJECT_MARKER);
        if (isObject) {
            Pair<String, String> typeAndAdditionalInfo = FlexValue.getTypeAndAdditionalInfo(this.myResult);
            String typeFromFlexValueResult = (String)typeAndAdditionalInfo.first;
            if (typeFromFlexValueResult != null) {
                Project project = this.myDebugProcess.getSession().getProject();
                JSClass jsClass = FlexValue.findJSClass(project, ModuleUtilCore.findModuleForFile((VirtualFile)this.mySourcePosition.getFile(), (Project)project), typeFromFlexValueResult);
                navigatable.setSourcePosition(DebuggerSupportUtils.calcSourcePosition((PsiElement)jsClass));
                return;
            }
        }
        navigatable.setSourcePosition(null);
    }

    public boolean canNavigateToSource() {
        return this.mySourcePosition != null && (this.myValueType == ValueType.Variable || this.myValueType == ValueType.Parameter || this.myValueType == ValueType.Field && this.myParentResult != null);
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/lang/javascript/flex/debug/FlexValue", "computeSourcePosition"));
        }
        if (this.mySourcePosition == null) {
            navigatable.setSourcePosition(null);
            return;
        }
        XSourcePosition result = null;
        Project project = this.myDebugProcess.getSession().getProject();
        if (this.myValueType == ValueType.Variable) {
            PsiElement contextElement = XDebuggerUtil.getInstance().findContextElement(this.mySourcePosition.getFile(), this.mySourcePosition.getOffset(), project, true);
            JSFunction jsFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)contextElement, JSFunction.class);
            if (jsFunction != null) {
                final Ref varRef = new Ref();
                jsFunction.accept((PsiElementVisitor)new JSElementVisitor(){

                    public void visitJSElement(JSElement node) {
                        if (varRef.isNull()) {
                            node.acceptChildren((PsiElementVisitor)this);
                        }
                    }

                    public void visitJSVariable(JSVariable node) {
                        if (FlexValue.this.myName.equals(node.getName())) {
                            varRef.set((Object)node);
                        }
                        super.visitJSVariable(node);
                    }
                });
                if (!varRef.isNull()) {
                    result = DebuggerSupportUtils.calcSourcePosition((PsiElement)((PsiElement)varRef.get()));
                }
            }
        } else if (this.myValueType == ValueType.Parameter) {
            JSParameter[] parameters;
            PsiElement contextElement = XDebuggerUtil.getInstance().findContextElement(this.mySourcePosition.getFile(), this.mySourcePosition.getOffset(), project, true);
            JSFunction jsFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)contextElement, JSFunction.class);
            for (JSParameter parameter : parameters = jsFunction == null ? JSParameter.EMPTY_ARRAY : jsFunction.getParameterVariables()) {
                if (!this.myName.equals(parameter.getName())) continue;
                result = DebuggerSupportUtils.calcSourcePosition((PsiElement)parameter);
                break;
            }
        } else if (this.myValueType == ValueType.Field && this.myParentResult != null) {
            String typeFromFlexValueResult = (String)FlexValue.getTypeAndAdditionalInfo((String)this.myParentResult).first;
            JSClass jsClass = FlexValue.findJSClass(project, ModuleUtilCore.findModuleForFile((VirtualFile)this.mySourcePosition.getFile(), (Project)project), typeFromFlexValueResult);
            if (jsClass != null) {
                Ref fieldRef = new Ref();
                fieldRef.set((Object)JSInheritanceUtil.findMember((String)this.myName, (JSClass)jsClass, (JSInheritanceUtil.SearchedMemberType)JSInheritanceUtil.SearchedMemberType.FieldsAndMethods, (JSFunction.FunctionKind)JSFunction.FunctionKind.GETTER, (boolean)true));
                if (fieldRef.isNull() && jsClass instanceof MxmlJSClass) {
                    XmlTag rootTag;
                    PsiFile file = jsClass.getContainingFile();
                    XmlFile xmlFile = file instanceof XmlFile ? (XmlFile)file : null;
                    XmlTag xmlTag = rootTag = xmlFile == null ? null : xmlFile.getRootTag();
                    if (rootTag != null) {
                        NodeClassInfo.processSubtagsRecursively(rootTag, (Processor<XmlTag>)((Processor)tag -> {
                            String id;
                            XmlAttribute idAttr = tag.getAttribute("id");
                            String string = id = idAttr == null ? null : idAttr.getValue();
                            if (id != null && id.equals(this.myName)) {
                                fieldRef.set((Object)idAttr);
                            }
                            return !MxmlJSClass.isTagThatAllowsAnyXmlContent(tag);
                        }));
                    }
                }
                result = DebuggerSupportUtils.calcSourcePosition((PsiElement)((PsiElement)fieldRef.get()));
            }
        }
        navigatable.setSourcePosition(result);
    }

    private static void addValueCheckingDuplicates(FlexValue flexValue, LinkedHashMap<String, FlexValue> fieldNameToFlexValueMap) {
        String name = flexValue.myName;
        FlexValue existingValue = fieldNameToFlexValueMap.get("_" + name);
        if (existingValue != null && existingValue.getResult().equals(flexValue.getResult())) {
            fieldNameToFlexValueMap.remove("_" + name);
        } else if (name.startsWith("_") && name.length() > 1 && (existingValue = fieldNameToFlexValueMap.get(name.substring(1))) != null && existingValue.getResult().equals(flexValue.getResult())) {
            return;
        }
        fieldNameToFlexValueMap.put(name, flexValue);
    }

    private static void addChildren(XCompositeNode node, LinkedHashMap<String, FlexValue> fieldNameToFlexValueMap, @Nullable NodeClassInfo nodeClassInfo) {
        LinkedList<FlexValue> elementsOfCollection = new LinkedList<FlexValue>();
        XValueChildrenList ownStaticFields = new XValueChildrenList();
        XValueChildrenList ownStaticProperties = new XValueChildrenList();
        XValueChildrenList ownFields = new XValueChildrenList();
        XValueChildrenList ownProperties = new XValueChildrenList();
        XValueChildrenList inheritedStaticFields = new XValueChildrenList();
        XValueChildrenList inheritedStaticProperties = new XValueChildrenList();
        XValueChildrenList inheritedFields = new XValueChildrenList();
        XValueChildrenList inheritedProperties = new XValueChildrenList();
        for (Map.Entry<String, FlexValue> entry : fieldNameToFlexValueMap.entrySet()) {
            String name = entry.getKey();
            FlexValue flexValue = entry.getValue();
            if (FlexValue.isInteger(name)) {
                elementsOfCollection.add(flexValue);
                continue;
            }
            if (nodeClassInfo == null) {
                ownFields.add(name, (XValue)flexValue);
                continue;
            }
            if (FlexValue.updateIconAndAddToListIfMatches(name, flexValue, nodeClassInfo.myOwnStaticFields, ownStaticFields) || FlexValue.updateIconAndAddToListIfMatches(name, flexValue, nodeClassInfo.myOwnStaticProperties, ownStaticProperties) || FlexValue.updateIconAndAddToListIfMatches(name, flexValue, nodeClassInfo.myOwnFields, ownFields) || FlexValue.updateIconAndAddToListIfMatches(name, flexValue, nodeClassInfo.myOwnProperties, ownProperties) || FlexValue.updateIconAndAddToListIfMatches(name, flexValue, nodeClassInfo.myInheritedStaticFields, inheritedStaticFields) || FlexValue.updateIconAndAddToListIfMatches(name, flexValue, nodeClassInfo.myInheritedStaticProperties, inheritedStaticProperties) || FlexValue.updateIconAndAddToListIfMatches(name, flexValue, nodeClassInfo.myInheritedFields, inheritedFields) || FlexValue.updateIconAndAddToListIfMatches(name, flexValue, nodeClassInfo.myInheritedProperties, inheritedProperties)) continue;
            (nodeClassInfo.myIsDynamic ? ownFields : inheritedFields).add(name, (XValue)flexValue);
        }
        Collections.sort(elementsOfCollection, ourArrayElementsComparator);
        XValueChildrenList inheritedNodeSingletonList = XValueChildrenList.EMPTY;
        if (inheritedStaticFields.size() + inheritedStaticProperties.size() + inheritedFields.size() + inheritedProperties.size() > 0) {
            if (inheritedStaticFields.size() + inheritedStaticProperties.size() > 0) {
                XValueChildrenList inheritedStatics = FlexValue.createWrappingGroupList("Static members", inheritedStaticFields, inheritedStaticProperties);
                inheritedNodeSingletonList = FlexValue.createWrappingGroupList("Inherited members", inheritedStatics, inheritedFields, inheritedProperties);
            } else {
                inheritedNodeSingletonList = FlexValue.createWrappingGroupList("Inherited members", inheritedStaticFields, inheritedStaticProperties, inheritedFields, inheritedProperties);
            }
        }
        if (nodeClassInfo != null && FlexValue.isCollectionWithDirectContent(nodeClassInfo.myFqn)) {
            XValueChildrenList fieldsAndPropertiesSingletonList = FlexValue.createWrappingGroupList("Fields and properties", inheritedNodeSingletonList, ownStaticFields, ownStaticProperties, ownFields, ownProperties);
            node.addChildren(fieldsAndPropertiesSingletonList, false);
        } else {
            node.addChildren(inheritedNodeSingletonList, false);
            if (ownStaticFields.size() + ownStaticProperties.size() > 0) {
                node.addChildren(FlexValue.createWrappingGroupList("Static members", ownStaticFields, ownStaticProperties), false);
            }
            node.addChildren(ownFields, false);
            node.addChildren(ownProperties, false);
        }
        XValueChildrenList elementsOfCollectionList = new XValueChildrenList();
        for (FlexValue flexValue : elementsOfCollection) {
            elementsOfCollectionList.add(flexValue.myName, (XValue)flexValue);
        }
        node.addChildren(elementsOfCollectionList, true);
    }

    private static XValueChildrenList createWrappingGroupList(String groupName, final XValueChildrenList ... listsToWrap) {
        XValueGroup group = new XValueGroup(groupName){

            public void computeChildren(@NotNull XCompositeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/flex/debug/FlexValue$10", "computeChildren"));
                }
                for (XValueChildrenList list : listsToWrap) {
                    node.addChildren(list, false);
                }
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
        };
        XValueChildrenList inheritedSingleNodeList = new XValueChildrenList();
        inheritedSingleNodeList.addTopGroup(group);
        return inheritedSingleNodeList;
    }

    private static boolean updateIconAndAddToListIfMatches(String name, FlexValue flexValue, Map<String, Icon> nameToIconMap, XValueChildrenList list) {
        Icon icon = nameToIconMap.get(name);
        if (icon != null) {
            flexValue.setPreferredIcon(icon);
            list.add(flexValue.myName, (XValue)flexValue);
            return true;
        }
        return false;
    }

    private static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    private String referenceObjectBase(int i, String marker) {
        return "#" + FlexValue.getObjectId(this.myResult, i, marker) + ".";
    }

    private static String getObjectId(String result, int i, String marker) {
        String s = result.substring(i + marker.length(), result.indexOf(44));
        return FlexStackFrame.validObjectId(s);
    }

    private static Pair<String, String> getTypeAndAdditionalInfo(@Nullable String fdbText) {
        if (fdbText == null) {
            return Pair.create(null, null);
        }
        String type = null;
        String additionalInfo = null;
        int classIndex = fdbText.indexOf(", class='");
        int lastQuoteIndex = fdbText.lastIndexOf("'");
        if (classIndex != -1 && lastQuoteIndex > classIndex) {
            int typeStart = classIndex + ", class='".length();
            String inQuotes = fdbText.substring(typeStart, lastQuoteIndex);
            int atIndex = inQuotes.indexOf("@");
            if (atIndex > 0) {
                type = inQuotes.substring(0, atIndex);
                int spaceIndex = inQuotes.indexOf(" ", atIndex);
                if (spaceIndex != -1) {
                    additionalInfo = inQuotes.substring(spaceIndex, inQuotes.length());
                }
            } else {
                type = inQuotes;
            }
        }
        if ("[]".equals(type)) {
            type = "Array";
        }
        if (type != null) {
            type = StringUtil.replace((String)type, (String)VECTOR_PREFIX, (String)"");
        }
        return Pair.create((Object)type, additionalInfo);
    }

    @Nullable
    private static String getType(String typeFromFlexValueResult) {
        if (typeFromFlexValueResult != null && !typeFromFlexValueResult.contains("/")) {
            return typeFromFlexValueResult.replace("::", ".");
        }
        return null;
    }

    private static boolean isGenericVector(String type) {
        return type.startsWith(GENERIC_VECTOR_PREFIX);
    }

    @Nullable
    private static JSClass findJSClass(Project project, @Nullable Module module, String typeFromFlexValueResult) {
        String type = FlexValue.getType(typeFromFlexValueResult);
        if (type != null) {
            GlobalSearchScope scope;
            JavaScriptIndex jsIndex;
            PsiElement jsClass;
            if (FlexValue.isGenericVector(type)) {
                type = VECTOR;
            }
            if (!((jsClass = ActionScriptClassResolver.findClassByQName(type, jsIndex = JavaScriptIndex.getInstance((Project)project), module)) instanceof JSClass) && type.endsWith("$")) {
                jsClass = ActionScriptClassResolver.findClassByQName(type.substring(0, type.length() - 1), jsIndex, module);
            }
            if (!(jsClass instanceof JSClass) && module != null && !((jsClass = ActionScriptClassResolver.findClassByQNameStatic(type, scope = ProjectScope.getAllScope((Project)project))) instanceof JSClass) && type.endsWith("$")) {
                jsClass = ActionScriptClassResolver.findClassByQNameStatic(type.substring(0, type.length() - 1), scope);
            }
            return jsClass instanceof JSClass ? (JSClass)jsClass : null;
        }
        return null;
    }

    private static String unescape(String str, boolean flexSdk_4_12plus_IdeMode) {
        int escapeStartIndex;
        if (flexSdk_4_12plus_IdeMode) {
            return StringUtil.unescapeStringCharacters((String)str);
        }
        int escapeEndIndex = 0;
        while ((escapeStartIndex = str.indexOf(ESCAPE_START, escapeEndIndex - ESCAPE_START.length())) > -1) {
            escapeEndIndex = str.indexOf(ESCAPE_END, escapeStartIndex);
            if (escapeEndIndex < 0) {
                escapeEndIndex = str.length();
            }
            str = str.substring(0, escapeStartIndex) + StringUtil.unescapeStringCharacters((String)str.substring(escapeStartIndex + ESCAPE_START.length(), escapeEndIndex)) + (escapeEndIndex + ESCAPE_END.length() <= str.length() ? str.substring(escapeEndIndex + ESCAPE_END.length()) : "");
        }
        return str;
    }

    static enum ValueType {
        This(PlatformIcons.CLASS_ICON),
        Parameter(PlatformIcons.PARAMETER_ICON),
        Variable(PlatformIcons.VARIABLE_ICON),
        Field(PlatformIcons.FIELD_ICON),
        ScopeChainEntry(PlatformIcons.CLASS_INITIALIZER),
        Other(null);

        @Nullable
        private final Icon myIcon;

        private ValueType(Icon icon) {
            this.myIcon = icon;
        }
    }
}

