/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.FlexRefactoringListenerProvider;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfigurationForm;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlexBaseRunner;
import com.intellij.lang.javascript.flex.run.FlexRunConfigRefactoringListener;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FlexUnitRunConfiguration
extends LocatableConfigurationBase
implements RunProfileWithCompileBeforeLaunchOption,
RefactoringListenerProvider {
    private FlexUnitRunnerParameters myRunnerParameters = new FlexUnitRunnerParameters();

    protected FlexUnitRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        FlexUnitRunConfigurationForm flexUnitRunConfigurationForm = new FlexUnitRunConfigurationForm(this.getProject());
        if (flexUnitRunConfigurationForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration", "getConfigurationEditor"));
        }
        return flexUnitRunConfigurationForm;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunnerParameters = new FlexUnitRunnerParameters();
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public FlexUnitRunConfiguration clone() {
        FlexUnitRunConfiguration clone = (FlexUnitRunConfiguration)super.clone();
        clone.myRunnerParameters = this.myRunnerParameters.clone();
        return clone;
    }

    @NotNull
    public FlexUnitRunnerParameters getRunnerParameters() {
        FlexUnitRunnerParameters flexUnitRunnerParameters = this.myRunnerParameters;
        if (flexUnitRunnerParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration", "getRunnerParameters"));
        }
        return flexUnitRunnerParameters;
    }

    public String suggestedName() {
        switch (this.myRunnerParameters.getScope()) {
            case Class: {
                return StringUtil.getShortName((String)this.myRunnerParameters.getClassName());
            }
            case Method: {
                return StringUtil.getShortName((String)this.myRunnerParameters.getClassName()) + "." + this.myRunnerParameters.getMethodName() + "()";
            }
            case Package: {
                return StringUtil.isEmpty((String)this.myRunnerParameters.getPackageName()) ? this.myRunnerParameters.getModuleName() : this.myRunnerParameters.getPackageName();
            }
        }
        assert (false) : "Unknown scope: " + (Object)((Object)this.myRunnerParameters.getScope());
        return null;
    }

    @NotNull
    public Module[] getModules() {
        Module module = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myRunnerParameters.getModuleName());
        if (module != null && ModuleType.get((Module)module) instanceof FlexModuleType) {
            Module[] moduleArray = new Module[]{module};
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration", "getModules"));
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration", "getModules"));
        }
        return Module.EMPTY_ARRAY;
    }

    public RunProfileState getState(@NotNull Executor executor, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        FlexBuildConfiguration bc;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration", "getState"));
        }
        try {
            bc = (FlexBuildConfiguration)this.myRunnerParameters.checkAndGetModuleAndBC((Project)this.getProject()).second;
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        BuildConfigurationNature nature = bc.getNature();
        if (nature.isDesktopPlatform() || nature.isMobilePlatform()) {
            return new FlashRunConfiguration.AirRunState(this.getProject(), env, this.myRunnerParameters){

                @NotNull
                public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                    if (executor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration$1", "execute"));
                    }
                    if (runner == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration$1", "execute"));
                    }
                    OSProcessHandler processHandler = this.startProcess();
                    ExecutionConsole console = FlexBaseRunner.createFlexUnitRunnerConsole(FlexUnitRunConfiguration.this.getProject(), env, (ProcessHandler)processHandler);
                    DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(console, (ProcessHandler)processHandler);
                    if (defaultExecutionResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfiguration$1", "execute"));
                    }
                    return defaultExecutionResult;
                }
            };
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void checkConfiguration() throws RuntimeConfigurationError {
        this.myRunnerParameters.check(this.getProject());
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        FlexUnitRunnerParameters params = this.getRunnerParameters();
        Module module = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(params.getModuleName());
        if (!(element instanceof PsiDirectoryContainer || element instanceof JSPackage || element instanceof JSPackageStatement || module != null && module.equals(ModuleUtilCore.findModuleForPsiElement((PsiElement)element)))) {
            return null;
        }
        switch (params.getScope()) {
            case Method: {
                PsiElement parent;
                if (element instanceof JSFunction && (parent = element.getParent()) instanceof JSClass && Comparing.strEqual((String)((JSClass)parent).getQualifiedName(), (String)params.getClassName()) && Comparing.strEqual((String)((JSFunction)element).getName(), (String)params.getMethodName())) {
                    return new FlexRunConfigRefactoringListener.JSFunctionRefactoringListener(this);
                }
            }
            case Class: {
                if (element instanceof PsiDirectory && FlashRunConfiguration.containsClass(module, (PsiDirectory)element, params.getClassName())) {
                    return new FlexRunConfigRefactoringListener.PsiDirectoryRefactoringListener((RunConfigurationBase)this);
                }
                JSClass jsClass = FlexRefactoringListenerProvider.getJSClass(element);
                if (jsClass != null && Comparing.strEqual((String)jsClass.getQualifiedName(), (String)params.getClassName())) {
                    return new FlexRunConfigRefactoringListener.JSClassRefactoringListener((RunConfigurationBase)this);
                }
            }
            case Package: {
                String currentPackage;
                String string = currentPackage = params.getScope() == FlexUnitRunnerParameters.Scope.Package ? params.getPackageName() : StringUtil.getPackageName((String)params.getClassName());
                if (!(element instanceof PsiDirectoryContainer) && !(element instanceof JSPackage) && !(element instanceof JSPackageStatement) || !Comparing.strEqual((String)FlexRefactoringListenerProvider.getPackageName(element), (String)currentPackage)) break;
                return new FlexRunConfigRefactoringListener.PackageRefactoringListener((RunConfigurationBase)this);
            }
        }
        return null;
    }
}

