/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.inspections.FlexUnitClassInspectionBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FlexUnitClassWithNoTestsInspection
extends FlexUnitClassInspectionBase {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("flexunit.inspection.testclasswithnotests.displayname", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassWithNoTestsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("FlexUnitClassWithNoTestsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassWithNoTestsInspection", "getShortName"));
        }
        return "FlexUnitClassWithNoTestsInspection";
    }

    @Override
    protected void visitPotentialTestClass(JSClass aClass, @NotNull ProblemsHolder holder, FlexUnitSupport support) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassWithNoTestsInspection", "visitPotentialTestClass"));
        }
        if (!support.isTestClass(aClass, false)) {
            return;
        }
        for (JSFunction method : aClass.getFunctions()) {
            if (!support.isTestMethod(method)) continue;
            return;
        }
        ASTNode nameIdentifier = aClass.findNameIdentifier();
        if (nameIdentifier != null) {
            holder.registerProblem(nameIdentifier.getPsi(), FlexBundle.message("flexunit.inspection.testclasswithnotests.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }
}

