/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.inspections.FlexUnitMethodInspectionBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FlexUnitMethodIsStaticInspection
extends FlexUnitMethodInspectionBase {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("flexunit.inspection.testmethodisstatic.displayname", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitMethodIsStaticInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("FlexUnitMethodIsStaticInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitMethodIsStaticInspection", "getShortName"));
        }
        return "FlexUnitMethodIsStaticInspection";
    }

    @Override
    protected void visitPotentialTestMethod(JSFunction method, ProblemsHolder holder, FlexUnitSupport support) {
        ASTNode nameIdentifier;
        if (FlexUnitSupport.getCustomRunner((JSClass)method.getParent()) != null) {
            return;
        }
        if (method.getAttributeList() != null && method.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC) && (nameIdentifier = method.findNameIdentifier()) != null) {
            ASTNode node = method.getAttributeList().getNode().findChildByType(JSTokenTypes.STATIC_KEYWORD);
            assert (node != null);
            holder.registerProblem(nameIdentifier.getPsi(), FlexBundle.message("flexunit.inspection.testmethodisstatic.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveASTNodeFix("0.is.not.a.legal.name", node){

                @NotNull
                public String getText() {
                    String string = FlexBundle.message("flexunit.fix.remove.static.modifier", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitMethodIsStaticInspection$1", "getText"));
                    }
                    return string;
                }
            }});
        }
    }
}

