/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.inspections.FlexUnitMethodInspectionBase;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FlexUnitMethodVisibilityInspection
extends FlexUnitMethodInspectionBase {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("flexunit.inspection.testmethodvisibility.displayname", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitMethodVisibilityInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("FlexUnitMethodVisibilityInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitMethodVisibilityInspection", "getShortName"));
        }
        return "FlexUnitMethodVisibilityInspection";
    }

    @Override
    protected void visitPotentialTestMethod(@NotNull JSFunction method, ProblemsHolder holder, FlexUnitSupport support) {
        ASTNode nameIdentifier;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitMethodVisibilityInspection", "visitPotentialTestMethod"));
        }
        if (FlexUnitSupport.getCustomRunner((JSClass)method.getParent()) != null) {
            return;
        }
        if ((method.getAttributeList() == null || method.getAttributeList().getAccessType() != JSAttributeList.AccessType.PUBLIC) && (nameIdentifier = method.findNameIdentifier()) != null) {
            holder.registerProblem(nameIdentifier.getPsi(), FlexBundle.message("flexunit.inspection.testmethodvisibility.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{JSFixFactory.getInstance().createChangeVisibilityFix((JSAttributeListOwner)method, JSAttributeList.AccessType.PUBLIC, null)});
        }
    }
}

