/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.presentation;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.xml.XmlStructureViewTreeModel;
import com.intellij.ide.structureView.xml.XmlStructureViewBuilderProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexStructureViewProvider
implements XmlStructureViewBuilderProvider {
    public StructureViewBuilder createStructureViewBuilder(final @NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/presentation/FlexStructureViewProvider", "createStructureViewBuilder"));
        }
        if (!JavaScriptSupportLoader.isFlexMxmFile((PsiFile)file)) {
            return null;
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                XmlStructureViewTreeModel xmlStructureViewTreeModel = new XmlStructureViewTreeModel(file, editor){

                    @NotNull
                    public Sorter[] getSorters() {
                        if (Sorter.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/presentation/FlexStructureViewProvider$1$1", "getSorters"));
                        }
                        return Sorter.EMPTY_ARRAY;
                    }
                };
                if (xmlStructureViewTreeModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/presentation/FlexStructureViewProvider$1", "createStructureViewModel"));
                }
                return xmlStructureViewTreeModel;
            }
        };
    }

    static class FlexStructureViewElement
    extends JSStructureViewElement {
        private final XmlFile myFile;

        public FlexStructureViewElement(JSClass clazz, XmlFile file, boolean includeInherited) {
            super((PsiElement)clazz, includeInherited, true);
            this.myFile = file;
        }

        protected List<StructureViewTreeElement> collectMyElements(THashSet<String> referencedNamedIds, JSQualifiedName ns, PsiFile contextFile) {
            final ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
            ResolveProcessor processor = new ResolveProcessor(null){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/presentation/FlexStructureViewProvider$FlexStructureViewElement$1", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/flex/presentation/FlexStructureViewProvider$FlexStructureViewElement$1", "execute"));
                    }
                    result.add(new JSStructureViewElement(element, true, true));
                    return true;
                }
            };
            processor.setLocalResolve(true);
            this.myElement.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), this.myElement, this.myElement);
            this.myFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    if ("style".equalsIgnoreCase(tag.getLocalName())) {
                        for (StructureViewExtension ext : StructureViewFactoryEx.getInstanceEx((Project)myFile.getProject()).getAllExtensions(XmlTag.class)) {
                            Object[] structureViewTreeElements = ext.getChildren((PsiElement)tag);
                            if (structureViewTreeElements == null || structureViewTreeElements.length <= 0) continue;
                            ContainerUtil.addAll((Collection)result, (Object[])structureViewTreeElements);
                        }
                    } else {
                        super.visitXmlTag(tag);
                    }
                }
            });
            return result;
        }

        protected JSStructureViewElement createStructureViewElement(PsiElement element, Set<String> parentReferencedNames) {
            if (element instanceof XmlBackedJSClassImpl) {
                PsiFile file = element.getContainingFile();
                return new FlexStructureViewElement((JSClass)element, (XmlFile)file, this.myIncludeInherited);
            }
            return super.createStructureViewElement(element, parentReferencedNames);
        }
    }
}

