/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.presentation;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.javascript.flex.presentation.SwfProjectViewStructureProvider;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SwfPackageElementNode
extends ProjectViewNode<String> {
    private final String myDisplayText;
    private final List<JSQualifiedNamedElement> myElements;
    private final int myFrom;
    private final int myTo;

    public SwfPackageElementNode(Project project, String aPackage, String displayText, ViewSettings viewSettings, List<JSQualifiedNamedElement> elements, int from, int to) {
        super(project, (Object)aPackage, viewSettings);
        this.myDisplayText = displayText;
        this.myElements = elements;
        this.myFrom = from;
        this.myTo = to;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/presentation/SwfPackageElementNode", "contains"));
        }
        return SwfProjectViewStructureProvider.nodeContainsFile(this, file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Collection<AbstractTreeNode> collection = SwfProjectViewStructureProvider.getChildrenForPackage((String)this.getValue(), this.myElements, this.myFrom, this.myTo, this.myProject, this.getSettings());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/presentation/SwfPackageElementNode", "getChildren"));
        }
        return collection;
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText(this.myDisplayText);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 3;
    }
}

