/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectLibrariesSettings;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.conversion.ConversionParams;
import com.intellij.lang.javascript.flex.projectStructure.conversion.FlexModuleConverter;
import com.intellij.util.Function;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jdom.Element;

class FlexLibrariesConverter
extends ConversionProcessor<ProjectLibrariesSettings> {
    private final ConversionContext myContext;
    private final ConversionParams myParams;
    private static final Function<Element, String> LIB_NAME_MAPPER = element -> element.getAttributeValue("name");

    public FlexLibrariesConverter(ConversionContext context, ConversionParams params) {
        this.myContext = context;
        this.myParams = params;
    }

    public boolean isConversionNeeded(ProjectLibrariesSettings projectLibrariesSettings) {
        Collection<String> projectLibrariesNames = this.getProjectLibrariesNames(projectLibrariesSettings);
        try {
            for (File moduleFile : this.myContext.getModuleFiles()) {
                ModuleSettings moduleSettings;
                if (!moduleFile.exists() || !FlexModuleConverter.isConversionNeededStatic(moduleSettings = this.myContext.getModuleSettings(moduleFile))) continue;
                for (Element orderEntry : moduleSettings.getOrderEntries()) {
                    String orderEntryType = orderEntry.getAttributeValue("type");
                    if (!"library".equals(orderEntryType)) continue;
                    String libraryName = orderEntry.getAttributeValue("name");
                    String libraryLevel = orderEntry.getAttributeValue("level");
                    if (!"project".equals(libraryLevel) || !projectLibrariesNames.contains(libraryName)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (CannotConvertException e) {
            return false;
        }
    }

    public void process(ProjectLibrariesSettings projectLibrariesSettings) throws CannotConvertException {
    }

    public void preProcess(ProjectLibrariesSettings projectLibrariesSettings) throws CannotConvertException {
        this.myParams.setProjectLibrariesNames(this.getProjectLibrariesNames(projectLibrariesSettings));
    }

    private Collection<String> getProjectLibrariesNames(ProjectLibrariesSettings projectLibrariesSettings) {
        HashSet librariesNames = new HashSet();
        for (Element element : projectLibrariesSettings.getProjectLibraries()) {
            if (!FlexModuleConverter.isApplicableLibrary(element, (Function<String, String>)((Function)s -> this.myParams.expandPath((String)s)))) continue;
            librariesNames.add(LIB_NAME_MAPPER.fun((Object)element));
        }
        return librariesNames;
    }

    public void postProcess(ProjectLibrariesSettings projectLibrariesSettings) throws CannotConvertException {
        Set<String> librariesToMakeFlex = this.myParams.getProjectLibrariesToMakeFlex();
        for (Element libraryElement : projectLibrariesSettings.getProjectLibraries()) {
            if (!librariesToMakeFlex.contains(LIB_NAME_MAPPER.fun((Object)libraryElement))) continue;
            libraryElement.setAttribute("type", FlexLibraryType.FLEX_LIBRARY.getKindId());
        }
    }
}

