/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.build.FlexCompilerConfigFileUtil;
import com.intellij.lang.javascript.flex.build.InfoFromConfigFile;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableAirDesktopPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableAndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencies;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableIosPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.SdkEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.AirDesktopPackagingOptionsImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.AndroidPackagingOptionsImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.CompilerOptionsImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.DependenciesImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationState;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.IosPackagingOptionsImpl;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FlexBuildConfigurationImpl
implements ModifiableFlexBuildConfiguration {
    @NotNull
    private String myName = "Unnamed";
    @NotNull
    private TargetPlatform myTargetPlatform;
    private boolean myPureAs;
    @NotNull
    private OutputType myOutputType;
    @NotNull
    private String myOptimizeFor;
    @NotNull
    private String myMainClass;
    @NotNull
    private String myOutputFileName;
    @NotNull
    private String myOutputFolder;
    private boolean myUseHtmlWrapper;
    @NotNull
    private String myWrapperTemplatePath;
    @NotNull
    private String myRLMs;
    @NotNull
    private String myCssFilesToCompile;
    private boolean mySkipCompile;
    private final DependenciesImpl myDependencies;
    private final CompilerOptionsImpl myCompilerOptions;
    private final AirDesktopPackagingOptionsImpl myAirDesktopPackagingOptions;
    private final AndroidPackagingOptionsImpl myAndroidPackagingOptions;
    private final IosPackagingOptionsImpl myIosPackagingOptions;
    private boolean myTempBCForCompilation;

    FlexBuildConfigurationImpl() {
        this.myTargetPlatform = BuildConfigurationNature.DEFAULT.targetPlatform;
        this.myPureAs = BuildConfigurationNature.DEFAULT.pureAS;
        this.myOutputType = BuildConfigurationNature.DEFAULT.outputType;
        this.myOptimizeFor = "";
        this.myMainClass = "";
        this.myOutputFileName = "";
        this.myOutputFolder = "";
        this.myUseHtmlWrapper = false;
        this.myWrapperTemplatePath = "";
        this.myRLMs = "";
        this.myCssFilesToCompile = "";
        this.mySkipCompile = false;
        this.myDependencies = new DependenciesImpl();
        this.myCompilerOptions = new CompilerOptionsImpl();
        this.myAirDesktopPackagingOptions = new AirDesktopPackagingOptionsImpl();
        this.myAndroidPackagingOptions = new AndroidPackagingOptionsImpl();
        this.myIosPackagingOptions = new IosPackagingOptionsImpl();
        this.myTempBCForCompilation = false;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.myTargetPlatform;
        if (targetPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getTargetPlatform"));
        }
        return targetPlatform;
    }

    @Override
    public boolean isPureAs() {
        return this.myPureAs;
    }

    @Override
    @NotNull
    public OutputType getOutputType() {
        OutputType outputType = this.myOutputType;
        if (outputType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getOutputType"));
        }
        return outputType;
    }

    @Override
    @NotNull
    public String getOptimizeFor() {
        String string = this.myOptimizeFor;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getOptimizeFor"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getMainClass() {
        String string = this.myMainClass;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getMainClass"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getOutputFileName() {
        String string = this.myOutputFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getOutputFileName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getOutputFolder() {
        String string = this.myOutputFolder;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getOutputFolder"));
        }
        return string;
    }

    @Override
    public boolean isUseHtmlWrapper() {
        return this.myUseHtmlWrapper;
    }

    @Override
    @NotNull
    public String getWrapperTemplatePath() {
        String string = this.myWrapperTemplatePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getWrapperTemplatePath"));
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<FlexBuildConfiguration.RLMInfo> getRLMs() {
        if (this.myRLMs.isEmpty()) {
            List<FlexBuildConfiguration.RLMInfo> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getRLMs"));
            }
            return list;
        }
        List entries = StringUtil.split((String)this.myRLMs, (String)"\n");
        ArrayList<FlexBuildConfiguration.RLMInfo> result = new ArrayList<FlexBuildConfiguration.RLMInfo>(entries.size());
        for (String entry : entries) {
            List parts = StringUtil.split((String)entry, (String)"\t", (boolean)true, (boolean)false);
            assert (parts.size() == 3) : entry;
            result.add(new FlexBuildConfiguration.RLMInfo((String)parts.get(0), (String)parts.get(1), Boolean.valueOf((String)parts.get(2))));
        }
        ArrayList<FlexBuildConfiguration.RLMInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getRLMs"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<String> getCssFilesToCompile() {
        if (this.myCssFilesToCompile.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getCssFilesToCompile"));
            }
            return list;
        }
        List list = StringUtil.split((String)this.myCssFilesToCompile, (String)"\n");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getCssFilesToCompile"));
        }
        return list;
    }

    @Override
    public boolean isSkipCompile() {
        return this.mySkipCompile;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setName"));
        }
        this.myName = name;
    }

    @Override
    public void setNature(BuildConfigurationNature nature) {
        this.myTargetPlatform = nature.targetPlatform;
        this.myPureAs = nature.pureAS;
        this.myOutputType = nature.outputType;
    }

    @Override
    public void setTargetPlatform(@NotNull TargetPlatform targetPlatform) {
        if (targetPlatform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPlatform", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setTargetPlatform"));
        }
        this.myTargetPlatform = targetPlatform;
    }

    @Override
    public void setPureAs(boolean pureAs) {
        this.myPureAs = pureAs;
    }

    @Override
    public void setOutputType(@NotNull OutputType outputType) {
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setOutputType"));
        }
        this.myOutputType = outputType;
    }

    @Override
    public void setOptimizeFor(@NotNull String optimizeFor) {
        if (optimizeFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optimizeFor", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setOptimizeFor"));
        }
        this.myOptimizeFor = optimizeFor;
    }

    @Override
    public void setMainClass(@NotNull String mainClass) {
        if (mainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainClass", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setMainClass"));
        }
        this.myMainClass = mainClass;
    }

    @Override
    public void setOutputFileName(@NotNull String outputFileName) {
        if (outputFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFileName", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setOutputFileName"));
        }
        this.myOutputFileName = outputFileName;
    }

    @Override
    public void setOutputFolder(@NotNull String outputFolder) {
        if (outputFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFolder", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setOutputFolder"));
        }
        this.myOutputFolder = StringUtil.trimEnd((String)outputFolder, (String)"/");
    }

    @Override
    public void setUseHtmlWrapper(boolean useHtmlWrapper) {
        this.myUseHtmlWrapper = useHtmlWrapper;
    }

    @Override
    public void setWrapperTemplatePath(@NotNull String wrapperTemplatePath) {
        if (wrapperTemplatePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperTemplatePath", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setWrapperTemplatePath"));
        }
        this.myWrapperTemplatePath = wrapperTemplatePath;
    }

    @Override
    public void setRLMs(@NotNull Collection<FlexBuildConfiguration.RLMInfo> rlms) {
        if (rlms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rlms", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setRLMs"));
        }
        if (rlms.isEmpty()) {
            this.myRLMs = "";
        }
        this.myRLMs = StringUtil.join(rlms, info -> info.MAIN_CLASS + "\t" + info.OUTPUT_FILE + "\t" + info.OPTIMIZE, (String)"\n");
    }

    @Override
    public void setCssFilesToCompile(@NotNull Collection<String> cssFilesToCompile) {
        if (cssFilesToCompile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssFilesToCompile", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "setCssFilesToCompile"));
        }
        this.myCssFilesToCompile = cssFilesToCompile.isEmpty() ? "" : StringUtil.join(cssFilesToCompile, (String)"\n");
    }

    @Override
    public void setSkipCompile(boolean skipCompile) {
        this.mySkipCompile = skipCompile;
    }

    @Override
    @NotNull
    public ModifiableDependencies getDependencies() {
        DependenciesImpl dependenciesImpl = this.myDependencies;
        if (dependenciesImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getDependencies"));
        }
        return dependenciesImpl;
    }

    @Override
    @NotNull
    public CompilerOptionsImpl getCompilerOptions() {
        CompilerOptionsImpl compilerOptionsImpl = this.myCompilerOptions;
        if (compilerOptionsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getCompilerOptions"));
        }
        return compilerOptionsImpl;
    }

    @Override
    @NotNull
    public ModifiableAirDesktopPackagingOptions getAirDesktopPackagingOptions() {
        AirDesktopPackagingOptionsImpl airDesktopPackagingOptionsImpl = this.myAirDesktopPackagingOptions;
        if (airDesktopPackagingOptionsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getAirDesktopPackagingOptions"));
        }
        return airDesktopPackagingOptionsImpl;
    }

    @Override
    @NotNull
    public ModifiableAndroidPackagingOptions getAndroidPackagingOptions() {
        AndroidPackagingOptionsImpl androidPackagingOptionsImpl = this.myAndroidPackagingOptions;
        if (androidPackagingOptionsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getAndroidPackagingOptions"));
        }
        return androidPackagingOptionsImpl;
    }

    @Override
    @NotNull
    public ModifiableIosPackagingOptions getIosPackagingOptions() {
        IosPackagingOptionsImpl iosPackagingOptionsImpl = this.myIosPackagingOptions;
        if (iosPackagingOptionsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationImpl", "getIosPackagingOptions"));
        }
        return iosPackagingOptionsImpl;
    }

    @Override
    public Icon getIcon() {
        return this.getNature().getIcon();
    }

    @Override
    public String getShortText() {
        return this.myName;
    }

    @Override
    public String getDescription() {
        return this.myOutputType.getShortText();
    }

    @Override
    public String getActualOutputFilePath() {
        InfoFromConfigFile info = FlexCompilerConfigFileUtil.getInfoFromConfigFile(this.myCompilerOptions.getAdditionalConfigFilePath());
        String outputFolderPath = BCUtils.isFlexUnitBC(this) ? this.myOutputFolder : StringUtil.notNullize((String)info.getOutputFolderPath(), (String)this.myOutputFolder);
        String outputFileName = this.myTempBCForCompilation ? this.myOutputFileName : StringUtil.notNullize((String)info.getOutputFileName(), (String)this.myOutputFileName);
        return outputFolderPath + (outputFolderPath.isEmpty() ? "" : "/") + outputFileName;
    }

    public FlexBuildConfigurationImpl getCopy() {
        FlexBuildConfigurationImpl copy = new FlexBuildConfigurationImpl();
        this.applyTo(copy);
        return copy;
    }

    void applyTo(FlexBuildConfigurationImpl copy) {
        this.myAirDesktopPackagingOptions.applyTo(copy.myAirDesktopPackagingOptions);
        this.myAndroidPackagingOptions.applyTo(copy.myAndroidPackagingOptions);
        this.myCompilerOptions.applyTo(copy.myCompilerOptions);
        this.myDependencies.applyTo(copy.myDependencies);
        this.myIosPackagingOptions.applyTo(copy.myIosPackagingOptions);
        copy.myCssFilesToCompile = this.myCssFilesToCompile;
        copy.myMainClass = this.myMainClass;
        copy.myName = this.myName;
        copy.myOptimizeFor = this.myOptimizeFor;
        copy.myOutputFileName = this.myOutputFileName;
        copy.myOutputFolder = this.myOutputFolder;
        copy.myOutputType = this.myOutputType;
        copy.myPureAs = this.myPureAs;
        copy.myRLMs = this.myRLMs;
        copy.mySkipCompile = this.mySkipCompile;
        copy.myTargetPlatform = this.myTargetPlatform;
        copy.myUseHtmlWrapper = this.myUseHtmlWrapper;
        copy.myWrapperTemplatePath = this.myWrapperTemplatePath;
    }

    @Override
    public boolean isEqual(FlexBuildConfiguration bc) {
        FlexBuildConfigurationImpl other = (FlexBuildConfigurationImpl)bc;
        if (!this.myAirDesktopPackagingOptions.isEqual(other.myAirDesktopPackagingOptions)) {
            return false;
        }
        if (!this.myAndroidPackagingOptions.isEqual(other.myAndroidPackagingOptions)) {
            return false;
        }
        if (!this.myCompilerOptions.isEqual(other.myCompilerOptions)) {
            return false;
        }
        if (!this.myDependencies.isEqual(other.myDependencies)) {
            return false;
        }
        if (!this.myIosPackagingOptions.isEqual(other.myIosPackagingOptions)) {
            return false;
        }
        if (!other.myCssFilesToCompile.equals(this.myCssFilesToCompile)) {
            return false;
        }
        if (!other.myMainClass.equals(this.myMainClass)) {
            return false;
        }
        if (!other.myName.equals(this.myName)) {
            return false;
        }
        if (!other.myOptimizeFor.equals(this.myOptimizeFor)) {
            return false;
        }
        if (!other.myOutputFileName.equals(this.myOutputFileName)) {
            return false;
        }
        if (!other.myOutputFolder.equals(this.myOutputFolder)) {
            return false;
        }
        if (other.myOutputType != this.myOutputType) {
            return false;
        }
        if (other.myPureAs != this.myPureAs) {
            return false;
        }
        if (!other.myRLMs.equals(this.myRLMs)) {
            return false;
        }
        if (other.mySkipCompile != this.mySkipCompile) {
            return false;
        }
        if (other.myTargetPlatform != this.myTargetPlatform) {
            return false;
        }
        if (other.myUseHtmlWrapper != this.myUseHtmlWrapper) {
            return false;
        }
        return other.myWrapperTemplatePath.equals(this.myWrapperTemplatePath);
    }

    @Override
    public BuildConfigurationNature getNature() {
        return new BuildConfigurationNature(this.myTargetPlatform, this.myPureAs, this.myOutputType);
    }

    @Override
    @Nullable
    public Sdk getSdk() {
        SdkEntry sdkEntry = this.myDependencies.getSdkEntry();
        return sdkEntry == null ? null : (Sdk)ContainerUtil.find(FlexSdkUtils.getFlexAndFlexmojosSdks(), sdk -> sdkEntry.getName().equals(sdk.getName()));
    }

    @Override
    public boolean isTempBCForCompilation() {
        return this.myTempBCForCompilation;
    }

    void setTempBCForCompilation(boolean tempBCForCompilation) {
        this.myTempBCForCompilation = tempBCForCompilation;
    }

    public String toString() {
        return this.myName + ": " + this.getNature().toString();
    }

    @Override
    public String getStatisticsEntry() {
        StringBuilder s = new StringBuilder();
        switch (this.myTargetPlatform) {
            case Web: {
                s.append("Web");
                break;
            }
            case Desktop: {
                s.append("Desktop");
                break;
            }
            case Mobile: {
                s.append("Mobile");
                if (this.myAndroidPackagingOptions.isEnabled() && this.myIosPackagingOptions.isEnabled()) {
                    s.append("(a+i)");
                    break;
                }
                if (this.myAndroidPackagingOptions.isEnabled()) {
                    s.append("(a)");
                    break;
                }
                if (!this.myIosPackagingOptions.isEnabled()) break;
                s.append("(i)");
                break;
            }
            default: {
                assert (false) : this.myTargetPlatform;
                break;
            }
        }
        s.append(" ");
        s.append(this.myPureAs ? "AS" : "Flex");
        s.append(" ");
        switch (this.myOutputType) {
            case Application: {
                s.append("app");
                break;
            }
            case Library: {
                s.append("lib");
                break;
            }
            case RuntimeLoadedModule: {
                s.append("rlm");
                break;
            }
            default: {
                assert (false) : this.myOutputType;
                break;
            }
        }
        Sdk sdk = this.getSdk();
        if (sdk != null && sdk.getSdkType() == FlexmojosSdkType.getInstance()) {
            s.append(" (mvn)");
        }
        return s.toString();
    }

    public FlexBuildConfigurationState getState(@Nullable ComponentManager componentManager) {
        FlexBuildConfigurationState state = new FlexBuildConfigurationState();
        state.AIR_DESKTOP_PACKAGING_OPTIONS = this.myAirDesktopPackagingOptions.getState();
        state.ANDROID_PACKAGING_OPTIONS = this.myAndroidPackagingOptions.getState();
        state.COMPILER_OPTIONS = this.myCompilerOptions.getState(componentManager);
        state.DEPENDENCIES = this.myDependencies.getState();
        state.IOS_PACKAGING_OPTIONS = this.myIosPackagingOptions.getState();
        state.CSS_FILES_TO_COMPILE = FlexBuildConfigurationImpl.collapsePaths(componentManager, this.myCssFilesToCompile);
        state.MAIN_CLASS = this.myMainClass;
        state.NAME = this.myName;
        state.OPTIMIZE_FOR = this.myOptimizeFor;
        state.OUTPUT_FILE_NAME = this.myOutputFileName;
        state.OUTPUT_FOLDER = this.myOutputFolder;
        state.OUTPUT_TYPE = this.myOutputType;
        state.PURE_ACTION_SCRIPT = this.myPureAs;
        state.RLMS = this.myRLMs;
        state.SKIP_COMPILE = this.mySkipCompile;
        state.TARGET_PLATFORM = this.myTargetPlatform;
        state.USE_HTML_WRAPPER = this.myUseHtmlWrapper;
        state.WRAPPER_TEMPLATE_PATH = this.myWrapperTemplatePath;
        return state;
    }

    public void loadState(FlexBuildConfigurationState state, Project project) {
        this.myAirDesktopPackagingOptions.loadState(state.AIR_DESKTOP_PACKAGING_OPTIONS);
        this.myAndroidPackagingOptions.loadState(state.ANDROID_PACKAGING_OPTIONS);
        this.myCompilerOptions.loadState(state.COMPILER_OPTIONS);
        this.myDependencies.loadState(state.DEPENDENCIES, project);
        this.myIosPackagingOptions.loadState(state.IOS_PACKAGING_OPTIONS);
        this.myCssFilesToCompile = state.CSS_FILES_TO_COMPILE;
        this.myMainClass = state.MAIN_CLASS;
        this.myName = state.NAME;
        this.myOptimizeFor = state.OPTIMIZE_FOR;
        this.myOutputFileName = state.OUTPUT_FILE_NAME;
        this.myOutputFolder = StringUtil.trimEnd((String)state.OUTPUT_FOLDER, (String)"/");
        this.myOutputType = state.OUTPUT_TYPE;
        this.myPureAs = state.PURE_ACTION_SCRIPT;
        this.myRLMs = state.RLMS;
        this.mySkipCompile = state.SKIP_COMPILE;
        this.myTargetPlatform = state.TARGET_PLATFORM;
        this.myUseHtmlWrapper = state.USE_HTML_WRAPPER;
        this.myWrapperTemplatePath = state.WRAPPER_TEMPLATE_PATH;
    }

    static String collapsePaths(@Nullable ComponentManager componentManager, String value) {
        if (componentManager == null) {
            return value;
        }
        if (!value.contains("\n") && !value.contains("\t")) {
            return value;
        }
        StringBuilder result = new StringBuilder();
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)componentManager);
        String delimiters = "\n\t";
        StringTokenizer tokenizer = new StringTokenizer(value, "\n\t", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() > 1) {
                token = pathMacroManager.collapsePath(token);
            }
            result.append(token);
        }
        return result.toString();
    }
}

