/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyType;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.DependencyTypeImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.EntryState;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.StatefulDependencyEntry;
import org.jetbrains.annotations.NotNull;

class ModuleLibraryEntryImpl
implements ModifiableModuleLibraryEntry,
StatefulDependencyEntry {
    private final DependencyTypeImpl myDependencyType;
    @NotNull
    private final String myLibraryId;

    public ModuleLibraryEntryImpl(@NotNull String libraryId) {
        if (libraryId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryId", "com/intellij/lang/javascript/flex/projectStructure/model/impl/ModuleLibraryEntryImpl", "<init>"));
        }
        this.myDependencyType = new DependencyTypeImpl();
        this.myLibraryId = libraryId;
    }

    @Override
    @NotNull
    public String getLibraryId() {
        String string = this.myLibraryId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/ModuleLibraryEntryImpl", "getLibraryId"));
        }
        return string;
    }

    @Override
    @NotNull
    public DependencyTypeImpl getDependencyType() {
        DependencyTypeImpl dependencyTypeImpl = this.myDependencyType;
        if (dependencyTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/ModuleLibraryEntryImpl", "getDependencyType"));
        }
        return dependencyTypeImpl;
    }

    public ModuleLibraryEntryImpl getCopy() {
        ModuleLibraryEntryImpl copy = new ModuleLibraryEntryImpl(this.myLibraryId);
        this.applyTo(copy);
        return copy;
    }

    private void applyTo(ModifiableModuleLibraryEntry copy) {
        this.myDependencyType.applyTo((ModifiableDependencyType)copy.getDependencyType());
    }

    @Override
    public boolean isEqual(ModifiableDependencyEntry other) {
        if (!(other instanceof ModuleLibraryEntryImpl)) {
            return false;
        }
        if (!this.myLibraryId.equals(((ModuleLibraryEntryImpl)other).myLibraryId)) {
            return false;
        }
        return this.myDependencyType.isEqual(((ModuleLibraryEntryImpl)other).myDependencyType);
    }

    @Override
    public EntryState getState() {
        EntryState state = new EntryState();
        state.LIBRARY_ID = this.myLibraryId;
        state.DEPENDENCY_TYPE = this.myDependencyType.getState();
        return state;
    }
}

