/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.options;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.FlexProjectLevelCompilerOptionsHolder;
import com.intellij.lang.javascript.flex.projectStructure.model.AirDesktopPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.PublicInheritorFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BCUtils {
    private static LinkageType[] FLEX_LIB_LINKAGES = new LinkageType[]{LinkageType.Default, LinkageType.Merged, LinkageType.External};
    private static LinkageType[] FLEX_MOBILE_APP_LINKAGES = new LinkageType[]{LinkageType.Default};
    private static LinkageType[] FLEX_WEB_OR_DESKTOP_APP_LINKAGES = new LinkageType[]{LinkageType.Default, LinkageType.Merged, LinkageType.RSL};
    private static LinkageType[] AS_LINKAGES = new LinkageType[]{LinkageType.Default};
    private static Logger LOG = Logger.getInstance(BCUtils.class);

    public static boolean isTransitiveDependency(LinkageType linkageType) {
        return linkageType == LinkageType.Include;
    }

    public static String getWrapperFileName(FlexBuildConfiguration bc) {
        return FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)bc.getActualOutputFilePath())) + ".html";
    }

    public static String getGeneratedAirDescriptorName(FlexBuildConfiguration bc, AirPackagingOptions packagingOptions) {
        String suffix = packagingOptions instanceof AirDesktopPackagingOptions ? "-descriptor.xml" : (packagingOptions instanceof AndroidPackagingOptions ? "-android-descriptor.xml" : "-ios-descriptor.xml");
        return FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)bc.getActualOutputFilePath())) + suffix;
    }

    @Nullable
    public static String getBCSpecifier(FlexBuildConfiguration bc) {
        if (!bc.isTempBCForCompilation()) {
            return null;
        }
        if (BCUtils.isFlexUnitBC(bc)) {
            return "flexunit";
        }
        if (BCUtils.isRLMTemporaryBC(bc)) {
            return "module " + StringUtil.getShortName((String)bc.getMainClass());
        }
        if (BCUtils.isRuntimeStyleSheetBC(bc)) {
            return PathUtil.getFileName((String)bc.getMainClass());
        }
        return StringUtil.getShortName((String)bc.getMainClass());
    }

    public static boolean isFlexUnitBC(FlexBuildConfiguration bc) {
        return bc.isTempBCForCompilation() && bc.getMainClass().endsWith("____FlexUnitLauncher");
    }

    public static boolean canHaveRLMsAndRuntimeStylesheets(FlexBuildConfiguration bc) {
        return FlexCommonUtils.canHaveRLMsAndRuntimeStylesheets((OutputType)bc.getOutputType(), (TargetPlatform)bc.getTargetPlatform());
    }

    public static boolean isRLMTemporaryBC(FlexBuildConfiguration bc) {
        return bc.isTempBCForCompilation() && bc.getOutputType() == OutputType.RuntimeLoadedModule;
    }

    public static boolean isRuntimeStyleSheetBC(FlexBuildConfiguration bc) {
        return bc.isTempBCForCompilation() && bc.getMainClass().toLowerCase().endsWith(".css");
    }

    public static boolean canHaveResourceFiles(BuildConfigurationNature nature) {
        return nature.isApp();
    }

    public static LinkageType[] getSuitableFrameworkLinkages(BuildConfigurationNature nature) {
        return nature.pureAS ? AS_LINKAGES : (nature.isLib() ? FLEX_LIB_LINKAGES : (nature.isMobilePlatform() ? FLEX_MOBILE_APP_LINKAGES : FLEX_WEB_OR_DESKTOP_APP_LINKAGES));
    }

    @Nullable
    public static LinkageType getSdkEntryLinkageType(String swcPath, FlexBuildConfiguration bc) {
        Sdk sdk = bc.getSdk();
        LOG.assertTrue(sdk != null);
        return FlexCommonUtils.getSdkEntryLinkageType((String)sdk.getHomePath(), (String)swcPath, (BuildConfigurationNature)bc.getNature(), (String)bc.getDependencies().getTargetPlayer(), (ComponentSet)bc.getDependencies().getComponentSet());
    }

    public static boolean isApplicableForDependency(BuildConfigurationNature dependantNature, OutputType dependencyOutputType) {
        if (dependantNature.isLib()) {
            return dependencyOutputType == OutputType.Library;
        }
        return true;
    }

    public static void updateAvailableTargetPlayers(Sdk currentSdk, JComboBox targetPlayerCombo) {
        String playerFolderPath;
        if (currentSdk != null && currentSdk.getSdkType() instanceof FlexmojosSdkType) {
            return;
        }
        String sdkHome = currentSdk == null ? null : currentSdk.getHomePath();
        String string = playerFolderPath = sdkHome == null ? null : sdkHome + "/frameworks/libs/player";
        if (playerFolderPath != null) {
            VirtualFile playerDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<VirtualFile>(){

                public VirtualFile compute() {
                    VirtualFile playerFolder = LocalFileSystem.getInstance().refreshAndFindFileByPath(playerFolderPath);
                    if (playerFolder != null && playerFolder.isDirectory()) {
                        playerFolder.refresh(false, true);
                        return playerFolder;
                    }
                    return null;
                }
            });
            if (playerDir != null) {
                ArrayList availablePlayers = new ArrayList(2);
                FlexSdkUtils.processPlayerglobalSwcFiles(playerDir, (Processor<VirtualFile>)((Processor)playerglobalSwcFile -> {
                    availablePlayers.add(playerglobalSwcFile.getParent().getName());
                    return true;
                }));
                Object selectedItem = targetPlayerCombo.getSelectedItem();
                String[] availablePlayersArray = ArrayUtil.toStringArray(availablePlayers);
                targetPlayerCombo.setModel(new DefaultComboBoxModel<String>(availablePlayersArray));
                if (selectedItem != null && availablePlayers.contains(selectedItem)) {
                    targetPlayerCombo.setSelectedItem(selectedItem);
                } else {
                    targetPlayerCombo.setSelectedItem(FlexCommonUtils.getMaximumVersion((String[])availablePlayersArray));
                }
            }
        } else {
            targetPlayerCombo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.EMPTY_STRING_ARRAY));
        }
    }

    public static PublicInheritorFilter getMainClassFilter(@NotNull Module module, @Nullable FlexBuildConfiguration bc, boolean rlm, boolean includeTests, boolean caching) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/options/BCUtils", "getMainClassFilter"));
        }
        String baseClass = rlm ? "mx.modules.ModuleBase" : "flash.display.Sprite";
        GlobalSearchScope filterScope = bc == null ? module.getModuleWithDependenciesAndLibrariesScope(includeTests) : FlexUtils.getModuleWithDependenciesAndLibrariesScope(module, bc, includeTests);
        return new PublicInheritorFilter(module.getProject(), baseClass, filterScope, true, caching);
    }

    public static boolean isValidMainClass(Module module, @Nullable FlexBuildConfiguration buildConfiguration, JSClass clazz, boolean includeTests) {
        return BCUtils.getMainClassFilter(module, buildConfiguration, false, includeTests, false).value(clazz);
    }

    public static SimpleColoredText renderBuildConfiguration(@NotNull FlexBuildConfiguration bc, @Nullable String moduleName) {
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/projectStructure/options/BCUtils", "renderBuildConfiguration"));
        }
        return BCUtils.renderBuildConfiguration(bc, moduleName, false);
    }

    public static SimpleColoredText renderBuildConfiguration(@NotNull FlexBuildConfiguration bc, @Nullable String moduleName, boolean bold) {
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/projectStructure/options/BCUtils", "renderBuildConfiguration"));
        }
        SimpleColoredText text = new SimpleColoredText();
        text.append(bc.getShortText(), bold ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        text.append(" (" + bc.getDescription() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        if (moduleName != null) {
            text.append(" - " + moduleName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        return text;
    }

    public static SimpleColoredText renderMissingBuildConfiguration(@NotNull String bcName, @Nullable String moduleName) {
        if (bcName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bcName", "com/intellij/lang/javascript/flex/projectStructure/options/BCUtils", "renderMissingBuildConfiguration"));
        }
        return moduleName != null ? new SimpleColoredText(bcName + " - " + moduleName, SimpleTextAttributes.ERROR_ATTRIBUTES) : new SimpleColoredText(bcName, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public static String suggestRLMOutputPath(String mainClass) {
        return StringUtil.replaceChar((String)mainClass, (char)'.', (char)'/') + ".swf";
    }

    public static void initTargetPlatformCombo(JComboBox targetPlatformCombo) {
        targetPlatformCombo.setModel(new DefaultComboBoxModel<TargetPlatform>(TargetPlatform.values()));
        targetPlatformCombo.setRenderer(new ListCellRendererWrapper<TargetPlatform>(){

            public void customize(JList list, TargetPlatform value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentableText());
                this.setIcon(value.getIcon());
            }
        });
    }

    public static void initOutputTypeCombo(JComboBox outputTypeCombo) {
        outputTypeCombo.setModel(new DefaultComboBoxModel<OutputType>(OutputType.values()));
        outputTypeCombo.setRenderer(new ListCellRendererWrapper<OutputType>(){

            public void customize(JList list, OutputType value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentableText());
            }
        });
    }

    public static List<String> getThemes(Module module, FlexBuildConfiguration bc) {
        Sdk sdk = bc.getSdk();
        if (sdk == null) {
            return Collections.emptyList();
        }
        CompilerOptionInfo info = CompilerOptionInfo.getOptionInfo((String)"compiler.theme");
        String value = bc.getCompilerOptions().getOption(info.ID);
        if (value == null) {
            value = FlexBuildConfigurationManager.getInstance(module).getModuleLevelCompilerOptions().getOption(info.ID);
        }
        if (value == null) {
            value = FlexProjectLevelCompilerOptionsHolder.getInstance(module.getProject()).getProjectLevelCompilerOptions().getOption(info.ID);
        }
        if (value == null) {
            value = info.getDefaultValue(sdk.getVersionString(), bc.getNature(), bc.getDependencies().getComponentSet());
        }
        return value == null ? Collections.emptyList() : StringUtil.split((String)FlexUtils.replacePathMacros(value, module, sdk.getHomePath()), (String)"\n");
    }
}

