/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateHtmlWrapperTemplateDialog
extends DialogWrapper {
    public static final String HTML_TEMPLATE_FOLDER_NAME = "html-template";
    public static final String TITLE = FlexBundle.message("create.html.wrapper.template.title", new Object[0]);
    private static final String PLAYER_PRODUCT_INSTALL_SWF = "playerProductInstall.swf";
    private static final String USE_BROWSER_HISTORY_MACRO = "${useBrowserHistory}";
    private static final String EXPRESS_INSTALL_SWF_MACRO = "${expressInstallSwf}";
    private JPanel myMainPanel;
    private LabeledComponent<TextFieldWithBrowseButton> myWrapperFolderComponent;
    private JCheckBox myEnableHistoryCheckBox;
    private JCheckBox myCheckPlayerVersionCheckBox;
    private JCheckBox myExpressInstallCheckBox;
    private final Module myModule;
    @NotNull
    private final Sdk mySdk;
    private final String myOutputPath;

    public CreateHtmlWrapperTemplateDialog(Module module, @NotNull Sdk sdk, String outputPath, @Nullable String initialPath) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/projectStructure/ui/CreateHtmlWrapperTemplateDialog", "<init>"));
        }
        super(module.getProject());
        this.myModule = module;
        this.mySdk = sdk;
        this.myOutputPath = outputPath;
        this.$$$setupUI$$$();
        this.setInitialPath(module, initialPath);
        this.myCheckPlayerVersionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateHtmlWrapperTemplateDialog.this.myExpressInstallCheckBox.setEnabled(CreateHtmlWrapperTemplateDialog.this.myCheckPlayerVersionCheckBox.isSelected());
            }
        });
        ((TextFieldWithBrowseButton)this.myWrapperFolderComponent.getComponent()).addBrowseFolderListener(null, null, module.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.setTitle(TITLE);
        this.init();
    }

    private void setInitialPath(Module module, String initialPath) {
        if (initialPath != null) {
            ((TextFieldWithBrowseButton)this.myWrapperFolderComponent.getComponent()).setText(FileUtil.toSystemDependentName((String)initialPath));
        } else {
            String[] contentRootUrls = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
            String path = contentRootUrls.length > 0 ? FileUtil.toSystemDependentName((String)(VfsUtil.urlToPath((String)contentRootUrls[0]) + "/" + HTML_TEMPLATE_FOLDER_NAME)) : FileUtil.toSystemDependentName((String)(PathUtil.getParentPath((String)module.getModuleFilePath()) + "/" + HTML_TEMPLATE_FOLDER_NAME));
            ((TextFieldWithBrowseButton)this.myWrapperFolderComponent.getComponent()).setText(path);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return ((TextFieldWithBrowseButton)this.myWrapperFolderComponent.getComponent()).getTextField();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public String getWrapperFolderPath() {
        return FileUtil.toSystemIndependentName((String)((TextFieldWithBrowseButton)this.myWrapperFolderComponent.getComponent()).getText().trim());
    }

    protected ValidationInfo doValidate() {
        String path;
        String wrapperFolderPath = this.getWrapperFolderPath();
        for (String url : ModuleRootManager.getInstance((Module)this.myModule).getContentRootUrls()) {
            path = VfsUtil.urlToPath((String)url);
            if (!FileUtil.isAncestor((String)wrapperFolderPath, (String)path, (boolean)false)) continue;
            return new ValidationInfo(FlexBundle.message("html.wrapper.folder.clash.for.dialog", "module content root", FileUtil.toSystemDependentName((String)path)), this.myWrapperFolderComponent.getComponent());
        }
        for (String url : ModuleRootManager.getInstance((Module)this.myModule).getSourceRootUrls()) {
            path = VfsUtil.urlToPath((String)url);
            if (!FileUtil.isAncestor((String)wrapperFolderPath, (String)path, (boolean)false)) continue;
            return new ValidationInfo(FlexBundle.message("html.wrapper.folder.clash.for.dialog", "source folder", FileUtil.toSystemDependentName((String)path)), this.myWrapperFolderComponent.getComponent());
        }
        if (!this.myOutputPath.isEmpty() && FileUtil.isAncestor((String)wrapperFolderPath, (String)this.myOutputPath, (boolean)false)) {
            return new ValidationInfo(FlexBundle.message("html.wrapper.folder.clash.for.dialog", "output folder", FileUtil.toSystemDependentName((String)this.myOutputPath)), this.myWrapperFolderComponent.getComponent());
        }
        return null;
    }

    protected void doOKAction() {
        if (CreateHtmlWrapperTemplateDialog.createHtmlWrapperTemplate(this.myModule.getProject(), this.mySdk, this.getWrapperFolderPath(), this.myEnableHistoryCheckBox.isSelected(), this.myCheckPlayerVersionCheckBox.isSelected(), this.myExpressInstallCheckBox.isEnabled() && this.myExpressInstallCheckBox.isSelected())) {
            super.doOKAction();
        }
    }

    public static boolean createHtmlWrapperTemplate(Project project, Sdk sdk, String templateFolderPath, boolean enableHistory, boolean checkPlayerVersion, boolean expressInstall) {
        VirtualFile folder = FlexUtils.createDirIfMissing(project, true, templateFolderPath, TITLE);
        return folder != null && CreateHtmlWrapperTemplateDialog.checkIfEmpty(project, folder) && CreateHtmlWrapperTemplateDialog.doCreateWrapper(project, sdk, folder, enableHistory, checkPlayerVersion, expressInstall);
    }

    private static boolean checkIfEmpty(Project project, VirtualFile folder) {
        final VirtualFile[] children = folder.getChildren();
        if (children.length > 0) {
            String[] options = new String[]{FlexBundle.message("folder.not.empty.clear.option", new Object[0]), FlexBundle.message("folder.not.empty.keep.option", new Object[0]), FlexBundle.message("folder.not.empty.cancel.option", new Object[0])};
            int choice = Messages.showDialog((Project)project, (String)FlexBundle.message("folder.not.empty.clear.or.overwrite", new Object[0]), (String)TITLE, (String[])options, (int)0, (Icon)Messages.getWarningIcon());
            switch (choice) {
                case 0: {
                    IOException exception = (IOException)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<IOException>(){

                        public IOException compute() {
                            try {
                                for (VirtualFile child : children) {
                                    child.delete((Object)this);
                                }
                            }
                            catch (IOException e) {
                                return e;
                            }
                            return null;
                        }
                    });
                    if (exception != null) {
                        Messages.showErrorDialog((Project)project, (String)FlexBundle.message("failed.to.delete", exception.getMessage()), (String)TITLE);
                        return false;
                    }
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean doCreateWrapper(Project project, Sdk sdk, final VirtualFile folder, final boolean enableHistory, final boolean checkPlayerVersion, final boolean expressInstall) {
        String wrapperName;
        if (!FlexSdkUtils.isAirSdkWithoutFlex(sdk) && StringUtil.compareVersionNumbers((String)sdk.getVersionString(), (String)"4") < 0) {
            String prefix = checkPlayerVersion ? (expressInstall ? "express-installation" : "client-side-detection") : "no-player-detection";
            wrapperName = prefix + (enableHistory ? "-with-history" : "");
        } else {
            wrapperName = "swfobject";
        }
        String sdkTemplatePath = sdk.getHomePath() + "/templates/" + wrapperName;
        final VirtualFile sdkTemplateFolder = LocalFileSystem.getInstance().findFileByPath(sdkTemplatePath);
        if (sdkTemplateFolder == null || !sdkTemplateFolder.isDirectory()) {
            Messages.showErrorDialog((Project)project, (String)FlexBundle.message("html.wrapper.in.sdk.not.found", sdkTemplatePath), (String)TITLE);
            return false;
        }
        final boolean swfObjectWrapper = "swfobject".equals(sdkTemplateFolder.getName());
        IOException exception = (IOException)ApplicationManager.getApplication().runWriteAction((Computable)new NullableComputable<IOException>(){

            public IOException compute() {
                try {
                    for (VirtualFile file : sdkTemplateFolder.getChildren()) {
                        if (swfObjectWrapper) {
                            if ("index.template.html".equals(file.getName())) {
                                CreateHtmlWrapperTemplateDialog.fixAndCopyIndexTemplateHtml(file, folder, enableHistory, checkPlayerVersion, expressInstall);
                                continue;
                            }
                            if ("history".equals(file.getName()) ? !enableHistory : CreateHtmlWrapperTemplateDialog.PLAYER_PRODUCT_INSTALL_SWF.equals(file.getName()) && (!checkPlayerVersion || !expressInstall)) continue;
                            file.copy((Object)this, folder, file.getName());
                            continue;
                        }
                        file.copy((Object)this, folder, file.getName());
                    }
                }
                catch (IOException e) {
                    return e;
                }
                return null;
            }
        });
        if (exception != null) {
            Messages.showErrorDialog((Project)project, (String)FlexBundle.message("html.wrapper.creation.failed", exception.getMessage()), (String)TITLE);
            return false;
        }
        return true;
    }

    private static void fixAndCopyIndexTemplateHtml(VirtualFile file, VirtualFile folder, boolean enableHistory, boolean checkPlayerVersion, boolean expressInstall) throws IOException {
        String text = VfsUtilCore.loadText((VirtualFile)file);
        String useBrowserHistory = enableHistory ? "--" : USE_BROWSER_HISTORY_MACRO;
        String major = checkPlayerVersion ? "${version_major}" : "0";
        String minor = checkPlayerVersion ? "${version_minor}" : "0";
        String revision = checkPlayerVersion ? "${version_revision}" : "0";
        String expressInstallSwf = checkPlayerVersion && expressInstall ? PLAYER_PRODUCT_INSTALL_SWF : "";
        String fixedText = StringUtil.replace((String)text, (String[])new String[]{USE_BROWSER_HISTORY_MACRO, "${version_major}", "${version_minor}", "${version_revision}", EXPRESS_INSTALL_SWF_MACRO}, (String[])new String[]{useBrowserHistory, major, minor, revision, expressInstallSwf});
        FlexUtils.addFileWithContent(file.getName(), fixedText, folder);
    }

    protected String getHelpId() {
        return "flex.CreateHtmlWrapperTemplateDialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        LabeledComponent labeledComponent;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myWrapperFolderComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent.setText("Create HTML &wrapper template in the following folder");
        jPanel.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, new Dimension(400, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEnableHistoryCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(true);
        jCheckBox3.setText("Enable integration with browser navigation");
        jCheckBox3.setMnemonic('E');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCheckPlayerVersionCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Check Flash player version");
        jCheckBox2.setMnemonic('V');
        jCheckBox2.setDisplayedMnemonicIndex(19);
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExpressInstallCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Express install");
        jCheckBox.setMnemonic('X');
        jCheckBox.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

