/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.sdk;

import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.sdk.FlexSdkType2;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectJdksConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexSdkComboBoxWithBrowseButton
extends ComboboxWithBrowseButton {
    public static final Condition<Sdk> FLEX_SDK = sdk -> sdk != null && sdk.getSdkType() instanceof FlexSdkType2;
    public static final Condition<Sdk> FLEX_OR_FLEXMOJOS_SDK = sdk -> sdk != null && (sdk.getSdkType() instanceof FlexSdkType2 || sdk.getSdkType() instanceof FlexmojosSdkType);
    public static final String BC_SDK_KEY = "BC SDK";
    private final Condition<Sdk> mySdkFilter;
    private BCSdk myBCSdk = new BCSdk();
    private boolean myShowBCSdk = false;

    public FlexSdkComboBoxWithBrowseButton() {
        this(FLEX_SDK);
    }

    public FlexSdkComboBoxWithBrowseButton(Condition<Sdk> sdkFilter) {
        this.mySdkFilter = sdkFilter;
        this.rebuildSdkListAndSelectSdk(null);
        final JComboBox sdkCombo = this.getComboBox();
        sdkCombo.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof BCSdk) {
                    Sdk sdk = ((BCSdk)value).mySdk;
                    if (sdk == null) {
                        if (sdkCombo.isEnabled()) {
                            this.setText("<html>SDK set for the build configuration <font color='red'>[not set]</font></html>");
                            this.setIcon(null);
                        } else {
                            this.setText("SDK set for the build configuration [not set]");
                            this.setIcon(null);
                        }
                    } else {
                        this.setText("SDK set for the build configuration [" + sdk.getName() + "]");
                        this.setIcon(((SdkType)((BCSdk)value).mySdk.getSdkType()).getIcon());
                    }
                } else if (value instanceof String) {
                    if (sdkCombo.isEnabled()) {
                        this.setText("<html><font color='red'>" + value + " [Invalid]</font></html>");
                        this.setIcon(null);
                    } else {
                        this.setText(value + " [Invalid]");
                        this.setIcon(null);
                    }
                } else if (value instanceof Sdk) {
                    this.setText(((Sdk)value).getName());
                    this.setIcon(((SdkType)((Sdk)value).getSdkType()).getIcon());
                } else if (sdkCombo.isEnabled()) {
                    this.setText("<html><font color='red'>[none]</font></html>");
                } else {
                    this.setText("[none]");
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectJdksEditor editor;
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
                if (project == null) {
                    project = ProjectManager.getInstance().getDefaultProject();
                }
                FlexProjectConfigurationEditor currentFlexEditor = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor();
                ProjectSdksModel sdksModel = ProjectStructureConfigurable.getInstance((Project)project).getProjectJdksModel();
                if (currentFlexEditor != null) {
                    sdksModel = new NonCommittingWrapper(sdksModel, JdkListConfigurable.getInstance((Project)project));
                }
                if ((editor = new ProjectJdksEditor(null, (Component)((Object)FlexSdkComboBoxWithBrowseButton.this), new ProjectJdksConfigurable(project, sdksModel))).showAndGet()) {
                    Sdk selectedSdk = editor.getSelectedJdk();
                    if (FlexSdkComboBoxWithBrowseButton.this.mySdkFilter.value((Object)selectedSdk)) {
                        FlexSdkComboBoxWithBrowseButton.this.rebuildSdkListAndSelectSdk(selectedSdk);
                    } else {
                        FlexSdkComboBoxWithBrowseButton.this.rebuildSdkListAndSelectSdk(null);
                        if (selectedSdk != null) {
                            Messages.showErrorDialog((Component)((Object)FlexSdkComboBoxWithBrowseButton.this), (String)FlexBundle.message("sdk.can.not.be.selected", selectedSdk.getName()), (String)FlexBundle.message("select.flex.sdk", new Object[0]));
                        }
                    }
                }
            }
        });
    }

    private void rebuildSdkListAndSelectSdk(@Nullable Sdk selectedSdk) {
        Sdk[] sdks;
        String previousSelectedSdkName = this.getSelectedSdkRaw();
        ArrayList<BCSdk> sdkList = new ArrayList<BCSdk>();
        if (this.myShowBCSdk) {
            sdkList.add(this.myBCSdk);
        }
        for (Sdk sdk : sdks = FlexSdkUtils.getAllSdks()) {
            if (!this.mySdkFilter.value((Object)sdk)) continue;
            sdkList.add((BCSdk)sdk);
        }
        if (!sdkList.isEmpty()) {
            Collections.sort(sdkList, (sdk1, sdk2) -> {
                if (sdk1 == this.myBCSdk && sdk2 != this.myBCSdk) {
                    return -1;
                }
                if (sdk1 != this.myBCSdk && sdk2 == this.myBCSdk) {
                    return 1;
                }
                if (sdk1 instanceof Sdk && sdk2 instanceof Sdk) {
                    SdkTypeId type2;
                    SdkTypeId type1 = ((Sdk)sdk1).getSdkType();
                    if (type1 == (type2 = ((Sdk)sdk2).getSdkType())) {
                        return -StringUtil.compareVersionNumbers((String)((Sdk)sdk1).getVersionString(), (String)((Sdk)sdk2).getVersionString());
                    }
                    if (type1 == FlexSdkType2.getInstance()) {
                        return -1;
                    }
                    if (type2 == FlexSdkType2.getInstance()) {
                        return 1;
                    }
                }
                return 0;
            });
            this.getComboBox().setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(sdkList)));
            if (selectedSdk != null) {
                this.setSelectedSdkRaw(selectedSdk.getName(), false);
            } else if (previousSelectedSdkName != null) {
                this.setSelectedSdkRaw(previousSelectedSdkName, false);
            }
        } else {
            this.getComboBox().setModel(new DefaultComboBoxModel<Object>(new Object[]{null}));
        }
    }

    public void addComboboxListener(final Listener listener) {
        this.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.stateChanged();
            }
        });
        this.getComboBox().addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                listener.stateChanged();
            }
        });
    }

    @Nullable
    public Sdk getSelectedSdk() {
        Object selectedItem = this.getComboBox().getSelectedItem();
        if (selectedItem instanceof BCSdk) {
            return ((BCSdk)selectedItem).mySdk;
        }
        if (selectedItem instanceof Sdk) {
            return (Sdk)selectedItem;
        }
        return null;
    }

    public String getSelectedSdkRaw() {
        Object selectedItem = this.getComboBox().getSelectedItem();
        if (selectedItem instanceof BCSdk) {
            return BC_SDK_KEY;
        }
        if (selectedItem instanceof Sdk) {
            return ((Sdk)selectedItem).getName();
        }
        if (selectedItem instanceof String) {
            return (String)selectedItem;
        }
        return "";
    }

    public void setSelectedSdkRaw(String sdkName) {
        this.setSelectedSdkRaw(sdkName, true);
    }

    private void setSelectedSdkRaw(String sdkName, boolean addErrorItemIfSdkNotFound) {
        JComboBox combo = this.getComboBox();
        if (BC_SDK_KEY.equals(sdkName)) {
            combo.setSelectedItem(this.myBCSdk);
            return;
        }
        for (int i = 0; i < combo.getItemCount(); ++i) {
            Object item = combo.getItemAt(i);
            if (!(item instanceof Sdk) || !((Sdk)item).getName().equals(sdkName)) continue;
            combo.setSelectedItem(item);
            return;
        }
        if (addErrorItemIfSdkNotFound) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(sdkName);
            for (int i = 0; i < combo.getItemCount(); ++i) {
                Object item = combo.getItemAt(i);
                if (item instanceof String) continue;
                items.add((String)item);
            }
            combo.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(items)));
        }
    }

    public void showBCSdk(boolean showBCSdk) {
        if (this.myShowBCSdk != showBCSdk) {
            this.myShowBCSdk = showBCSdk;
            Object selectedItem = this.getComboBox().getSelectedItem();
            this.rebuildSdkListAndSelectSdk(null);
            if (selectedItem instanceof String) {
                this.setSelectedSdkRaw((String)selectedItem, true);
            }
        }
    }

    public void setBCSdk(Sdk sdk) {
        if (sdk != this.myBCSdk.mySdk) {
            this.myBCSdk.mySdk = sdk;
        }
    }

    private static class NonCommittingWrapper
    extends ProjectSdksModel {
        private final ProjectSdksModel myOriginal;
        private JdkListConfigurable myConfigurable;

        public NonCommittingWrapper(ProjectSdksModel original, JdkListConfigurable configurable) {
            this.myOriginal = original;
            this.myConfigurable = configurable;
        }

        public void apply() throws ConfigurationException {
            this.apply(null);
        }

        public void apply(@Nullable MasterDetailsComponent configurable) throws ConfigurationException {
            this.myConfigurable.reset();
        }

        public void reset(@Nullable Project project) {
        }

        public void addListener(SdkModel.Listener listener) {
            this.myOriginal.addListener(listener);
        }

        public void removeListener(SdkModel.Listener listener) {
            this.myOriginal.removeListener(listener);
        }

        public SdkModel.Listener getMulticaster() {
            return this.myOriginal.getMulticaster();
        }

        public Sdk[] getSdks() {
            return this.myOriginal.getSdks();
        }

        public Sdk findSdk(String sdkName) {
            return this.myOriginal.findSdk(sdkName);
        }

        public void disposeUIResources() {
        }

        public HashMap<Sdk, Sdk> getProjectSdks() {
            return this.myOriginal.getProjectSdks();
        }

        public boolean isModified() {
            return this.myOriginal.isModified();
        }

        public void removeSdk(Sdk editableObject) {
            this.myOriginal.removeSdk(editableObject);
        }

        public void createAddActions(@NotNull DefaultActionGroup group, @NotNull JComponent parent, @NotNull Consumer<Sdk> updateTree, @Nullable Condition<SdkTypeId> filter) {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/lang/javascript/flex/sdk/FlexSdkComboBoxWithBrowseButton$NonCommittingWrapper", "createAddActions"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/flex/sdk/FlexSdkComboBoxWithBrowseButton$NonCommittingWrapper", "createAddActions"));
            }
            if (updateTree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateTree", "com/intellij/lang/javascript/flex/sdk/FlexSdkComboBoxWithBrowseButton$NonCommittingWrapper", "createAddActions"));
            }
            this.myOriginal.createAddActions(group, parent, updateTree, filter);
        }

        public void doAdd(@NotNull JComponent parent, @NotNull SdkType type, @NotNull Consumer<Sdk> updateTree) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/flex/sdk/FlexSdkComboBoxWithBrowseButton$NonCommittingWrapper", "doAdd"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/flex/sdk/FlexSdkComboBoxWithBrowseButton$NonCommittingWrapper", "doAdd"));
            }
            if (updateTree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateTree", "com/intellij/lang/javascript/flex/sdk/FlexSdkComboBoxWithBrowseButton$NonCommittingWrapper", "doAdd"));
            }
            this.myOriginal.doAdd(parent, type, updateTree);
        }

        public void addSdk(Sdk sdk) {
            this.myOriginal.addSdk(sdk);
        }

        public void doAdd(Sdk newSdk, @Nullable Consumer<Sdk> updateTree) {
            this.myOriginal.doAdd(newSdk, updateTree);
        }

        public Sdk findSdk(@Nullable Sdk modelJdk) {
            return this.myOriginal.findSdk(modelJdk);
        }

        public Sdk getProjectSdk() {
            return this.myOriginal.getProjectSdk();
        }

        public void setProjectSdk(Sdk projectSdk) {
            this.myOriginal.setProjectSdk(projectSdk);
        }

        public boolean isInitialized() {
            return this.myOriginal.isInitialized();
        }
    }

    private static class BCSdk {
        private Sdk mySdk;

        private BCSdk() {
        }
    }

    public static interface Listener {
        public void stateChanged();
    }
}

