/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CreateFieldByMxmlAttributeFix
extends CreateJSVariableIntentionAction {
    private final String myAttributeValue;

    public CreateFieldByMxmlAttributeFix(String referencedName, String attributeValue) {
        super(referencedName, true, false);
        this.myAttributeValue = attributeValue;
    }

    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        template.addTextSegment("public ");
        template.addTextSegment("var ");
        template.addTextSegment(this.myReferencedName);
        template.addEndVariable();
        template.addTextSegment(":");
        CreateFieldByMxmlAttributeFix.addTypeVariableByMxmlAttributeValue(template, this.myAttributeValue);
        this.addSemicolonSegment(template, file);
    }

    protected static void addTypeVariableByMxmlAttributeValue(Template template, String attributeValue) {
        template.addVariable((Expression)new BaseCreateFix.MyExpression(CreateFieldByMxmlAttributeFix.guessMxmlAttributeType(attributeValue)), true);
    }

    @NotNull
    private static String guessMxmlAttributeType(String attributeValue) {
        String string;
        block11: {
            if (StringUtil.isEmpty((String)attributeValue)) {
                if ("String" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateFieldByMxmlAttributeFix", "guessMxmlAttributeType"));
                }
                return "String";
            }
            if ("true".equals(attributeValue) || "false".equals(attributeValue)) {
                if ("Boolean" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateFieldByMxmlAttributeFix", "guessMxmlAttributeType"));
                }
                return "Boolean";
            }
            if (attributeValue.length() > 2 && attributeValue.startsWith("0x")) {
                Long.parseLong(attributeValue.substring(2), 16);
                if ("uint" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateFieldByMxmlAttributeFix", "guessMxmlAttributeType"));
                }
                return "uint";
            }
            try {
                Integer.parseInt(attributeValue);
                string = "int";
                if ("int" != null) break block11;
            }
            catch (NumberFormatException numberFormatException) {
                String string2;
                block12: {
                    try {
                        Double.parseDouble(attributeValue);
                        string2 = "Number";
                        if ("Number" != null) break block12;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if ("String" == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateFieldByMxmlAttributeFix", "guessMxmlAttributeType"));
                        }
                        return "String";
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateFieldByMxmlAttributeFix", "guessMxmlAttributeType"));
                }
                return string2;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateFieldByMxmlAttributeFix", "guessMxmlAttributeType"));
        }
        return string;
    }
}

