/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateFieldByMxmlAttributeFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSPropertyAccessorIntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public class CreateSetterByMxmlAttributeFix
extends CreateJSPropertyAccessorIntentionAction {
    private String myReferencedName;
    private final String myAttributeValue;

    public CreateSetterByMxmlAttributeFix(String referencedName, String attributeValue) {
        super(referencedName, false);
        this.myReferencedName = referencedName;
        this.myAttributeValue = attributeValue;
    }

    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        template.addTextSegment("public ");
        this.writeFunctionAndName(template, this.myReferencedName, file, null, referenceExpression);
        template.addTextSegment("(");
        template.addTextSegment(this.myReferencedName + ":");
        CreateFieldByMxmlAttributeFix.addTypeVariableByMxmlAttributeValue(template, this.myAttributeValue);
        template.addTextSegment(")");
        template.addTextSegment(":");
        this.addReturnType(template, referenceExpression, file);
        JSClass clazz = CreateSetterByMxmlAttributeFix.findClass((PsiElement)anchorParent);
        if (clazz == null || !clazz.isInterface()) {
            template.addTextSegment(" {");
            this.addBody(template, file);
            template.addTextSegment("}");
        } else {
            this.addSemicolonSegment(template, file);
            template.addEndVariable();
        }
    }

    private void addBody(Template template, PsiFile file) {
        String varName;
        String paramName = varName = this.myReferencedName;
        if ((varName = JSRefactoringUtil.transformAccessorNameToPropertyName((String)varName, (Project)file.getProject())).equals(paramName)) {
            varName = StringUtil.fixVariableNameDerivedFromPropertyName((String)varName);
        }
        CreateSetterByMxmlAttributeFix.addVarName(template, varName);
        template.addEndVariable();
        template.addTextSegment(" = " + paramName);
        this.addSemicolonSegment(template, file);
    }
}

