/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.ApplicableStreamProvider;
import com.intellij.cloudConfig.NetworkStatistics;
import com.intellij.cloudConfig.StatusBarInfoManager;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.cloudConfig.StreamProviderKt;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StateStorageBaseKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.idea.cloudConfig.ETagCloudConfigFileClient;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigManager
implements ApplicationLoadListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cloudConfig.CloudConfigManager");
    private static final String LOCAL_DISABLED_PLUGINS_FILENAME = "local_disabled_plugins.txt";
    private static CloudConfigManager ourInstance;
    private File myIdeConfigPath;
    private File myConfigDir;
    private File myCachesDir;
    private File myFilesArchive;
    private File myUpdatesArchive;
    private File myStatusFile;
    private File myAutoUpdatePluginsFile;
    private StatusInfo myStatusInfo;
    private ETagCloudConfigFileClient myClient;
    private boolean myIOError;
    private LocalChanges myLocalChanges;
    private final NetworkStatistics myNetworkStatistics = new NetworkStatistics();
    private StatusBarInfoManager myStatusBarManager;
    private FrameStateListener myFrameListener;
    private Runnable myDisablePluginsListener;
    private PluginStateListener myPluginListener;
    private List<IdeaPluginDescriptor> myNotDisabled = Collections.emptyList();
    private List<IdeaPluginDescriptor> myNotInstalled = Collections.emptyList();
    private boolean myBeforeApplicationLoadedStart;
    private boolean mySavePluginsWithEditConfigs = true;
    private String myOnServerMachineId;
    private String myOnServerMachineMinusId;
    private String myOnServerMachinePlusId;
    private boolean myAutoUpdatePlugins;
    private static final Function2<Class, String, String> KEYMAP_CONVERTER;
    private static List<IdeaPluginDescriptor> myRepositoryPlugins;
    private static final String[] OS_NAMES;

    @NotNull
    public static CloudConfigManager getInstance() {
        CloudConfigManager cloudConfigManager = ourInstance;
        if (cloudConfigManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getInstance"));
        }
        return cloudConfigManager;
    }

    @NotNull
    public StatusInfo getStatusInfo() {
        if (this.myIOError) {
            StatusInfo statusInfo = StatusInfo.JBA_IO_ERROR;
            if (statusInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
            }
            return statusInfo;
        }
        if (this.myStatusInfo != StatusInfo.OFFLINE && this.myStatusInfo != StatusInfo.JBA_CONNECTED && CloudConfigManager.isStreamProviderEnabled()) {
            StatusInfo statusInfo = StatusInfo.OFFLINE;
            if (statusInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
            }
            return statusInfo;
        }
        StatusInfo statusInfo = this.myStatusInfo;
        if (statusInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStatusInfo"));
        }
        return statusInfo;
    }

    public boolean isAutoUpdatePlugins() {
        return this.myAutoUpdatePlugins;
    }

    public void setAutoUpdatePlugins(boolean value) {
        boolean update = this.myAutoUpdatePlugins != value;
        this.myAutoUpdatePlugins = value;
        if (update) {
            this.storeAutoUpdatePlugins();
            if (value) {
                this.executePlugins();
            }
        }
    }

    @NotNull
    public List<IdeaPluginDescriptor> getNotDisabledPlugins() {
        List<IdeaPluginDescriptor> list = this.myNotDisabled;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getNotDisabledPlugins"));
        }
        return list;
    }

    public boolean hasPluginsUpdate() {
        return !this.myNotDisabled.isEmpty() || !this.myNotInstalled.isEmpty();
    }

    @NotNull
    public List<IdeaPluginDescriptor> getNotInstalledPlugins() {
        List<IdeaPluginDescriptor> list = this.myNotInstalled;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getNotInstalledPlugins"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeApplicationLoaded(@NotNull Application application, @NotNull String configPath) {
        block20: {
            if (application == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/intellij/cloudConfig/CloudConfigManager", "beforeApplicationLoaded"));
            }
            if (configPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/cloudConfig/CloudConfigManager", "beforeApplicationLoaded"));
            }
            ourInstance = this;
            StatusBarInfoManager statusBarInfoManager = this.myStatusBarManager = application.isUnitTestMode() ? StatusBarInfoManager.EMPTY : new StatusBarInfoManager();
            if (!Boolean.getBoolean("use.jba.cloud.config") || CloudConfigManager.isStreamProviderEnabled()) {
                this.myStatusInfo = StatusInfo.OFFLINE;
                return;
            }
            this.myIdeConfigPath = new File(configPath);
            this.myConfigDir = new File(configPath, "jba_config");
            this.myCachesDir = new File(this.myConfigDir, "caches");
            this.myFilesArchive = new File(this.myCachesDir, "files.7z");
            this.myUpdatesArchive = new File(this.myCachesDir, "updates.7z");
            this.myStatusFile = new File(this.myConfigDir, "status.info");
            this.myAutoUpdatePluginsFile = new File(this.myConfigDir, "auto_update_plugins");
            this.myLocalChanges = new LocalChanges();
            try {
                this.myStatusInfo = StatusInfo.valueOf(FileUtil.loadFile((File)this.myStatusFile));
                if (this.myStatusInfo == StatusInfo.DISABLED) {
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.myAutoUpdatePlugins = "1".equals(FileUtil.loadFile((File)this.myAutoUpdatePluginsFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.myClient = CloudConfigClientUtil.createClient();
            if (this.myClient == null) {
                this.myStatusInfo = StatusInfo.JBA_NOT_FOUND;
                return;
            }
            try {
                this.myBeforeApplicationLoadedStart = true;
                File autoConnect = new File(this.myConfigDir, ".auto_connect");
                if (autoConnect.exists()) {
                    boolean remote = false;
                    try {
                        remote = "remote".equals(FileUtil.loadFile((File)autoConnect));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    FileUtil.delete((File)autoConnect);
                    if (remote) {
                        this.connectThisInstance(false, true);
                    } else {
                        this.connectFirstInstance(true);
                    }
                    break block20;
                }
                if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                    this.myLocalChanges.load();
                    this.updateConnection(true);
                } else {
                    this.calculateInitStatus();
                }
            }
            finally {
                this.myBeforeApplicationLoadedStart = false;
            }
        }
        LOG.info("=== Start: " + (Object)((Object)this.myStatusInfo) + " ===");
    }

    public void recalculateInitStatus() {
        if (this.myStatusInfo == StatusInfo.DISABLED && this.myClient == null) {
            this.myClient = CloudConfigClientUtil.createClient();
            LOG.assertTrue(this.myClient != null);
        }
        this.calculateInitStatus();
        if (this.myStatusInfo != StatusInfo.DISABLED) {
            FileUtil.delete((File)this.myStatusFile);
        }
    }

    private void calculateInitStatus() {
        try {
            this.myStatusInfo = this.list("").contains("files.7z") ? StatusInfo.JBA_THIS_NOT_CONNECTED : StatusInfo.JBA_NOT_CONNECTED;
            this.updateStatusBar(true);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    @Nullable
    public StatusInfo updateIO() {
        if (!this.checkIO()) {
            return null;
        }
        if (this.myStatusInfo == null) {
            this.calculateInitStatus();
        } else if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
            this.updateConnection(false);
        }
        return this.myStatusInfo;
    }

    private boolean checkIO() {
        try {
            this.list("io");
            return true;
        }
        catch (IOException e) {
            CloudConfigManager.logDebug(e);
            return false;
        }
    }

    public void disable() {
        this.myStatusInfo = StatusInfo.DISABLED;
        this.myIOError = false;
        if (this.myClient != null) {
            this.myClient.clearTags();
            this.myClient = null;
        }
        this.storeState();
        this.updateStatusBar(false);
    }

    public void disconnect(boolean removeData) {
        this.removeListeners();
        if (!removeData) {
            this.removeThisConnection();
        }
        this.disconnect(removeData, true);
    }

    public void removeThisConnection() {
        try {
            LinkedHashSet<File> index = new LinkedHashSet<File>();
            this.removePlugins("disabled_plugins.txt", index);
            this.removePlugins("installed_plugins.txt", index);
            this.removeMachineId(index);
            this.writeUpdates(index);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void testDisconnect(boolean removeData) {
        this.disconnect(removeData, false);
    }

    private void disconnect(boolean removeData, boolean reload) {
        try {
            this.removeListeners();
            this.myOnServerMachinePlusId = null;
            this.myOnServerMachineMinusId = null;
            this.myOnServerMachineId = null;
            this.myNotInstalled = Collections.emptyList();
            this.myNotDisabled = this.myNotInstalled;
            this.myLocalChanges.clean();
            if (removeData) {
                this.myClient.delete(CloudConfigClientUtil.getName() + "files.7z");
                this.myClient.delete(CloudConfigClientUtil.getName() + "updates.7z");
                this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
            } else {
                this.myStatusInfo = StatusInfo.JBA_THIS_NOT_CONNECTED;
            }
            this.myClient.clearTags();
            FileUtil.delete((File)this.myConfigDir);
            this.setStreamProvider(true, reload);
            this.updateStatusBar(false);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private ConnectionState getConnectionState() {
        block12: {
            block11: {
                Boolean newVersion;
                block10: {
                    ConnectionState connectionState;
                    try {
                        newVersion = this.getFile("files.7z");
                        if (newVersion != null) break block10;
                        connectionState = ConnectionState.DELETE;
                    }
                    catch (IOException e) {
                        CloudConfigManager.logDebug(e);
                        ConnectionState connectionState2 = ConnectionState.IO_ERROR;
                        if (connectionState2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
                        }
                        return connectionState2;
                    }
                    if (connectionState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
                    }
                    return connectionState;
                }
                if (!newVersion.booleanValue()) break block11;
                ConnectionState connectionState = ConnectionState.NEW;
                if (connectionState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
                }
                return connectionState;
            }
            if (this.getFile("updates.7z") != Boolean.TRUE) break block12;
            ConnectionState connectionState = ConnectionState.UPDATE;
            if (connectionState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
            }
            return connectionState;
        }
        ConnectionState connectionState = ConnectionState.OLD;
        if (connectionState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getConnectionState"));
        }
        return connectionState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateConnection(boolean provider) {
        try {
            switch (this.getConnectionState()) {
                case OLD: 
                case IO_ERROR: {
                    if (!provider) return;
                    this.loadMachineId();
                    this.setStreamProvider(false, false);
                    return;
                }
                case NEW: {
                    this.connectThisInstance(!provider, true);
                    return;
                }
                case UPDATE: {
                    CloudConfigManager.getStateStorageManager().setStreamProvider((StreamProvider)new ApplicableStreamProvider(this.myConfigDir, this));
                    this.updateFiles(!provider);
                    this.loadMachineId();
                    this.initListeners();
                    return;
                }
                case DELETE: {
                    this.disconnect(false, !provider);
                    this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
                    this.updateStatusBar(false);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return;
        }
        finally {
            this.myLocalChanges.apply();
        }
    }

    public void connectFirstInstance(boolean cleanup) {
        try {
            FileUtil.delete((File)this.myConfigDir);
            FileUtil.createDirectory((File)this.myConfigDir);
            ApplicationManager.getApplication().saveSettings();
            this.myLocalChanges.clean();
            this.myClient.clearTags();
            Set<File> index = this.copyConfigs(KEYMAP_CONVERTER, LafManagerImpl.class, KeymapManagerImpl.class, EditorColorsManagerImpl.class);
            this.addPlugins(index);
            this.createMachineId(index);
            this.addToFile(index, "os", CloudConfigClientUtil.getOS());
            this.addToFile(index, "version", "0");
            this.pushToServer(index, cleanup);
            this.setStreamProvider(false, false);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void loadMachineId() throws Exception {
        File idLocalFile = new File(this.myConfigDir, "id_local");
        List localIds = FileUtil.loadLines((File)idLocalFile);
        assert (localIds.size() == 2);
        String oldLocalId = (String)localIds.get(0);
        String newLocalId = PermanentInstallationID.get();
        this.myOnServerMachineId = (String)localIds.get(1);
        this.myOnServerMachineMinusId = "-" + this.myOnServerMachineId;
        this.myOnServerMachinePlusId = "+" + this.myOnServerMachineId;
        if (!newLocalId.equals(oldLocalId)) {
            FileUtil.writeToFile((File)idLocalFile, (String)(newLocalId + "\n" + this.myOnServerMachineId));
            List ids = FileUtil.loadLines((File)new File(this.myConfigDir, "id_list"));
            int index = ids.indexOf(oldLocalId);
            assert (index != -1);
            ids.set(index, newLocalId);
            String content = StringUtil.join((Collection)ids, (String)"\n");
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            this.addToFile(files, "id_list", content);
            this.writeUpdates(files);
        }
    }

    private void createMachineId(@NotNull Set<File> index) throws Exception {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "createMachineId"));
        }
        this.myOnServerMachineId = "0";
        this.myOnServerMachineMinusId = "-0";
        this.myOnServerMachinePlusId = "+0";
        String content = PermanentInstallationID.get() + "\n0";
        this.addToFile(index, "id_list", content);
        FileUtil.writeToFile((File)new File(this.myConfigDir, "id_local"), (String)content);
    }

    private void addMachineId(@NotNull Set<File> index) throws Exception {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "addMachineId"));
        }
        this.myOnServerMachinePlusId = null;
        this.myOnServerMachineMinusId = null;
        this.myOnServerMachineId = null;
        String localId = PermanentInstallationID.get();
        File idListFile = new File(this.myConfigDir, "id_list");
        List idList = idListFile.exists() ? FileUtil.loadLines((File)idListFile) : new ArrayList();
        int maxServerId = -1;
        int size = idList.size();
        for (int i = 0; i < size; i += 2) {
            if (localId.equals(idList.get(i))) {
                this.myOnServerMachineId = (String)idList.get(i + 1);
                break;
            }
            maxServerId = Math.max(maxServerId, Integer.parseInt((String)idList.get(i + 1)));
        }
        if (this.myOnServerMachineId == null) {
            this.myOnServerMachineId = Integer.toString(maxServerId + 1);
            idList.add(localId);
            idList.add(this.myOnServerMachineId);
            this.addToFile(index, "id_list", StringUtil.join((Collection)idList, (String)"\n"));
        }
        this.myOnServerMachineMinusId = "-" + this.myOnServerMachineId;
        this.myOnServerMachinePlusId = "+" + this.myOnServerMachineId;
        FileUtil.writeToFile((File)new File(this.myConfigDir, "id_local"), (String)(localId + "\n" + this.myOnServerMachineId));
    }

    private void removeMachineId(@NotNull Set<File> files) throws IOException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/cloudConfig/CloudConfigManager", "removeMachineId"));
        }
        List idList = FileUtil.loadLines((File)new File(this.myConfigDir, "id_list"));
        int index = idList.indexOf(PermanentInstallationID.get());
        if (index != -1) {
            idList.remove(index + 1);
            idList.remove(index);
            this.addToFile(files, "id_list", StringUtil.join((Collection)idList, (String)"\n"));
        }
    }

    private void addToFile(@NotNull Set<File> index, @NotNull String name, @NotNull String content) throws IOException {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "addToFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "addToFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/cloudConfig/CloudConfigManager", "addToFile"));
        }
        File file = new File(this.myConfigDir, name);
        FileUtil.writeToFile((File)file, (String)content);
        index.add(file);
    }

    private void initListeners() {
        if (this.myFrameListener == null) {
            this.myFrameListener = new FrameStateListener(){
                long time;

                public void onFrameDeactivated() {
                    this.time = System.currentTimeMillis();
                }

                public void onFrameActivated() {
                    if (CloudConfigManager.this.myStatusInfo == StatusInfo.JBA_CONNECTED && System.currentTimeMillis() - this.time > 3600000L) {
                        CloudConfigManager.this.updateConnection(false);
                    }
                }
            };
            FrameStateManager.getInstance().addListener(this.myFrameListener);
        }
        if (this.myDisablePluginsListener == null) {
            this.myDisablePluginsListener = () -> {
                try {
                    File localFile = new File(this.myConfigDir, LOCAL_DISABLED_PLUGINS_FILENAME);
                    LinkedHashSet oldPlugins = new LinkedHashSet(FileUtil.loadLines((File)localFile));
                    File sourceFile = new File(this.myIdeConfigPath, "disabled_plugins.txt");
                    LinkedHashSet newPlugins = new LinkedHashSet(FileUtil.loadLines((File)sourceFile));
                    Iterator I = newPlugins.iterator();
                    while (I.hasNext()) {
                        if (!oldPlugins.remove(I.next())) continue;
                        I.remove();
                    }
                    if (oldPlugins.isEmpty() && newPlugins.isEmpty()) {
                        return;
                    }
                    FileUtil.copyContent((File)sourceFile, (File)localFile);
                    List<Pair<String, String>> plugins = this.loadPlugins("disabled_plugins.txt");
                    boolean update = false;
                    for (String deletedPluginId : oldPlugins) {
                        update |= this.removePlugin(plugins, deletedPluginId);
                    }
                    for (String newPluginId : newPlugins) {
                        update |= this.addPlugin(plugins, newPluginId);
                    }
                    if (update) {
                        this.savePlugins(plugins, "disabled_plugins.txt");
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            };
            PluginManagerCore.addDisablePluginListener((Runnable)this.myDisablePluginsListener);
        }
        if (this.myPluginListener == null) {
            this.myPluginListener = new PluginStateListener(){

                public void install(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/cloudConfig/CloudConfigManager$2", "install"));
                    }
                    try {
                        if (descriptor.isBundled()) {
                            return;
                        }
                        String pluginId = descriptor.getPluginId().getIdString();
                        if (ContainerUtil.find((Iterable)CloudConfigManager.getRepositoryPlugins(), remote -> remote.getPluginId().getIdString().equals(pluginId)) == null) {
                            return;
                        }
                        List plugins = CloudConfigManager.this.loadPlugins("installed_plugins.txt");
                        if (CloudConfigManager.this.addPlugin(plugins, pluginId)) {
                            CloudConfigManager.this.savePlugins(plugins, "installed_plugins.txt");
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }

                public void uninstall(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/cloudConfig/CloudConfigManager$2", "uninstall"));
                    }
                    try {
                        List plugins = CloudConfigManager.this.loadPlugins("installed_plugins.txt");
                        if (CloudConfigManager.this.removePlugin(plugins, descriptor.getPluginId().getIdString())) {
                            CloudConfigManager.this.savePlugins(plugins, "installed_plugins.txt");
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            };
            PluginInstaller.addStateListener((PluginStateListener)this.myPluginListener);
        }
    }

    @NotNull
    private List<Pair<String, String>> loadPlugins(String name) throws IOException {
        ArrayList<Pair<String, String>> arrayList;
        try {
            List lines = FileUtil.loadLines((File)new File(this.myConfigDir, name));
            ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
            int size = lines.size();
            for (int i = 0; i < size; i += 2) {
                result.add((Pair<String, String>)Pair.create(lines.get(i), lines.get(i + 1)));
            }
            arrayList = result;
        }
        catch (FileNotFoundException e) {
            ArrayList<Pair<String, String>> arrayList2 = new ArrayList<Pair<String, String>>();
            if (arrayList2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "loadPlugins"));
            }
            return arrayList2;
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "loadPlugins"));
        }
        return arrayList;
    }

    private void savePlugins(@NotNull List<Pair<String, String>> plugins, @NotNull String name, @NotNull Set<File> files) throws Exception {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        files.add(this.savePluginsToFile(plugins, name));
    }

    private void savePlugins(@NotNull List<Pair<String, String>> plugins, @NotNull String name) throws Exception {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "savePlugins"));
        }
        this.savePluginsToFile(plugins, name);
        if (this.mySavePluginsWithEditConfigs) {
            this.editConfigFiles(name);
        }
    }

    @NotNull
    private File savePluginsToFile(@NotNull List<Pair<String, String>> plugins, @NotNull String name) throws Exception {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "savePluginsToFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "savePluginsToFile"));
        }
        String content = StringUtil.join(plugins, p -> (String)p.first + "\n" + (String)p.second, (String)"\n");
        File file = new File(this.myConfigDir, name);
        FileUtil.writeToFile((File)file, (String)content);
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "savePluginsToFile"));
        }
        return file2;
    }

    private boolean addPlugin(@NotNull List<Pair<String, String>> plugins, @NotNull String pluginId) {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "addPlugin"));
        }
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "addPlugin"));
        }
        Pair result = (Pair)ContainerUtil.find(plugins, p -> {
            if (pluginId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "lambda$addPlugin$3"));
            }
            return ((String)p.first).equals(pluginId);
        });
        if (result == null) {
            plugins.add((Pair<String, String>)Pair.create((Object)pluginId, (Object)this.myOnServerMachineId));
        } else {
            List ids = StringUtil.split((String)((String)result.second), (String)",");
            if (ids.contains(this.myOnServerMachineId)) {
                return false;
            }
            ids.remove(this.myOnServerMachineMinusId);
            ids.remove(this.myOnServerMachinePlusId);
            ids.add(this.myOnServerMachineId);
            plugins.set(plugins.indexOf(result), (Pair<String, String>)Pair.create((Object)result.first, (Object)StringUtil.join((Collection)ids, (String)",")));
        }
        return true;
    }

    private boolean removePlugin(@NotNull List<Pair<String, String>> plugins, @NotNull String pluginId) {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/cloudConfig/CloudConfigManager", "removePlugin"));
        }
        if (pluginId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "removePlugin"));
        }
        Pair result = (Pair)ContainerUtil.find(plugins, p -> {
            if (pluginId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/cloudConfig/CloudConfigManager", "lambda$removePlugin$4"));
            }
            return ((String)p.first).equals(pluginId);
        });
        if (result == null) {
            return false;
        }
        if (((String)result.second).equals(this.myOnServerMachineId)) {
            plugins.remove(result);
        } else {
            List ids = StringUtil.split((String)((String)result.second), (String)",");
            ids.set(ids.indexOf(this.myOnServerMachineId), this.myOnServerMachineMinusId);
            if (ids.stream().allMatch(id -> id.startsWith("-"))) {
                plugins.remove(result);
            } else {
                plugins.set(plugins.indexOf(result), (Pair<String, String>)Pair.create((Object)result.first, (Object)StringUtil.join((Collection)ids, (String)",")));
            }
        }
        return true;
    }

    private void removeListeners() {
        if (this.myFrameListener != null) {
            FrameStateManager.getInstance().removeListener(this.myFrameListener);
            this.myFrameListener = null;
        }
        if (this.myDisablePluginsListener != null) {
            PluginManagerCore.removeDisablePluginListener((Runnable)this.myDisablePluginsListener);
            this.myDisablePluginsListener = null;
        }
        if (this.myPluginListener != null) {
            PluginInstaller.removeStateListener((PluginStateListener)this.myPluginListener);
            this.myPluginListener = null;
        }
    }

    public void connectThisInstance(boolean reload, boolean saveCaches) {
        try {
            if (saveCaches) {
                File[] files = this.myConfigDir.listFiles();
                LOG.assertTrue(files != null);
                for (File file : files) {
                    if ("caches".equals(file.getName())) continue;
                    FileUtil.delete((File)file);
                }
            } else {
                FileUtil.delete((File)this.myConfigDir);
                FileUtil.createDirectory((File)this.myConfigDir);
            }
            this.myLocalChanges.clean();
            LOG.assertTrue(this.getFile("files.7z") != null);
            CloudConfigManager.extractArchive(this.myFilesArchive, this.myConfigDir, false);
            if (this.getFile("updates.7z") != null) {
                CloudConfigManager.extractArchive(this.myUpdatesArchive, this.myConfigDir, true);
            }
            LinkedHashSet<File> index = new LinkedHashSet<File>();
            File osFile = new File(this.myConfigDir, "os");
            LOG.assertTrue(osFile.exists());
            List osNames = FileUtil.loadLines((File)osFile);
            String os = CloudConfigClientUtil.getOS();
            if (!osNames.contains(os)) {
                index.addAll(this.copyConfigs(KEYMAP_CONVERTER, KeymapManagerImpl.class));
                osNames.add(os);
                this.addToFile(index, "os", StringUtil.join((Collection)osNames, (String)"\n"));
            }
            this.addMachineId(index);
            FileUtil.copyContent((File)new File(this.myIdeConfigPath, "disabled_plugins.txt"), (File)new File(this.myConfigDir, LOCAL_DISABLED_PLUGINS_FILENAME));
            this.mergePlugins(this.getDisabledPlugins(), "disabled_plugins.txt", index, pluginId -> pluginId);
            this.mergePlugins(CloudConfigManager.getInstalledPlugins(), "installed_plugins.txt", index, descriptor -> descriptor.getPluginId().getIdString());
            this.writeUpdates(index);
            this.setConnected();
            this.setStreamProvider(false, reload);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void writeUpdates(Set<File> index) throws Exception {
        if (index.isEmpty()) {
            return;
        }
        this.addToFile(index, "version", CloudConfigManager.plusOne(FileUtil.loadFile((File)new File(this.myConfigDir, "version"))));
        String configPrefix = this.myConfigDir.getAbsolutePath();
        if (this.myUpdatesArchive.exists()) {
            File temp = new File(this.myCachesDir, "temp");
            FileUtil.delete((File)temp);
            CloudConfigManager.extractArchive(this.myUpdatesArchive, temp, false);
            int configPrefixLength = configPrefix.length();
            Set newUpdate = ContainerUtil.map2Set(index, file -> {
                String path = file.getAbsolutePath();
                assert (path.startsWith(configPrefix));
                return path.substring(configPrefixLength);
            });
            LinkedHashSet<File> oldUpdate = new LinkedHashSet<File>();
            String oldUpdatePrefix = temp.getAbsolutePath();
            CloudConfigManager.collectFiles(temp, oldUpdatePrefix, oldUpdate, newUpdate);
            try (SevenZOutputFile archive = new SevenZOutputFile(this.myUpdatesArchive);){
                CloudConfigManager.addToArchive(archive, oldUpdate, oldUpdatePrefix);
                CloudConfigManager.addToArchive(archive, index, configPrefix);
            }
            FileUtil.delete((File)temp);
        } else {
            CloudConfigManager.createArchive(index, this.myUpdatesArchive, configPrefix);
        }
        this.writeFile(this.myUpdatesArchive);
    }

    private static void collectFiles(@NotNull File dir, @NotNull String prefix, @NotNull Set<File> result, @NotNull Set<String> excludes) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/cloudConfig/CloudConfigManager", "collectFiles"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/cloudConfig/CloudConfigManager", "collectFiles"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/cloudConfig/CloudConfigManager", "collectFiles"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "com/intellij/cloudConfig/CloudConfigManager", "collectFiles"));
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int prefixLength = prefix.length();
        for (File file : files) {
            if (file.isDirectory()) {
                CloudConfigManager.collectFiles(file, prefix, result, excludes);
                continue;
            }
            String path = file.getAbsolutePath();
            assert (path.startsWith(prefix));
            String name = path.substring(prefixLength);
            if (excludes.contains(name)) continue;
            result.add(file);
        }
    }

    @NotNull
    private Set<File> copyConfigs(@NotNull Function2<Class, String, String> nameConverter, Class ... storageClasses) throws Exception {
        if (nameConverter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameConverter", "com/intellij/cloudConfig/CloudConfigManager", "copyConfigs"));
        }
        if (storageClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageClasses", "com/intellij/cloudConfig/CloudConfigManager", "copyConfigs"));
        }
        LinkedHashSet<File> index = new LinkedHashSet<File>();
        File optionsDir = new File(this.myIdeConfigPath, "options");
        for (Class storageClass : storageClasses) {
            File dir;
            String schemeDir;
            State spec = StoreUtil.getStateSpec((Class)storageClass);
            LOG.assertTrue(spec != null);
            String inputName = StreamProviderKt.getFileConfig(spec);
            File inputFile = new File(optionsDir, inputName);
            if (inputFile.exists() && inputFile.isFile()) {
                String outName = (String)nameConverter.invoke((Object)storageClass, (Object)inputName);
                File outFile = new File(this.myConfigDir, outName);
                FileUtil.copyContent((File)inputFile, (File)outFile);
                index.add(outFile);
            }
            if ((schemeDir = spec.additionalExportFile()).isEmpty() || !(dir = new File(this.myIdeConfigPath, schemeDir)).exists() || !dir.isDirectory()) continue;
            SchemeManagerImpl scheme = CloudConfigManager.findScheme(schemeDir);
            String schemeOutDir = (String)nameConverter.invoke((Object)storageClass, (Object)schemeDir);
            FileUtil.copyDir((File)dir, (File)new File(this.myConfigDir, schemeOutDir), childFile -> {
                String childName = childFile.getName();
                boolean canRead = scheme.canRead((CharSequence)childName);
                if (canRead) {
                    index.add(new File(this.myConfigDir, schemeOutDir + File.separator + childName));
                }
                return canRead;
            });
        }
        LinkedHashSet<File> linkedHashSet = index;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "copyConfigs"));
        }
        return linkedHashSet;
    }

    private void addPlugins(@NotNull Set<File> index) throws Exception {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "addPlugins"));
        }
        FileUtil.copyContent((File)new File(this.myIdeConfigPath, "disabled_plugins.txt"), (File)new File(this.myConfigDir, LOCAL_DISABLED_PLUGINS_FILENAME));
        this.addToFile(index, "disabled_plugins.txt", StringUtil.join(this.getDisabledPlugins(), id -> id + "\n0", (String)"\n"));
        this.addToFile(index, "installed_plugins.txt", StringUtil.join(CloudConfigManager.getInstalledPlugins(), descriptor -> descriptor.getPluginId().getIdString() + "\n0", (String)"\n"));
    }

    private <T> void mergePlugins(@NotNull List<T> localPlugins, @NotNull String name, @NotNull Set<File> files, @NotNull Function<T, String> converter) throws Exception {
        if (localPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPlugins", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/cloudConfig/CloudConfigManager", "mergePlugins"));
        }
        List<Pair<String, String>> plugins = this.loadPlugins(name);
        HashSet<String> localIds = new HashSet<String>();
        boolean update = false;
        for (T descriptor : localPlugins) {
            String id = (String)converter.fun(descriptor);
            localIds.add(id);
            update |= this.addPlugin(plugins, id);
        }
        ListIterator<Pair<String, String>> I = plugins.listIterator();
        while (I.hasNext()) {
            List ids;
            int index;
            Pair<String, String> plugin = I.next();
            if (localIds.contains(plugin.first) || (index = (ids = StringUtil.split((String)((String)plugin.second), (String)",")).indexOf(this.myOnServerMachineId)) == -1) continue;
            ids.set(index, this.myOnServerMachinePlusId);
            I.set((Pair<String, String>)Pair.create((Object)plugin.first, (Object)StringUtil.join((Collection)ids, (String)",")));
            update = true;
        }
        if (update) {
            this.savePlugins(plugins, name, files);
        }
    }

    private void removePlugins(@NotNull String name, @NotNull Set<File> index) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "removePlugins"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "removePlugins"));
        }
        List<Pair<String, String>> plugins = this.loadPlugins(name);
        boolean update = false;
        ListIterator<Pair<String, String>> I = plugins.listIterator();
        while (I.hasNext()) {
            Pair<String, String> plugin = I.next();
            List ids = StringUtil.split((String)((String)plugin.second), (String)",");
            if (!ids.remove(this.myOnServerMachineId) && !ids.remove(this.myOnServerMachineMinusId) && !ids.remove(this.myOnServerMachinePlusId)) continue;
            if (ids.stream().allMatch(id -> id.startsWith("-"))) {
                I.remove();
            } else {
                I.set((Pair<String, String>)Pair.create((Object)plugin.first, (Object)StringUtil.join((Collection)ids, (String)",")));
            }
            update = true;
        }
        if (update) {
            this.savePlugins(plugins, name, index);
        }
    }

    @NotNull
    private List<String> getDisabledPlugins() {
        ArrayList<String> disabledPlugins = new ArrayList<String>();
        PluginManagerCore.loadDisabledPlugins((String)this.myIdeConfigPath.getAbsolutePath(), disabledPlugins);
        ArrayList<String> arrayList = disabledPlugins;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getDisabledPlugins"));
        }
        return arrayList;
    }

    @NotNull
    private static List<IdeaPluginDescriptor> getInstalledPlugins() throws Exception {
        List<IdeaPluginDescriptor> plugins = new ArrayList();
        ContainerUtil.addAll(plugins, (Object[])PluginManagerCore.getPlugins());
        plugins.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
        plugins = ContainerUtil.filter(plugins, descriptor -> {
            if (descriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)descriptor).isDeleted()) {
                return false;
            }
            return !descriptor.isBundled() && descriptor.isEnabled();
        });
        if (!plugins.isEmpty()) {
            List<IdeaPluginDescriptor> repositoryPlugins = CloudConfigManager.getRepositoryPlugins();
            plugins = ContainerUtil.filter(plugins, local -> {
                PluginId id = local.getPluginId();
                return ContainerUtil.find((Iterable)repositoryPlugins, remote -> remote.getPluginId().compareTo(id) == 0) != null;
            });
        }
        List<IdeaPluginDescriptor> list = plugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getInstalledPlugins"));
        }
        return list;
    }

    @NotNull
    private static List<IdeaPluginDescriptor> getRepositoryPlugins() throws Exception {
        if (myRepositoryPlugins == null) {
            myRepositoryPlugins = (List)ApplicationManager.getApplication().executeOnPooledThread(() -> RepositoryHelper.loadPlugins(null)).get();
        }
        List<Object> list = myRepositoryPlugins == null ? Collections.emptyList() : myRepositoryPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getRepositoryPlugins"));
        }
        return list;
    }

    private void updatePluginsLaterIfNeeded(@Nullable Set<String> changedFiles) throws Exception {
        if (this.myBeforeApplicationLoadedStart) {
            ApplicationManager.getApplication().invokeLater(() -> this.safeUpdatePlugins(changedFiles));
        } else {
            this.updatePlugins(changedFiles);
        }
    }

    private void safeUpdatePlugins(@Nullable Set<String> changedFiles) {
        try {
            this.updatePlugins(changedFiles);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void updatePlugins(@Nullable Set<String> changedFiles) throws Exception {
        boolean checkDisabled = true;
        boolean checkInstalled = true;
        if (changedFiles != null) {
            if (changedFiles.isEmpty()) {
                return;
            }
            checkDisabled = changedFiles.contains("disabled_plugins.txt");
            checkInstalled = changedFiles.contains("installed_plugins.txt");
            if (!checkDisabled && !checkInstalled) {
                return;
            }
        }
        Map plugins = ContainerUtil.map2Map((Object[])PluginManagerCore.getPlugins(), descriptor -> Pair.create((Object)descriptor.getPluginId().getIdString(), (Object)descriptor));
        if (checkDisabled) {
            this.myNotDisabled = new ArrayList<IdeaPluginDescriptor>();
            for (Pair<String, String> info : this.loadPlugins("disabled_plugins.txt")) {
                IdeaPluginDescriptor plugin;
                if (this.findMachineId((String)info.second) || (plugin = (IdeaPluginDescriptor)plugins.get(info.first)) == null) continue;
                this.myNotDisabled.add(plugin);
            }
        }
        if (checkInstalled) {
            this.myNotInstalled = new ArrayList<IdeaPluginDescriptor>();
            List<IdeaPluginDescriptor> repositoryPlugins = CloudConfigManager.getRepositoryPlugins();
            for (Pair<String, String> info : this.loadPlugins("installed_plugins.txt")) {
                IdeaPluginDescriptor repositoryPlugin;
                if (this.findMachineId((String)info.second) || plugins.get(info.first) != null || (repositoryPlugin = (IdeaPluginDescriptor)ContainerUtil.find(repositoryPlugins, descriptor -> ((String)info.first).equals(descriptor.getPluginId().getIdString()))) == null) continue;
                this.myNotInstalled.add(repositoryPlugin);
            }
        }
        this.updateStatusBar(false);
        if (this.myAutoUpdatePlugins) {
            this.executePlugins();
        }
    }

    private boolean findMachineId(@NotNull String idsValue) {
        if (idsValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idsValue", "com/intellij/cloudConfig/CloudConfigManager", "findMachineId"));
        }
        List ids = StringUtil.split((String)idsValue, (String)",");
        return ids.contains(this.myOnServerMachineId) || ids.contains(this.myOnServerMachineMinusId);
    }

    public void executePlugins() {
        this.executePlugins(new ArrayList<IdeaPluginDescriptor>(this.myNotDisabled), new ArrayList<IdeaPluginDescriptor>(this.myNotInstalled));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePlugins(final @NotNull List<IdeaPluginDescriptor> disableList, final @NotNull List<IdeaPluginDescriptor> installList) {
        if (disableList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disableList", "com/intellij/cloudConfig/CloudConfigManager", "executePlugins"));
        }
        if (installList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installList", "com/intellij/cloudConfig/CloudConfigManager", "executePlugins"));
        }
        if (disableList.isEmpty() && installList.isEmpty()) {
            return;
        }
        try {
            this.mySavePluginsWithEditConfigs = false;
            for (IdeaPluginDescriptor descriptor : disableList) {
                PluginManagerCore.disablePlugin((String)descriptor.getPluginId().getIdString());
            }
        }
        finally {
            this.mySavePluginsWithEditConfigs = true;
        }
        if (installList.isEmpty()) {
            this.editConfigFiles("disabled_plugins.txt");
            this.safeUpdatePlugins(null);
            PluginManagerConfigurable.shutdownOrRestartApp();
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Download JBA Cloud Shared Plugins"){
                final List<PluginDownloader> myDownloaders;
                boolean mySuccess;
                {
                    super(arg0, arg1);
                    this.myDownloaders = new ArrayList<PluginDownloader>();
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/cloudConfig/CloudConfigManager$3", "run"));
                    }
                    for (IdeaPluginDescriptor descriptor : installList) {
                        try {
                            PluginDownloader downloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor);
                            if (!downloader.prepareToInstall(indicator)) continue;
                            this.myDownloaders.add(downloader);
                        }
                        catch (IOException e) {
                            PluginManagerMain.LOG.error((Throwable)e);
                        }
                    }
                }

                public void onSuccess() {
                    this.mySuccess = true;
                }

                public void onFinished() {
                    if (this.mySuccess) {
                        try {
                            CloudConfigManager.this.mySavePluginsWithEditConfigs = false;
                            Iterator<PluginDownloader> I = this.myDownloaders.iterator();
                            while (I.hasNext()) {
                                try {
                                    I.next().install();
                                }
                                catch (IOException e) {
                                    I.remove();
                                    PluginManagerMain.LOG.error((Throwable)e);
                                }
                            }
                        }
                        finally {
                            CloudConfigManager.this.mySavePluginsWithEditConfigs = true;
                        }
                    }
                    if (this.myDownloaders.isEmpty()) {
                        if (disableList.isEmpty()) {
                            CloudConfigManager.this.safeUpdatePlugins(null);
                        } else {
                            CloudConfigManager.this.editConfigFiles("disabled_plugins.txt");
                            CloudConfigManager.this.safeUpdatePlugins(null);
                            PluginManagerConfigurable.shutdownOrRestartApp();
                        }
                    } else {
                        if (disableList.isEmpty()) {
                            CloudConfigManager.this.editConfigFiles("installed_plugins.txt");
                        } else {
                            CloudConfigManager.this.editConfigFiles("disabled_plugins.txt", "installed_plugins.txt");
                        }
                        CloudConfigManager.this.safeUpdatePlugins(null);
                        PluginManagerConfigurable.shutdownOrRestartApp();
                    }
                }
            });
        }
    }

    @NotNull
    private static SchemeManagerImpl findScheme(final @NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/cloudConfig/CloudConfigManager", "findScheme"));
        }
        final Ref result = new Ref();
        ((SchemeManagerFactoryBase)SchemeManagerFactory.getInstance()).process((Function1)new Function1<SchemeManagerImpl<Scheme, ? extends Scheme>, Unit>(){

            public Unit invoke(SchemeManagerImpl<Scheme, ? extends Scheme> manager) {
                if (result.isNull() && fileSpec.equals(manager.getFileSpec())) {
                    result.set(manager);
                }
                return null;
            }
        });
        SchemeManagerImpl schemeManagerImpl = (SchemeManagerImpl)result.get();
        if (schemeManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "findScheme"));
        }
        return schemeManagerImpl;
    }

    private void pushToServer(@NotNull Set<File> index, boolean cleanup) throws Exception {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/cloudConfig/CloudConfigManager", "pushToServer"));
        }
        if (cleanup) {
            this.myClient.delete(CloudConfigClientUtil.getName() + "updates.7z");
        }
        CloudConfigManager.createArchive(index, this.myFilesArchive, this.myConfigDir.getAbsolutePath());
        this.writeFile(this.myFilesArchive);
        this.setConnected();
    }

    private void setConnected() throws IOException {
        this.myStatusInfo = StatusInfo.JBA_CONNECTED;
        this.storeStateIO();
        this.storeAutoUpdatePlugins();
        this.updateStatusBar(true);
    }

    private void updateStatusBar(boolean create) {
        if (this.myBeforeApplicationLoadedStart) {
            ApplicationManager.getApplication().invokeLater(() -> this.myStatusBarManager.update(create));
        } else {
            this.myStatusBarManager.update(create);
        }
    }

    public void editConfigFiles(String ... fileNames) {
        if (fileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/cloudConfig/CloudConfigManager", "editConfigFiles"));
        }
        this.updateConnection(false);
        LinkedHashSet<File> index = new LinkedHashSet<File>();
        for (String fileName : fileNames) {
            File file = new File(this.myConfigDir, fileName);
            boolean delete = !file.exists();
            index.add(file);
            if (this.myIOError) {
                this.myLocalChanges.addFile(fileName, delete);
                continue;
            }
            LOG.info("=== " + (delete ? "Delete" : "Edit") + " File: " + fileName + " ===");
        }
        if (this.myIOError) {
            return;
        }
        try {
            this.writeUpdates(index);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void editConfigFiles(@NotNull Set<String> editedFiles, @NotNull Set<String> deletedFiles) throws Exception {
        if (editedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editedFiles", "com/intellij/cloudConfig/CloudConfigManager", "editConfigFiles"));
        }
        if (deletedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deletedFiles", "com/intellij/cloudConfig/CloudConfigManager", "editConfigFiles"));
        }
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (String fileSpec : editedFiles) {
            files.add(new File(this.myConfigDir, fileSpec));
            LOG.info("=== LC->Server.Edit File: " + fileSpec + " ===");
        }
        for (String fileSpec : deletedFiles) {
            files.add(new File(this.myConfigDir, fileSpec));
            LOG.info("=== LC->Server.Delete File: " + fileSpec + " ===");
        }
        this.writeUpdates(files);
    }

    @NotNull
    private static String plusOne(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/CloudConfigManager", "plusOne"));
        }
        String string = Integer.toString(Integer.parseInt(value) + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "plusOne"));
        }
        return string;
    }

    private void storeState() {
        try {
            this.storeStateIO();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void storeStateIO() throws IOException {
        FileUtil.writeToFile((File)this.myStatusFile, (String)this.myStatusInfo.name());
    }

    private void storeAutoUpdatePlugins() {
        try {
            FileUtil.writeToFile((File)this.myAutoUpdatePluginsFile, (String)(this.myAutoUpdatePlugins ? "1" : "0"));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void setStreamProvider(boolean noProvider, boolean reload) throws Exception {
        ApplicableStreamProvider streamProvider = noProvider ? null : new ApplicableStreamProvider(this.myConfigDir, this);
        CloudConfigManager.getStateStorageManager().setStreamProvider((StreamProvider)streamProvider);
        if (!noProvider) {
            this.initListeners();
        }
        if (reload) {
            File optionsDir = noProvider ? new File(this.myIdeConfigPath, "options") : this.myConfigDir;
            CloudConfigManager.reloadComponents(optionsDir, !noProvider, null, KeymapManagerImpl.class, EditorColorsManagerImpl.class, LafManagerImpl.class);
        }
        if (noProvider) {
            this.myNotInstalled = Collections.emptyList();
            this.myNotDisabled = this.myNotInstalled;
        } else {
            this.updatePluginsLaterIfNeeded(null);
        }
    }

    private void updateFiles(boolean reload) throws Exception {
        LOG.info("=== Update Files ===");
        HashSet<String> changedFiles = new HashSet<String>();
        CloudConfigManager.extractArchive(this.myUpdatesArchive, this.myConfigDir, changedFiles);
        if (reload && !changedFiles.isEmpty()) {
            CloudConfigManager.reloadComponents(this.myConfigDir, true, changedFiles, KeymapManagerImpl.class, EditorColorsManagerImpl.class, LafManagerImpl.class);
        }
        this.updatePluginsLaterIfNeeded(changedFiles);
    }

    private static void reloadComponents(@NotNull File optionsDir, boolean streamProvider, @Nullable Set<String> changedFiles, Class ... storageClasses) {
        if (optionsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsDir", "com/intellij/cloudConfig/CloudConfigManager", "reloadComponents"));
        }
        if (storageClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageClasses", "com/intellij/cloudConfig/CloudConfigManager", "reloadComponents"));
        }
        final LinkedHashSet<String> componentNames = new LinkedHashSet<String>();
        final HashSet<StateStorage> changedStorages = new HashSet<StateStorage>();
        ArrayList<SchemeManagerImpl> schemes = new ArrayList<SchemeManagerImpl>();
        StateStorageManagerImpl storageManager = CloudConfigManager.getStateStorageManager();
        for (Class storageClass : storageClasses) {
            State spec = StoreUtil.getStateSpec((Class)storageClass);
            LOG.assertTrue(spec != null);
            boolean addComponent = false;
            String schemeDir = spec.additionalExportFile();
            if (schemeDir.length() > 0 && (changedFiles == null || changedFiles.contains(schemeDir))) {
                schemes.add(CloudConfigManager.findScheme(schemeDir));
                addComponent = true;
            }
            String name = StreamProviderKt.getFileConfig(spec);
            boolean exists = new File(optionsDir, name).exists();
            StateStorage storage = storageManager.findCachedFileStorage(name);
            LOG.assertTrue(storage instanceof XmlElementStorage);
            changedStorages.add(storage);
            ((XmlElementStorage)storage).updatedFrom(componentNames, !exists, streamProvider);
            if (!addComponent && changedFiles != null && !changedFiles.contains(name)) continue;
            componentNames.add(spec.name());
        }
        for (SchemeManagerImpl scheme : schemes) {
            scheme.reload();
        }
        Application application = ApplicationManager.getApplication();
        final ComponentStoreImpl store = (ComponentStoreImpl)ServiceKt.getStateStore((ComponentManager)application);
        final Collection notReloadableComponents = store.getNotReloadableComponents(componentNames);
        LOG.assertTrue(notReloadableComponents.isEmpty());
        StateStorageBaseKt.runBatchUpdate((MessageBus)application.getMessageBus(), (Function0)new Function0<Object>(){

            public Object invoke() {
                store.reinitComponents(componentNames, changedStorages, notReloadableComponents);
                return null;
            }
        });
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
        LOG.info("=== Reload components: " + componentNames + " ===");
    }

    private static boolean isStreamProviderEnabled() {
        StreamProvider provider = CloudConfigManager.getStateStorageManager().getStreamProvider();
        return provider != null && provider.getEnabled();
    }

    @NotNull
    public static StateStorageManagerImpl getStateStorageManager() {
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStateStorageManager();
        if (stateStorageManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "getStateStorageManager"));
        }
        return stateStorageManagerImpl;
    }

    private static boolean filterOsName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/cloudConfig/CloudConfigManager", "filterOsName"));
        }
        if (!fileName.startsWith(CloudConfigClientUtil.getOS() + ".")) {
            for (String name : OS_NAMES) {
                if (!fileName.startsWith(name + ".")) continue;
                return false;
            }
        }
        return true;
    }

    public static void createArchive(@NotNull Set<File> files, @NotNull File outFile, @NotNull String prefix) throws Exception {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/cloudConfig/CloudConfigManager", "createArchive"));
        }
        if (outFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outFile", "com/intellij/cloudConfig/CloudConfigManager", "createArchive"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/cloudConfig/CloudConfigManager", "createArchive"));
        }
        FileUtil.createParentDirs((File)outFile);
        try (SevenZOutputFile archive = new SevenZOutputFile(outFile);){
            CloudConfigManager.addToArchive(archive, files, prefix);
        }
    }

    private static void addToArchive(SevenZOutputFile archive, @NotNull Set<File> files, @NotNull String prefix) throws IOException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/cloudConfig/CloudConfigManager", "addToArchive"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/cloudConfig/CloudConfigManager", "addToArchive"));
        }
        prefix = prefix + File.separator;
        int length = prefix.length();
        for (File file : files) {
            String path = file.getAbsolutePath();
            assert (path.startsWith(prefix));
            String name = path.substring(length);
            if (File.separatorChar != '/') {
                name = name.replace(File.separatorChar, '/');
            }
            archive.putArchiveEntry((ArchiveEntry)archive.createArchiveEntry(file, name));
            if (file.exists() && file.isFile()) {
                archive.write(FileUtil.loadFileBytes((File)file));
            }
            archive.closeArchiveEntry();
        }
    }

    private static void extractArchive(@NotNull File archiveFile, @NotNull File outDir, boolean delete) throws Exception {
        if (archiveFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archiveFile", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        if (outDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outDir", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        try (SevenZFile archive = new SevenZFile(archiveFile);){
            SevenZArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (entry.isDirectory() || !CloudConfigManager.filterOsName(entry.getName())) continue;
                File file = new File(outDir, entry.getName());
                int size = (int)entry.getSize();
                if (delete && size == 0) {
                    FileUtil.delete((File)file);
                    continue;
                }
                FileUtil.writeToFile((File)file, (byte[])CloudConfigClientUtil.loadBytes((SevenZFile)archive, (int)size));
            }
        }
    }

    private static void extractArchive(@NotNull File archiveFile, @NotNull File outDir, @NotNull Set<String> changedFiles) throws Exception {
        if (archiveFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archiveFile", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        if (outDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outDir", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/cloudConfig/CloudConfigManager", "extractArchive"));
        }
        try (SevenZFile archive = new SevenZFile(archiveFile);){
            SevenZArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                File file = new File(outDir, fileName);
                int size = (int)entry.getSize();
                boolean change = false;
                if (size == 0) {
                    if (file.exists()) {
                        FileUtil.delete((File)file);
                        change = true;
                        LOG.info("=== Update File(Delete): " + fileName + " ===");
                    }
                } else if (CloudConfigManager.filterOsName(fileName)) {
                    byte[] oldBytes = file.isFile() && file.exists() ? FileUtil.loadFileBytes((File)file) : null;
                    byte[] newBytes = CloudConfigClientUtil.loadBytes((SevenZFile)archive, (int)((int)entry.getSize()));
                    if (!Arrays.equals(newBytes, oldBytes)) {
                        FileUtil.writeToFile((File)file, (byte[])newBytes);
                        if (!"version".equals(fileName)) {
                            change = true;
                            LOG.info("=== Update File(Edit): " + fileName + " ===");
                        }
                    }
                }
                if (!change) continue;
                changedFiles.add(StringUtil.defaultIfEmpty((String)StringUtil.substringBefore((String)fileName, (String)"/"), (String)fileName));
            }
        }
    }

    @NotNull
    private List<String> list(@NotNull String file) throws IOException {
        List list;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cloudConfig/CloudConfigManager", "list"));
        }
        try {
            List result = this.myClient.list(CloudConfigClientUtil.getName() + file);
            this.myNetworkStatistics.addBytes(result);
            this.myIOError = false;
            List list2 = result;
            list = list2;
        }
        catch (IOException e) {
            this.myIOError = true;
            throw e;
        }
        finally {
            this.myNetworkStatistics.save();
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/CloudConfigManager", "list"));
        }
        return list;
    }

    @Nullable
    private Boolean getFile(@NotNull String name) throws IOException {
        InputStream stream;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/cloudConfig/CloudConfigManager", "getFile"));
        }
        File file = new File(this.myCachesDir, name);
        try {
            stream = this.myClient.read(CloudConfigClientUtil.getName() + name);
            this.myIOError = false;
        }
        catch (FileNotFoundException ignored) {
            FileUtil.delete((File)file);
            return null;
        }
        catch (IOException e) {
            this.myIOError = true;
            throw e;
        }
        if (stream != null) {
            FileUtil.createParentDirs((File)file);
            try (InputStream inputStream = stream;
                 FileOutputStream outputStream = new FileOutputStream(file);){
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                this.myNetworkStatistics.addBytes(file);
                this.myIOError = false;
            }
            catch (IOException e) {
                this.myIOError = true;
                throw e;
            }
            finally {
                this.myNetworkStatistics.save();
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void writeFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cloudConfig/CloudConfigManager", "writeFile"));
        }
        try (FileInputStream stream = new FileInputStream(file);){
            this.myClient.write(CloudConfigClientUtil.getName() + file.getName(), (InputStream)stream);
            this.myNetworkStatistics.addBytes(file);
            this.myIOError = false;
        }
        catch (IOException e) {
            this.myIOError = true;
            throw e;
        }
        finally {
            this.myNetworkStatistics.save();
        }
    }

    private static void logDebug(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/CloudConfigManager", "logDebug"));
        }
        LOG.debug((Throwable)e);
    }

    static /* synthetic */ File access$1100(CloudConfigManager x0) {
        return x0.myConfigDir;
    }

    static {
        KEYMAP_CONVERTER = (storageClass, name) -> {
            if (storageClass == KeymapManagerImpl.class) {
                return CloudConfigClientUtil.getOS() + "." + name;
            }
            return name;
        };
        OS_NAMES = new String[]{"mac", "win", "linux", "freebsd", "unix", "unknown"};
    }

    private class LocalChanges {
        private final Set<String> myEditedFiles = new LinkedHashSet<String>();
        private final Set<String> myDeletedFiles = new LinkedHashSet<String>();
        private final File myFile = new File(CloudConfigManager.access$1100(CloudConfigManager.this), "local.changes");

        private LocalChanges() {
        }

        public void load() {
            try {
                if (this.myFile.exists()) {
                    Set<String> lines = this.myEditedFiles;
                    for (String line : FileUtil.loadLines((File)this.myFile)) {
                        if (line.isEmpty()) {
                            lines = this.myDeletedFiles;
                            continue;
                        }
                        lines.add(line);
                    }
                    LOG.info("=== Local Changes: " + this.myEditedFiles + " : " + this.myDeletedFiles + " ===");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        public void addFile(String file, boolean delete) {
            LOG.info("=== LC." + (delete ? "Delete" : "Edit") + " File: " + file + " ===");
            if (delete) {
                this.myEditedFiles.remove(file);
                this.myDeletedFiles.add(file);
            } else {
                this.myEditedFiles.add(file);
                this.myDeletedFiles.remove(file);
            }
            if (this.isEmpty()) {
                FileUtil.delete((File)this.myFile);
            } else {
                this.doSave();
            }
        }

        private boolean isEmpty() {
            return this.myEditedFiles.isEmpty() && this.myDeletedFiles.isEmpty();
        }

        private void doSave() {
            try {
                FileUtil.writeToFile((File)this.myFile, (String)(StringUtil.join(this.myEditedFiles, (String)"\n") + (this.myEditedFiles.isEmpty() ? "" : "\n") + "\n" + StringUtil.join(this.myDeletedFiles, (String)"\n")));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        public void apply() {
            if (CloudConfigManager.this.myIOError || this.isEmpty()) {
                return;
            }
            try {
                CloudConfigManager.this.editConfigFiles(this.myEditedFiles, this.myDeletedFiles);
                this.clean();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        public void clean() {
            this.myEditedFiles.clear();
            this.myDeletedFiles.clear();
            FileUtil.delete((File)this.myFile);
        }
    }

    static enum ConnectionState {
        OLD,
        NEW,
        UPDATE,
        DELETE,
        IO_ERROR;

    }
}

