/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0006J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eJ\r\u0010\u001f\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b J\r\u0010!\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\"J\u0006\u0010#\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/intellij/cloudConfig/NetworkStatistics;", "", "()V", "FORMAT", "Ljava/text/SimpleDateFormat;", "myBytes", "", "getMyBytes", "()J", "setMyBytes", "(J)V", "myDate", "", "getMyDate", "()Ljava/lang/String;", "setMyDate", "(Ljava/lang/String;)V", "myFile", "Ljava/io/File;", "getMyFile", "()Ljava/io/File;", "myProperties", "Ljava/util/Properties;", "getMyProperties", "()Ljava/util/Properties;", "addBytes", "", "file", "bytes", "words", "", "getDate", "getDate$cloud_config", "load", "load$cloud_config", "save", "cloud-config"})
public final class NetworkStatistics {
    private final SimpleDateFormat FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    @NotNull
    private final Properties myProperties = new Properties();
    @NotNull
    private final File myFile = new File(PathManager.getSystemPath(), "jba_config_traffic.txt");
    private long myBytes;
    @NotNull
    private String myDate = "";

    @NotNull
    public final Properties getMyProperties() {
        return this.myProperties;
    }

    @NotNull
    public final File getMyFile() {
        return this.myFile;
    }

    public final long getMyBytes() {
        return this.myBytes;
    }

    public final void setMyBytes(long l) {
        this.myBytes = l;
    }

    @NotNull
    public final String getMyDate() {
        return this.myDate;
    }

    public final void setMyDate(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.myDate = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load$cloud_config() {
        if (this.myBytes > (long)0) {
            return;
        }
        if (this.myFile.exists()) {
            FileInputStream stream = new FileInputStream(this.myFile);
            try {
                this.myProperties.load(stream);
            }
            finally {
                stream.close();
            }
            this.myDate = this.getDate$cloud_config();
            String property = this.myProperties.getProperty(this.myDate);
            if (property != null) {
                long l;
                String string = StringsKt.substringBefore((String)property, (String)" ", (String)property);
                NetworkStatistics networkStatistics = this;
                networkStatistics.myBytes = l = Long.parseLong(string);
            }
        }
    }

    @NotNull
    public final String getDate$cloud_config() {
        String string = this.FORMAT.format(new Date());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FORMAT.format(Date())");
        return string;
    }

    public final void addBytes(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.addBytes(file.length());
    }

    public final void addBytes(@NotNull List<String> words) {
        Intrinsics.checkParameterIsNotNull(words, (String)"words");
        long bytes = 0L;
        for (String word : words) {
            bytes += (long)word.length();
        }
        this.addBytes(bytes);
    }

    public final void addBytes(long bytes) {
        try {
            this.load$cloud_config();
            String date = this.getDate$cloud_config();
            if (!date.equals(this.myDate)) {
                this.myBytes = 0L;
                this.myDate = date;
            }
            this.myBytes += bytes;
            this.myProperties.setProperty(this.myDate, String.valueOf(this.myBytes) + " // " + StringUtil.formatFileSize((long)this.myBytes));
        }
        catch (Exception e) {
            Throwable throwable = e;
            Throwable throwable2 = throwable;
            if (throwable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
            }
            throwable2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        try {
            FileOutputStream stream = new FileOutputStream(this.myFile);
            try {
                this.myProperties.store(stream, (String)null);
            }
            finally {
                stream.close();
            }
        }
        catch (Throwable e) {
            Throwable throwable = e;
            Throwable throwable2 = throwable;
            if (throwable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
            }
            throwable2.printStackTrace();
        }
    }
}

