/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.stubs.index.DomElementClassIndex;
import com.intellij.util.xml.stubs.index.DomNamespaceKeyIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDomUtils {
    public static void navigate(@Nullable DomElement domElement) {
        if (domElement == null) {
            return;
        }
        DomElementsNavigationManager navigationManager = DomElementsNavigationManager.getManager((Project)domElement.getManager().getProject());
        navigationManager.getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME).navigate(domElement, true);
    }

    public static boolean isSpringXml(@NotNull XmlFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/dom/SpringDomUtils", "isSpringXml"));
        }
        return SpringDomUtils.getSpringDomFileElement(configFile) != null;
    }

    @Nullable
    public static DomFileElement<Beans> getSpringDomFileElement(@NotNull XmlFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/dom/SpringDomUtils", "getSpringDomFileElement"));
        }
        return DomManager.getDomManager((Project)configFile.getProject()).getFileElement(configFile, Beans.class);
    }

    public static boolean hasNamespace(DomFileElement domFileElement, String namespaceKey) {
        return DomNamespaceKeyIndex.getInstance().hasStubElementsWithNamespaceKey(domFileElement, namespaceKey);
    }

    public static boolean hasElement(DomFileElement domFileElement, Class<? extends DomElement> domElementClazz) {
        return DomElementClassIndex.getInstance().hasStubElementsOfType(domFileElement, domElementClazz);
    }
}

