/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringImplicitBeanWithDefinition
extends CommonModelElement.PsiBase
implements CommonSpringBean {
    @NotNull
    private final String myName;
    @NotNull
    private final PsiClass myClass;
    @NotNull
    private final CommonSpringBean myDefiningBean;
    @NotNull
    private final PsiTarget myDefinitionTarget;

    public SpringImplicitBeanWithDefinition(@NotNull String beanName, @NotNull PsiClass beanClass, @NotNull CommonSpringBean definingBean, @NotNull PsiTarget definitionTarget) {
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/SpringImplicitBeanWithDefinition", "<init>"));
        }
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/model/SpringImplicitBeanWithDefinition", "<init>"));
        }
        if (definingBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definingBean", "com/intellij/spring/model/SpringImplicitBeanWithDefinition", "<init>"));
        }
        if (definitionTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionTarget", "com/intellij/spring/model/SpringImplicitBeanWithDefinition", "<init>"));
        }
        this.myName = beanName;
        this.myClass = beanClass;
        this.myDefiningBean = definingBean;
        this.myDefinitionTarget = definitionTarget;
    }

    @Override
    @Nullable
    public String getBeanName() {
        return this.myName;
    }

    @Override
    @NotNull
    public String[] getAliases() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringImplicitBeanWithDefinition", "getAliases"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    @Nullable
    public PsiType getBeanType(boolean considerFactories) {
        return this.getBeanType();
    }

    @Override
    @Nullable
    public PsiType getBeanType() {
        return JavaPsiFacade.getElementFactory((Project)this.myClass.getProject()).createType(this.myClass);
    }

    @Override
    @Nullable
    public SpringQualifier getSpringQualifier() {
        return DefaultSpringBeanQualifier.create(this);
    }

    @Override
    @NotNull
    public SpringProfile getProfile() {
        SpringProfile springProfile = this.myDefiningBean.getProfile();
        if (springProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringImplicitBeanWithDefinition", "getProfile"));
        }
        return springProfile;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiElement psiElement = this.myDefinitionTarget.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringImplicitBeanWithDefinition", "getPsiElement"));
        }
        return psiElement;
    }

    public PsiElement getIdentifyingPsiElement() {
        return PomService.convertToPsi((Project)this.myDefiningBean.getPsiManager().getProject(), (PomTarget)this.myDefinitionTarget);
    }
}

