/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.AccessToken;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;

public class LockToken
extends AccessToken {
    private final Lock myLock;

    private LockToken(Lock lock) {
        this.myLock = lock;
    }

    @Override
    public void finish() {
        this.myLock.unlock();
    }

    @NotNull
    public static LockToken acquireLock(@NotNull Lock lock) {
        if (lock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lock", "com/intellij/util/concurrency/LockToken", "acquireLock"));
        }
        lock.lock();
        LockToken lockToken = new LockToken(lock);
        if (lockToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/LockToken", "acquireLock"));
        }
        return lockToken;
    }
}

